/*
 * Decompiled with CFR 0.152.
 */
package me.munchii.industrialreborn.storage.entity;

import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import reborncore.common.util.NBTSerializable;

public class StoredEntityData
implements NBTSerializable {
    private class_2487 entityTag = new class_2487();
    private float maxHealth = 0.0f;
    public static final String KEY_ID = "id";
    public static final String KEY_ENTITY = "Entity";
    private static final String KEY_HEALTH = "Health";
    private static final String KEY_MAX_HEALTH = "MaxHealth";

    public static StoredEntityData of(class_1309 entity) {
        StoredEntityData data = new StoredEntityData();
        data.entityTag = StoredEntityData.livingEntitySerializeNBT(entity);
        data.maxHealth = entity.method_6063();
        return data;
    }

    public static StoredEntityData of(class_2960 entityType) {
        class_2487 nbt = new class_2487();
        nbt.method_10582(KEY_ID, entityType.toString());
        StoredEntityData data = new StoredEntityData();
        data.entityTag = nbt;
        data.maxHealth = 0.0f;
        return data;
    }

    public static StoredEntityData empty() {
        StoredEntityData data = new StoredEntityData();
        data.maxHealth = 0.0f;
        return data;
    }

    public Optional<class_2960> getEntityType() {
        class_2487 nbt = this.entityTag;
        if (nbt.method_10545(KEY_ID)) {
            return Optional.of(new class_2960(nbt.method_10558(KEY_ID)));
        }
        return Optional.empty();
    }

    public class_2487 getEntityTag() {
        return this.entityTag;
    }

    public Optional<class_3545<Float, Float>> getHealthState() {
        class_2487 nbt;
        if (this.maxHealth > 0.0f && (nbt = this.entityTag).method_10545(KEY_HEALTH)) {
            return Optional.of(new class_3545((Object)Float.valueOf(nbt.method_10583(KEY_HEALTH)), (Object)Float.valueOf(this.maxHealth)));
        }
        return Optional.empty();
    }

    @NotNull
    public class_2487 write() {
        class_2487 nbt = new class_2487();
        nbt.method_10566(KEY_ENTITY, (class_2520)this.entityTag);
        if (this.maxHealth > 0.0f) {
            nbt.method_10548(KEY_MAX_HEALTH, this.maxHealth);
        }
        return nbt;
    }

    public void read(@NotNull class_2487 nbtCompound) {
        this.entityTag = nbtCompound.method_10562(KEY_ENTITY);
        if (nbtCompound.method_10545(KEY_MAX_HEALTH)) {
            this.maxHealth = nbtCompound.method_10583(KEY_MAX_HEALTH);
        }
    }

    public static class_2487 livingEntitySerializeNBT(class_1309 entity) {
        class_2487 nbt = new class_2487();
        nbt.method_10582(KEY_ID, ((class_5321)class_7923.field_41177.method_29113((Object)entity.method_5864()).get()).method_29177().toString());
        nbt.method_10548(KEY_HEALTH, entity.method_6032());
        return nbt;
    }
}

