/*
 * Decompiled with CFR 0.152.
 */
package me.munchii.industrialreborn.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import me.munchii.industrialreborn.client.ClientGuiType;
import me.munchii.industrialreborn.client.render.DynamicBucketBakedModel;
import me.munchii.industrialreborn.init.IRBlockEntities;
import me.munchii.industrialreborn.init.IRContent;
import me.munchii.industrialreborn.init.IRFluids;
import me.munchii.industrialreborn.utils.Resources;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5616;
import net.minecraft.class_7775;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;
import reborncore.client.multiblock.MultiblockRenderer;
import techreborn.client.render.BaseDynamicFluidBakedModel;

@Environment(value=EnvType.CLIENT)
public class IndustrialRebornClient
implements ClientModInitializer {
    public void onInitializeClient() {
        this.registerBuckets();
        this.setupTextures();
        this.registerMultiblocks();
        ClientGuiType.validate();
    }

    private void setupTextures() {
        BlockRenderLayerMap.INSTANCE.putBlock(IRContent.BROKEN_SPAWNER, class_1921.method_23583());
        Arrays.stream(IRFluids.values()).forEach(fluid -> {
            BlockRenderLayerMap.INSTANCE.putFluid((class_3611)fluid.getFluid(), class_1921.method_23583());
            BlockRenderLayerMap.INSTANCE.putFluid((class_3611)fluid.getFlowingFluid(), class_1921.method_23583());
        });
    }

    private void registerBuckets() {
        ModelLoadingPlugin.register(pluginContext -> {
            pluginContext.addModels(new class_2960[]{new class_1091(Resources.id("bucket_base"), "inventory"), new class_1091(Resources.id("bucket_fluid"), "inventory"), new class_1091(Resources.id("bucket_background"), "inventory")});
            pluginContext.resolveModel().register(context -> {
                class_2960 id = context.id();
                if (!id.method_12836().equals("industrialreborn") || !id.method_12832().startsWith("item/")) {
                    return null;
                }
                String path = id.method_12832().replace("item/", "");
                class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(Resources.id(path.split("_bucket")[0]));
                if (path.endsWith("_bucket") && fluid != class_3612.field_15906) {
                    if (!RendererAccess.INSTANCE.hasRenderer()) {
                        return class_793.method_3430((String)"{\"parent\":\"minecraft:item/generated\",\"textures\":{\"layer0\":\"minecraft:item/bucket\"}}");
                    }
                    return new UnbakedDynamicModel(DynamicBucketBakedModel::new);
                }
                return null;
            });
        });
    }

    private void registerMultiblocks() {
        class_5616.method_32144(IRBlockEntities.POWERED_SPAWNER, MultiblockRenderer::new);
        class_5616.method_32144(IRBlockEntities.MOB_SLAUGHTER, MultiblockRenderer::new);
        class_5616.method_32144(IRBlockEntities.SOUL_EXTRACTOR, MultiblockRenderer::new);
        class_5616.method_32144(IRBlockEntities.ANIMAL_FEEDER, MultiblockRenderer::new);
        class_5616.method_32144(IRBlockEntities.ANIMAL_BABY_SEPARATOR, MultiblockRenderer::new);
    }

    private record UnbakedDynamicModel(Supplier<BaseDynamicFluidBakedModel> supplier) implements class_1100
    {
        public Collection<class_2960> method_4755() {
            return Collections.emptyList();
        }

        public void method_45785(Function<class_2960, class_1100> modelLoader) {
        }

        @Nullable
        public class_1087 method_4753(class_7775 baker, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
            return (class_1087)this.supplier.get();
        }
    }
}

