/*
 * Decompiled with CFR 0.152.
 */
package me.munchii.industrialreborn.blockentity;

import java.util.List;
import me.munchii.industrialreborn.blockentity.IRangedBlockEntity;
import me.munchii.industrialreborn.config.IndustrialRebornConfig;
import me.munchii.industrialreborn.init.IRBlockEntities;
import me.munchii.industrialreborn.init.IRContent;
import me.munchii.industrialreborn.init.IRFluids;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.fluid.FluidValue;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.Syncable;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.blockentity.machine.GenericMachineBlockEntity;

public class SoulExtractorBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider,
IRangedBlockEntity {
    public int extractionTime = 0;
    public final int totalExtractionTime = IndustrialRebornConfig.soulExtractorTicksPerExtraction;
    public final int extractionRadius = IndustrialRebornConfig.soulExtractorRadius;
    public int extraRadius = 0;
    public final Tank essenceTank;
    private class_2338 centerPos;
    private class_238 extractArea;
    @Nullable
    private class_1308 currentTarget;

    public SoulExtractorBlockEntity(class_2338 pos, class_2680 state) {
        super(IRBlockEntities.SOUL_EXTRACTOR, pos, state, "SoulExtractor", IndustrialRebornConfig.soulExtractorMaxInput, IndustrialRebornConfig.soulExtractorMaxEnergy, IRContent.Machine.SOUL_EXTRACTOR.block, 0);
        this.inventory = new RebornInventory(1, "SoulExtractorBlockEntity", 64, (MachineBaseBlockEntity)this);
        this.essenceTank = new Tank("SoulExtractorBlockEntity", FluidValue.BUCKET.multiply(16L), (MachineBaseBlockEntity)this);
        this.essenceTank.setFluid((class_3611)IRFluids.SOUL_ESSENCE.getFluid());
    }

    @NotNull
    public Tank getTank() {
        return this.essenceTank;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (!(world instanceof class_3218) || !this.isActive(RedstoneConfiguration.POWER_IO)) {
            return;
        }
        if (this.centerPos == null) {
            this.centerPos = pos.method_10079(this.getFacing().method_10153(), this.getRadius() + 1);
        }
        if (this.extractArea == null) {
            int radius = this.getRadius();
            this.extractArea = new class_238((double)(this.centerPos.method_10263() - radius), (double)this.centerPos.method_10264(), (double)(this.centerPos.method_10260() - radius), (double)(this.centerPos.method_10263() + radius), (double)(this.centerPos.method_10264() + 3), (double)(this.centerPos.method_10260() + radius));
        }
        this.updateState();
        if (this.getStored() > (long)IndustrialRebornConfig.soulExtractorEnergyPerExtraction && !this.essenceTank.isFull()) {
            if (this.extractionTime >= this.totalExtractionTime) {
                boolean res = this.extractSoul(world);
                if (res) {
                    this.useEnergy(IndustrialRebornConfig.soulExtractorEnergyPerExtraction);
                }
                this.extractionTime = 0;
            } else {
                ++this.extractionTime;
            }
        }
    }

    private boolean extractSoul(class_1937 world) {
        if (this.currentTarget == null) {
            class_1308 target = this.getTarget();
            if (target == null) {
                return false;
            }
            this.currentTarget = target;
        }
        this.currentTarget.method_6033(this.currentTarget.method_6032() - IndustrialRebornConfig.soulExtractorAttackDamage);
        if (this.currentTarget.method_6032() <= 0.0f) {
            ((class_3218)world).method_14199((class_2394)class_2398.field_11251, this.currentTarget.method_23317(), this.currentTarget.method_23318(), this.currentTarget.method_23321(), 50, 0.0, 0.0, 0.0, 0.0);
            this.currentTarget.method_5650(class_1297.class_5529.field_26998);
        }
        this.insertFluid(FluidValue.fromMillibuckets((long)Math.round(this.currentTarget.method_6063() * (float)IndustrialRebornConfig.soulExtractorEssenceMultiplier)));
        if (this.currentTarget.method_29504()) {
            this.currentTarget = null;
        }
        return true;
    }

    @Nullable
    private class_1308 getTarget() {
        class_3218 serverWorld = (class_3218)this.field_11863;
        assert (serverWorld != null);
        List nearbyEntities = serverWorld.method_8390(class_1308.class, this.extractArea, entity -> entity.method_5805() && !entity.method_5655() && (!(entity instanceof class_1528) || ((class_1528)entity).method_6884() <= 0));
        if (!nearbyEntities.isEmpty()) {
            return (class_1308)nearbyEntities.get(0);
        }
        return null;
    }

    public int getRadius() {
        return this.extractionRadius + this.extraRadius;
    }

    @Override
    public void addRange(int range) {
        this.extraRadius += range;
        this.centerPos = null;
        this.extractArea = null;
    }

    @Override
    public void addRangeMultiplier(float multiplier) {
        this.extraRadius += Math.round((float)this.getRadius() * multiplier);
        this.centerPos = null;
        this.extractArea = null;
    }

    private void updateState() {
        assert (this.field_11863 != null);
        class_2680 blockState = this.field_11863.method_8320(this.field_11867);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof BlockMachineBase) {
            boolean active;
            BlockMachineBase blockMachineBase = (BlockMachineBase)class_22482;
            boolean bl = active = !this.essenceTank.isFull() && this.getStored() > (long)IndustrialRebornConfig.soulExtractorEnergyPerExtraction;
            if ((Boolean)blockState.method_11654((class_2769)BlockMachineBase.ACTIVE) != active) {
                blockMachineBase.setActive(Boolean.valueOf(active), this.field_11863, this.field_11867);
            }
        }
    }

    private void insertFluid(FluidValue amount) {
        if (this.essenceTank.getFluidAmount().add(amount).equalOrMoreThan(FluidValue.BUCKET.multiply(16L))) {
            this.setEssenceAmount(FluidValue.BUCKET.multiply(16L));
            return;
        }
        this.setEssenceAmount(this.essenceTank.getFluidAmount().add(amount));
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("mob_slaughter").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).energySlot(0, 8, 72).syncEnergyValue().sync(this::getEssenceAmount, this::setEssenceAmount).sync(this::getExtractionTime, this::setExtractionTime).sync(this::getTotalExtractionTime, this::setTotalExtractionTime).sync((Syncable)this.essenceTank).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public void writeMultiblock(MultiblockWriter writer) {
        class_2680 glass = class_2246.field_10272.method_9564();
        int radius = this.getRadius();
        int diameter = radius * 2 + 1;
        for (int i = 1; i <= diameter; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                writer.add(i, 0, j, (world, pos) -> true, glass);
                writer.add(i, 1, j, (world, pos) -> true, glass);
                writer.add(i, 2, j, (world, pos) -> true, glass);
            }
        }
    }

    public class_1799 getToolDrop(class_1657 p0) {
        return IRContent.Machine.SOUL_EXTRACTOR.getStack();
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.getTank().read(tag);
        this.centerPos = null;
        this.extractArea = null;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.getTank().write(tag);
    }

    public void resetUpgrades() {
        super.resetUpgrades();
        this.extraRadius = 0;
    }

    public FluidValue getEssenceAmount() {
        return this.essenceTank.getFluidAmount();
    }

    public void setEssenceAmount(FluidValue amount) {
        this.essenceTank.setFluidAmount(amount);
    }

    public int getExtractionTime() {
        return this.extractionTime;
    }

    public void setExtractionTime(int extractionTime) {
        this.extractionTime = extractionTime;
    }

    public int getTotalExtractionTime() {
        return this.totalExtractionTime;
    }

    public void setTotalExtractionTime(int totalExtractionTime) {
    }
}

