/*
 * Decompiled with CFR 0.152.
 */
package me.munchii.industrialreborn.blockentity;

import java.util.Objects;
import java.util.Optional;
import me.munchii.industrialreborn.blockentity.IRangedBlockEntity;
import me.munchii.industrialreborn.config.IndustrialRebornConfig;
import me.munchii.industrialreborn.init.IRBlockEntities;
import me.munchii.industrialreborn.init.IRContent;
import me.munchii.industrialreborn.storage.entity.EntityStorage;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import techreborn.blockentity.machine.GenericMachineBlockEntity;

public class PoweredSpawnerBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider,
IRangedBlockEntity {
    public int spawnTime = 0;
    public int totalSpawnTime = IndustrialRebornConfig.poweredSpawnerTicksPerSpawn;
    public final int vialSlot = 0;
    public final int spawnRange = IndustrialRebornConfig.poweredSpawnerSpawnRange;
    public int extraRange = 0;
    public final EntitySoulStore entityStore = new EntitySoulStore();

    public PoweredSpawnerBlockEntity(class_2338 pos, class_2680 state) {
        super(IRBlockEntities.POWERED_SPAWNER, pos, state, "PoweredSpawner", IndustrialRebornConfig.poweredSpawnerMaxInput, IndustrialRebornConfig.poweredSpawnerMaxEnergy, IRContent.Machine.POWERED_SPAWNER.block, 1);
        this.inventory = new RebornInventory(2, "PoweredSpawnerBlockEntity", 1, (MachineBaseBlockEntity)this);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (!(world instanceof class_3218) || !this.isActive(RedstoneConfiguration.POWER_IO)) {
            return;
        }
        if (!this.inventory.method_5438(0).method_7960() && !this.entityStore.hasStoredSoul()) {
            this.entityStore.storeSoul(this.inventory.method_5438(0));
            this.updateState();
        } else if (this.inventory.method_5438(0).method_7960() && this.entityStore.hasStoredSoul()) {
            this.entityStore.emptyStore();
            this.updateState();
        }
        this.updateState();
        if (this.getStored() > (long)IndustrialRebornConfig.poweredSpawnerEnergyPerSpawn) {
            if (this.entityStore.hasStoredSoul()) {
                if (this.spawnTime == this.totalSpawnTime) {
                    PoweredSpawnerBlockEntity.spawnEntity(world, pos, this.entityStore.entityTag, this.getRange());
                    this.useEnergy(IndustrialRebornConfig.poweredSpawnerEnergyPerSpawn);
                    this.spawnTime = 0;
                } else {
                    ++this.spawnTime;
                }
            } else if (this.spawnTime > 0) {
                this.spawnTime = 0;
            }
        }
    }

    private static void spawnEntity(class_1937 world, class_2338 pos, class_2487 entityTag, int range) {
        class_243 spawnPos = new class_2338(pos.method_10263() + world.field_9229.method_39332(-range, range), pos.method_10264() - 1, pos.method_10260() + world.field_9229.method_39332(-range, range)).method_46558().method_1031(0.0, 0.5, 0.0);
        Optional entity = class_1299.method_5892((class_2487)entityTag, (class_1937)world);
        entity.ifPresent(ent -> {
            ent.method_33574(spawnPos);
            ent.method_5832(class_2470.method_16548((class_5819)world.method_8409()));
            world.method_8649(ent);
        });
    }

    public int getRange() {
        return this.spawnRange + this.extraRange;
    }

    @Override
    public void addRange(int range) {
        this.extraRange += range;
    }

    @Override
    public void addRangeMultiplier(float multiplier) {
        this.extraRange += Math.round((float)this.spawnRange * multiplier);
    }

    private void updateState() {
        assert (this.field_11863 != null);
        class_2680 blockState = this.field_11863.method_8320(this.field_11867);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof BlockMachineBase) {
            boolean active;
            BlockMachineBase blockMachineBase = (BlockMachineBase)class_22482;
            boolean bl = active = this.entityStore.hasStoredSoul() && this.getStored() > (long)IndustrialRebornConfig.poweredSpawnerEnergyPerSpawn;
            if ((Boolean)blockState.method_11654((class_2769)BlockMachineBase.ACTIVE) != active) {
                blockMachineBase.setActive(Boolean.valueOf(active), this.field_11863, this.field_11867);
            }
        }
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("powered_spawner").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).filterSlot(0, 80, 54, PoweredSpawnerBlockEntity::filledVialFilter).energySlot(1, 8, 72).syncEnergyValue().sync(this::getSpawnTime, this::setSpawnTime).sync(this::getTotalSpawnTime, this::setTotalSpawnTime).sync(this::getEntityType, this::setEntityType).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public void writeMultiblock(MultiblockWriter writer) {
        class_2680 glass = class_2246.field_10272.method_9564();
        int range = this.getRange();
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                writer.add(i, 0, j, (world, pos) -> true, glass);
            }
        }
    }

    public static boolean filledVialFilter(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item == IRContent.FILLED_SOUL_VIAL) {
            return EntityStorage.hasStoredEntity(stack);
        }
        return false;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
    }

    public void resetUpgrades() {
        super.resetUpgrades();
        this.extraRange = 0;
    }

    public int getScaledSpawnTime(int i) {
        return (int)((float)this.spawnTime / (float)this.totalSpawnTime * (float)i);
    }

    public int getSpawnTime() {
        return this.spawnTime;
    }

    public void setSpawnTime(int spawnTime) {
        this.spawnTime = spawnTime;
    }

    public int getTotalSpawnTime() {
        return this.totalSpawnTime;
    }

    public void setTotalSpawnTime(int totalSpawnTime) {
        this.totalSpawnTime = totalSpawnTime;
    }

    public String getEntityType() {
        return this.entityStore.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityStore.entityType = entityType;
    }

    public class EntitySoulStore {
        public String entityType = "";
        @Nullable
        public class_2487 entityTag = null;

        public void storeSoul(class_1799 soulVial) {
            Optional<class_2487> tag = EntityStorage.getEntityDataCompound(soulVial);
            tag.ifPresent(nbtCompound -> {
                this.entityTag = nbtCompound;
                Optional entity = class_1299.method_5892((class_2487)this.entityTag, (class_1937)PoweredSpawnerBlockEntity.this.field_11863);
                entity.ifPresent(ent -> {
                    this.entityType = Objects.requireNonNull(ent.method_5476()).getString();
                });
            });
        }

        public void emptyStore() {
            this.entityType = "";
            this.entityTag = null;
        }

        public boolean hasStoredSoul() {
            return this.entityTag != null;
        }
    }
}

