/*
 * Decompiled with CFR 0.152.
 */
package me.munchii.industrialreborn.blockentity;

import java.util.List;
import java.util.Objects;
import me.munchii.industrialreborn.blockentity.IRangedBlockEntity;
import me.munchii.industrialreborn.config.IndustrialRebornConfig;
import me.munchii.industrialreborn.init.IRBlockEntities;
import me.munchii.industrialreborn.init.IRContent;
import me.munchii.industrialreborn.init.IRFluids;
import me.munchii.industrialreborn.utils.IndustrialTags;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.tag.convention.v1.TagUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_52;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.fluid.FluidValue;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.Syncable;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.blockentity.machine.GenericMachineBlockEntity;

public class MobSlaughterBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider,
IRangedBlockEntity {
    public int slaughterTime = 0;
    public final int totalSlaughterTime = IndustrialRebornConfig.mobSlaughterTicksPerSlaughter;
    public final int slaughterRadius = IndustrialRebornConfig.mobSlaughterRadius;
    public int extraRadius = 0;
    public final Tank experienceTank;
    private class_2338 centerPos;
    private class_238 slaughterArea;

    public MobSlaughterBlockEntity(class_2338 pos, class_2680 state) {
        super(IRBlockEntities.MOB_SLAUGHTER, pos, state, "MobSlaughter", IndustrialRebornConfig.mobSlaughterMaxInput, IndustrialRebornConfig.mobSlaughterMaxEnergy, IRContent.Machine.MOB_SLAUGHTER.block, 6);
        this.inventory = new RebornInventory(7, "MobSlaughterBlockEntity", 64, (MachineBaseBlockEntity)this);
        this.experienceTank = new Tank("MobSlaughterBlockEntity", FluidValue.BUCKET.multiply(16L), (MachineBaseBlockEntity)this);
        this.experienceTank.setFluid((class_3611)IRFluids.LIQUID_EXPERIENCE.getFluid());
    }

    @NotNull
    public Tank getTank() {
        return this.experienceTank;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (!(world instanceof class_3218) || !this.isActive(RedstoneConfiguration.POWER_IO)) {
            return;
        }
        if (this.centerPos == null) {
            this.centerPos = pos.method_10079(this.getFacing().method_10153(), this.getRadius() + 1);
        }
        if (this.slaughterArea == null) {
            this.slaughterArea = new class_238((double)(this.centerPos.method_10263() - this.getRadius()), (double)this.centerPos.method_10264(), (double)(this.centerPos.method_10260() - this.getRadius()), (double)(this.centerPos.method_10263() + this.getRadius()), (double)(this.centerPos.method_10264() + 3), (double)(this.centerPos.method_10260() + this.getRadius()));
        }
        this.updateState();
        if (this.getStored() > (long)IndustrialRebornConfig.mobSlaughterEnergyPerSlaughter && !this.experienceTank.isFull()) {
            if (this.slaughterTime >= this.totalSlaughterTime) {
                this.killEntity(world);
                this.useEnergy(IndustrialRebornConfig.mobSlaughterEnergyPerSlaughter);
                this.slaughterTime = 0;
            } else {
                ++this.slaughterTime;
            }
        }
    }

    private void killEntity(class_1937 world) {
        class_3218 serverWorld = (class_3218)world;
        List nearbyEntities = serverWorld.method_8390(class_1308.class, this.slaughterArea, entity -> entity.method_5805() && !entity.method_5655() && !entity.method_6109() && (!(entity instanceof class_1528) || ((class_1528)entity).method_6884() <= 0));
        if (!nearbyEntities.isEmpty()) {
            class_1308 entity2 = (class_1308)nearbyEntities.get(0);
            if (TagUtil.isIn(IndustrialTags.EntityTypes.MOB_SLAUGHTER_INSTANT_KILL_BLACKLIST, (Object)entity2.method_5864())) {
                FakePlayer player = FakePlayer.get((class_3218)serverWorld);
                this.damage(entity2, player);
            } else {
                this.instantKill(world, entity2);
            }
        }
    }

    private void damage(class_1308 entity, FakePlayer player) {
        entity.method_5643(entity.method_48923().method_48802((class_1657)player), IndustrialRebornConfig.mobSlaughterAttackDamage);
    }

    private void instantKill(class_1937 world, class_1308 entity) {
        int experience = entity.method_6110();
        class_52 table = Objects.requireNonNull(world.method_8503()).method_3857().getLootTable(entity.method_5989());
        class_8567.class_8568 context = new class_8567.class_8568((class_3218)world);
        this.insertIntoInv((List<class_1799>)table.method_51878(context.method_51875(class_176.method_35554().method_782())));
        this.insertFluid(FluidValue.fromMillibuckets((long)((long)experience * IndustrialRebornConfig.mobSlaughterExperienceMultiplier)));
        entity.method_6033(0.0f);
        entity.method_5650(class_1297.class_5529.field_26998);
    }

    public int getRadius() {
        return this.slaughterRadius + this.extraRadius;
    }

    @Override
    public void addRange(int range) {
        this.extraRadius += range;
        this.centerPos = null;
        this.slaughterArea = null;
    }

    @Override
    public void addRangeMultiplier(float multiplier) {
        this.extraRadius += Math.round((float)this.getRadius() * multiplier);
        this.centerPos = null;
        this.slaughterArea = null;
    }

    private void updateState() {
        assert (this.field_11863 != null);
        class_2680 blockState = this.field_11863.method_8320(this.field_11867);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof BlockMachineBase) {
            boolean active;
            BlockMachineBase blockMachineBase = (BlockMachineBase)class_22482;
            boolean bl = active = !this.experienceTank.isFull() && this.getStored() > (long)IndustrialRebornConfig.mobSlaughterEnergyPerSlaughter;
            if ((Boolean)blockState.method_11654((class_2769)BlockMachineBase.ACTIVE) != active) {
                blockMachineBase.setActive(Boolean.valueOf(active), this.field_11863, this.field_11867);
            }
        }
    }

    private void insertFluid(FluidValue amount) {
        if (this.experienceTank.getFluidAmount().add(amount).equalOrMoreThan(FluidValue.BUCKET.multiply(16L))) {
            this.setExperienceAmount(FluidValue.BUCKET.multiply(16L));
            return;
        }
        this.setExperienceAmount(this.experienceTank.getFluidAmount().add(amount));
    }

    private boolean insertIntoInv(List<class_1799> stacks) {
        boolean result = false;
        block0: for (class_1799 stack : stacks) {
            for (int i = 0; i < 6; ++i) {
                if (this.insertIntoInv(i, stack)) {
                    result = true;
                }
                if (stack.method_7960()) continue block0;
            }
        }
        return result;
    }

    private boolean insertIntoInv(int slot, class_1799 stack) {
        int freeStackSpace;
        class_1799 targetStack = this.inventory.method_5438(slot);
        if (targetStack.method_7960()) {
            this.inventory.method_5447(slot, stack.method_7972());
            stack.method_7934(stack.method_7947());
            return true;
        }
        if (ItemUtils.isItemEqual((class_1799)stack, (class_1799)targetStack, (boolean)true, (boolean)false) && (freeStackSpace = targetStack.method_7914() - targetStack.method_7947()) > 0) {
            int transferAmount = Math.min(freeStackSpace, stack.method_7947());
            targetStack.method_7933(transferAmount);
            stack.method_7934(transferAmount);
            return true;
        }
        return false;
    }

    public class_1799 getToolDrop(class_1657 p0) {
        return IRContent.Machine.MOB_SLAUGHTER.getStack();
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("mob_slaughter").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).energySlot(6, 8, 72).outputSlot(0, 70, 22).outputSlot(1, 88, 22).outputSlot(2, 70, 40).outputSlot(3, 88, 40).outputSlot(4, 70, 58).outputSlot(5, 88, 58).syncEnergyValue().sync(this::getExperienceAmount, this::setExperienceAmount).sync(this::getSlaughterTime, this::setSlaughterTime).sync(this::getTotalSlaughterTime, this::setTotalSlaughterTime).sync((Syncable)this.experienceTank).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public void writeMultiblock(MultiblockWriter writer) {
        class_2680 glass = class_2246.field_10272.method_9564();
        int radius = this.getRadius();
        int diameter = radius * 2 + 1;
        for (int i = 1; i <= diameter; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                writer.add(i, 0, j, (world, pos) -> true, glass);
                writer.add(i, 1, j, (world, pos) -> true, glass);
                writer.add(i, 2, j, (world, pos) -> true, glass);
            }
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.getTank().read(tag);
        this.centerPos = null;
        this.slaughterArea = null;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.getTank().write(tag);
    }

    public void resetUpgrades() {
        super.resetUpgrades();
        this.extraRadius = 0;
    }

    public FluidValue getExperienceAmount() {
        return this.experienceTank.getFluidAmount();
    }

    public void setExperienceAmount(FluidValue amount) {
        this.experienceTank.setFluidAmount(amount);
    }

    public int getSlaughterTime() {
        return this.slaughterTime;
    }

    public void setSlaughterTime(int slaughterTime) {
        this.slaughterTime = slaughterTime;
    }

    public int getTotalSlaughterTime() {
        return this.totalSlaughterTime;
    }

    public void setTotalSlaughterTime(int totalSlaughterTime) {
    }
}

