/*
 * Decompiled with CFR 0.152.
 */
package me.munchii.industrialreborn.blockentity;

import java.util.List;
import me.munchii.industrialreborn.blockentity.IRangedBlockEntity;
import me.munchii.industrialreborn.config.IndustrialRebornConfig;
import me.munchii.industrialreborn.init.IRBlockEntities;
import me.munchii.industrialreborn.init.IRContent;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import techreborn.blockentity.machine.GenericMachineBlockEntity;

public class AnimalFeederBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider,
IRangedBlockEntity {
    public int feedingTime;
    public final int totalFeedingTime = IndustrialRebornConfig.animalFeederTicksPerFeeding;
    public final int feedingRadius = IndustrialRebornConfig.animalFeederRadius;
    public int extraRadius;
    private class_2338 centerPos;
    private class_238 feedingArea;

    public AnimalFeederBlockEntity(class_2338 pos, class_2680 state) {
        super(IRBlockEntities.ANIMAL_FEEDER, pos, state, "AnimalFeeder", IndustrialRebornConfig.animalFeederMaxInput, IndustrialRebornConfig.animalFeederMaxEnergy, IRContent.Machine.ANIMAL_FEEDER.block, 6);
        this.inventory = new RebornInventory(7, "AnimalFeederBlockEntity", 64, (MachineBaseBlockEntity)this);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (!(world instanceof class_3218) || !this.isActive(RedstoneConfiguration.POWER_IO)) {
            return;
        }
        if (this.centerPos == null) {
            this.centerPos = pos.method_10079(this.getFacing().method_10153(), this.getRadius() + 1);
        }
        if (this.feedingArea == null) {
            this.feedingArea = new class_238((double)(this.centerPos.method_10263() - this.getRadius()), (double)this.centerPos.method_10264(), (double)(this.centerPos.method_10260() - this.getRadius()), (double)(this.centerPos.method_10263() + this.getRadius()), (double)(this.centerPos.method_10264() + 3), (double)(this.centerPos.method_10260() + this.getRadius()));
        }
        this.updateState();
        if (this.getStored() > (long)IndustrialRebornConfig.animalFeederEnergyPerFeeding) {
            if (this.feedingTime >= this.totalFeedingTime) {
                this.feedEntity();
                this.useEnergy(IndustrialRebornConfig.animalFeederEnergyPerFeeding);
                this.feedingTime = 0;
            } else {
                ++this.feedingTime;
            }
        }
    }

    public void feedEntity() {
        class_3218 serverWorld = (class_3218)this.field_11863;
        assert (serverWorld != null);
        List nearbyEntities = serverWorld.method_8390(class_1429.class, this.feedingArea.method_1014(1.0), class_1309::method_5805);
        nearbyEntities.removeIf(entity -> entity.field_6012 < entity.method_5618() || ((class_1799)this.getFeedingItem((class_1429)entity).method_15442()).method_7960());
        if (!nearbyEntities.isEmpty() && nearbyEntities.size() <= IndustrialRebornConfig.animalFeederMaxAnimalsInArea) {
            for (class_1429 firstParent : nearbyEntities) {
                for (class_1429 secondParent : nearbyEntities) {
                    if (firstParent.equals((Object)secondParent) || !firstParent.getClass().equals(secondParent.getClass())) continue;
                    class_3545<class_1799, Integer> stack = this.getFeedingItem(firstParent);
                    class_1799 foodStack = (class_1799)stack.method_15442();
                    class_1799 original = foodStack.method_7972();
                    foodStack.method_7934(1);
                    foodStack = (class_1799)this.getFeedingItem(secondParent).method_15442();
                    if (foodStack.method_7960()) {
                        original.method_7939(1);
                        if ((Integer)stack.method_15441() == -1) continue;
                        this.inventory.method_5447(((Integer)stack.method_15441()).intValue(), original);
                        continue;
                    }
                    foodStack.method_7934(1);
                    firstParent.method_6480(null);
                    secondParent.method_6480(null);
                    return;
                }
            }
        }
    }

    private class_3545<class_1799, Integer> getFeedingItem(class_1429 animal) {
        for (int i = 0; i < 6; ++i) {
            if (!animal.method_6481(this.inventory.method_5438(i))) continue;
            return new class_3545((Object)this.inventory.method_5438(i), (Object)i);
        }
        return new class_3545((Object)class_1799.field_8037, (Object)-1);
    }

    private void updateState() {
        assert (this.field_11863 != null);
        class_2680 blockState = this.field_11863.method_8320(this.field_11867);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof BlockMachineBase) {
            boolean active;
            BlockMachineBase blockMachineBase = (BlockMachineBase)class_22482;
            boolean bl = active = this.getStored() > (long)IndustrialRebornConfig.animalFeederEnergyPerFeeding;
            if ((Boolean)blockState.method_11654((class_2769)BlockMachineBase.ACTIVE) != active) {
                blockMachineBase.setActive(Boolean.valueOf(active), this.field_11863, this.field_11867);
            }
        }
    }

    public int getRadius() {
        return this.feedingRadius + this.extraRadius;
    }

    @Override
    public void addRange(int range) {
        this.extraRadius += range;
        this.centerPos = null;
        this.feedingArea = null;
    }

    @Override
    public void addRangeMultiplier(float multiplier) {
        this.extraRadius += Math.round((float)this.getRadius() * multiplier);
        this.centerPos = null;
        this.feedingArea = null;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("animal_feeder").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).energySlot(6, 8, 72).slot(0, 70, 22).slot(1, 88, 22).slot(2, 70, 40).slot(3, 88, 40).slot(4, 70, 58).slot(5, 88, 58).sync(this::getFeedingTime, this::setFeedingTime).sync(this::getTotalFeedingTime, this::setTotalFeedingTime).syncEnergyValue().addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public void writeMultiblock(MultiblockWriter writer) {
        class_2680 glass = class_2246.field_10272.method_9564();
        int radius = this.getRadius();
        int diameter = radius * 2 + 1;
        for (int i = 1; i <= diameter; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                writer.add(i, 0, j, (world, pos) -> true, glass);
                writer.add(i, 1, j, (world, pos) -> true, glass);
                writer.add(i, 2, j, (world, pos) -> true, glass);
            }
        }
    }

    public class_1799 getToolDrop(class_1657 p0) {
        return IRContent.Machine.ANIMAL_FEEDER.getStack();
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.centerPos = null;
        this.feedingArea = null;
    }

    public void resetUpgrades() {
        super.resetUpgrades();
        this.extraRadius = 0;
    }

    public int getFeedingTime() {
        return this.feedingTime;
    }

    public void setFeedingTime(int feedingTime) {
        this.feedingTime = feedingTime;
    }

    public int getTotalFeedingTime() {
        return this.totalFeedingTime;
    }

    public void setTotalFeedingTime(int totalFeedingTime) {
    }
}

