/*
 * Decompiled with CFR 0.152.
 */
package me.munchii.industrialreborn.blockentity;

import java.util.List;
import me.munchii.industrialreborn.blockentity.IRangedBlockEntity;
import me.munchii.industrialreborn.config.IndustrialRebornConfig;
import me.munchii.industrialreborn.init.IRBlockEntities;
import me.munchii.industrialreborn.init.IRContent;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import techreborn.blockentity.machine.GenericMachineBlockEntity;

public class AnimalBabySeparatorBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider,
IRangedBlockEntity {
    public int separationTime;
    public final int totalSeparationTime = IndustrialRebornConfig.animalBabySeparatorTicksPerSeparation;
    public final int separationRadius = IndustrialRebornConfig.animalBabySeparatorRadius;
    public int extraRadius;
    private boolean movingAdults = false;
    private class_2338 fromCenterPos;
    private class_238 fromArea;
    private class_2338 toCenterPos;
    private class_238 toArea;

    public AnimalBabySeparatorBlockEntity(class_2338 pos, class_2680 state) {
        super(IRBlockEntities.ANIMAL_BABY_SEPARATOR, pos, state, "AnimalBabySeparator", IndustrialRebornConfig.animalBabySeparatorMaxInput, IndustrialRebornConfig.animalBabySeparatorMaxEnergy, IRContent.Machine.ANIMAL_BABY_SEPARATOR.block, 0);
        this.inventory = new RebornInventory(1, "AnimalBabySeparatorBlockEntity", 64, (MachineBaseBlockEntity)this);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (!(world instanceof class_3218) || !this.isActive(RedstoneConfiguration.POWER_IO)) {
            return;
        }
        if (this.fromCenterPos == null) {
            this.fromCenterPos = pos.method_10079(this.getFacing().method_10153(), this.getRadius() + 1);
        }
        if (this.toCenterPos == null) {
            this.toCenterPos = pos.method_10079(this.getFacing(), this.getRadius() + 1);
        }
        if (this.fromArea == null) {
            this.fromArea = new class_238((double)(this.fromCenterPos.method_10263() - this.getRadius()), (double)this.fromCenterPos.method_10264(), (double)(this.fromCenterPos.method_10260() - this.getRadius()), (double)(this.fromCenterPos.method_10263() + this.getRadius()), (double)(this.fromCenterPos.method_10264() + 3), (double)(this.fromCenterPos.method_10260() + this.getRadius()));
        }
        if (this.toArea == null) {
            this.toArea = new class_238((double)(this.toCenterPos.method_10263() - this.getRadius()), (double)this.toCenterPos.method_10264(), (double)(this.toCenterPos.method_10260() - this.getRadius()), (double)(this.toCenterPos.method_10263() + this.getRadius()), (double)(this.toCenterPos.method_10264() + 3), (double)(this.toCenterPos.method_10260() + this.getRadius()));
        }
        this.updateState();
        if (this.getStored() > (long)IndustrialRebornConfig.animalBabySeparatorEnergyPerSeparation) {
            if (this.separationTime >= this.totalSeparationTime) {
                this.separateBaby();
                this.useEnergy(IndustrialRebornConfig.animalBabySeparatorEnergyPerSeparation);
                this.separationTime = 0;
            } else {
                ++this.separationTime;
            }
        }
    }

    public void separateBaby() {
        class_3218 serverWorld = (class_3218)this.field_11863;
        assert (serverWorld != null);
        List nearbyEntities = serverWorld.method_8390(class_1429.class, this.fromArea.method_1014(1.0), entity -> entity.method_5805() && entity.method_6109() == !this.movingAdults);
        if (!nearbyEntities.isEmpty() && nearbyEntities.size() <= IndustrialRebornConfig.animalBabySeparatorMaxAnimalsInArea) {
            class_1429 entity2 = (class_1429)nearbyEntities.get(0);
            entity2.method_33574(this.toCenterPos.method_46558());
        }
    }

    private void updateState() {
        assert (this.field_11863 != null);
        class_2680 blockState = this.field_11863.method_8320(this.field_11867);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof BlockMachineBase) {
            boolean active;
            BlockMachineBase blockMachineBase = (BlockMachineBase)class_22482;
            boolean bl = active = this.getStored() > (long)IndustrialRebornConfig.animalBabySeparatorEnergyPerSeparation;
            if ((Boolean)blockState.method_11654((class_2769)BlockMachineBase.ACTIVE) != active) {
                blockMachineBase.setActive(Boolean.valueOf(active), this.field_11863, this.field_11867);
            }
        }
    }

    public int getRadius() {
        return this.separationRadius + this.extraRadius;
    }

    @Override
    public void addRange(int range) {
        this.extraRadius += range;
        this.fromCenterPos = null;
        this.toCenterPos = null;
        this.fromArea = null;
        this.toArea = null;
    }

    @Override
    public void addRangeMultiplier(float multiplier) {
        this.extraRadius += Math.round((float)this.getRadius() * multiplier);
        this.fromCenterPos = null;
        this.toCenterPos = null;
        this.fromArea = null;
        this.toArea = null;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("animal_baby_separator").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).energySlot(0, 8, 72).sync(this::getSeparationTime, this::setSeparationTime).sync(this::getTotalSeparationTime, this::setTotalSeparationTime).syncEnergyValue().addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public void writeMultiblock(MultiblockWriter writer) {
        class_2680 glass = class_2246.field_10272.method_9564();
        class_2680 greenGlass = class_2246.field_10357.method_9564();
        int radius = this.getRadius();
        int diameter = radius * 2 + 1;
        for (int i = 1; i <= diameter; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                writer.add(i, 0, j, (world, pos) -> true, glass);
                writer.add(i, 1, j, (world, pos) -> true, glass);
                writer.add(i, 2, j, (world, pos) -> true, glass);
                writer.add(-i, 0, j, (world, pos) -> true, greenGlass);
                writer.add(-i, 1, j, (world, pos) -> true, greenGlass);
                writer.add(-i, 2, j, (world, pos) -> true, greenGlass);
            }
        }
    }

    public class_1799 getToolDrop(class_1657 p0) {
        return IRContent.Machine.ANIMAL_BABY_SEPARATOR.getStack();
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.fromCenterPos = null;
        this.toCenterPos = null;
        this.fromArea = null;
        this.toArea = null;
    }

    public void resetUpgrades() {
        super.resetUpgrades();
        this.extraRadius = 0;
        this.movingAdults = false;
    }

    public int getSeparationTime() {
        return this.separationTime;
    }

    public void setSeparationTime(int separationTime) {
        this.separationTime = separationTime;
    }

    public int getTotalSeparationTime() {
        return this.totalSeparationTime;
    }

    public void setTotalSeparationTime(int totalSeparationTime) {
    }

    public void setMovingAdults(boolean movingAdults) {
        this.movingAdults = movingAdults;
    }
}

