/*
 * Decompiled with CFR 0.152.
 */
package me.munchii.industrialreborn;

import java.util.Arrays;
import me.munchii.industrialreborn.init.IRBlockEntities;
import me.munchii.industrialreborn.init.IRContent;
import me.munchii.industrialreborn.init.IRFluids;
import me.munchii.industrialreborn.init.IRItemGroup;
import me.munchii.industrialreborn.init.IRRecipes;
import me.munchii.industrialreborn.items.SoulVialItem;
import me.munchii.industrialreborn.utils.Resources;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import techreborn.init.TRBlockSettings;

public class RegistryManager {
    public static void register() {
        RegistryManager.registerBlocks();
        RegistryManager.registerItems();
        RegistryManager.registerFluids();
        RegistryManager.registerRecipes();
        IRBlockEntities.init();
        IRItemGroup.register();
    }

    private static void registerBlocks() {
        Arrays.stream(IRContent.Machine.values()).forEach(value -> RegistryManager.registerBlock(value.name, value.block));
        IRContent.BROKEN_SPAWNER = RegistryManager.registerBlock("broken_spawner", new class_2248((class_4970.class_2251)TRBlockSettings.machine().nonOpaque()));
    }

    private static void registerItems() {
        Arrays.stream(IRContent.Upgrade.values()).forEach(value -> RegistryManager.registerItem(value.name, value.method_8389()));
        IRContent.EMPTY_SOUL_VIAL = RegistryManager.registerItem("empty_soul_vial", new SoulVialItem(false));
        IRContent.FILLED_SOUL_VIAL = RegistryManager.registerItem("filled_soul_vial", new SoulVialItem(true));
    }

    private static void registerFluids() {
        Arrays.stream(IRFluids.values()).forEach(IRFluids::register);
    }

    private static void registerRecipes() {
        IRRecipes.FLUID_TRANSPOSER.hashCode();
    }

    private static <I extends class_1792> I registerItem(String name, I item) {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Resources.id(name), item);
        return item;
    }

    private static <B extends class_2248> B registerBlock(String name, B block) {
        return RegistryManager.registerBlock(name, block, new class_1792.class_1793());
    }

    private static <B extends class_2248> B registerBlock(String name, B block, class_1792.class_1793 itemBlockSettings) {
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)Resources.id(name), block);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Resources.id(name), (Object)new class_1747(block, itemBlockSettings));
        return block;
    }
}

