/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.utils.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChorusFlowerBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ChorusCache {
    private List<BlockPos> chorus;
    private World world;

    public ChorusCache(World world, BlockPos current) {
        this.world = world;
        this.chorus = new ArrayList<BlockPos>();
        Stack<BlockPos> chorus = new Stack<BlockPos>();
        chorus.push(current);
        while (!chorus.isEmpty()) {
            BlockPos checking = (BlockPos)chorus.pop();
            if (!BlockUtils.isChorus(world, checking)) continue;
            Iterable area = BlockPos.func_218278_a((BlockPos)checking.func_177972_a(Direction.DOWN).func_177972_a(Direction.SOUTH).func_177972_a(Direction.WEST), (BlockPos)checking.func_177972_a(Direction.UP).func_177972_a(Direction.NORTH).func_177972_a(Direction.EAST));
            for (BlockPos blockPos : area) {
                if (!BlockUtils.isChorus(world, blockPos) || this.chorus.contains(blockPos) || !(blockPos.func_218140_a((double)current.func_177958_n(), (double)current.func_177956_o(), (double)current.func_177952_p(), true) <= 1000.0)) continue;
                chorus.push(blockPos);
                this.chorus.add(blockPos);
            }
        }
    }

    public boolean isFullyGrown() {
        return this.chorus.stream().map(blockpos -> this.world.func_180495_p(blockpos)).allMatch(blockState -> blockState.func_177230_c().equals(Blocks.field_185765_cR) || blockState.func_177230_c().equals(Blocks.field_185766_cS) && (Integer)blockState.func_177229_b((Property)ChorusFlowerBlock.field_185607_a) == 5);
    }

    public List<ItemStack> chop() {
        NonNullList stacks = NonNullList.func_191196_a();
        int maxY = this.getTopRowY();
        this.chorus.stream().filter(pos -> pos.func_177956_o() == maxY).forEach(pos -> this.chop((NonNullList<ItemStack>)stacks, (BlockPos)pos));
        this.chorus.removeIf(pos -> pos.func_177956_o() == maxY);
        return stacks;
    }

    public void chop(NonNullList<ItemStack> stacks, BlockPos p) {
        if (BlockUtils.isChorus(this.world, p)) {
            if (this.world.func_180495_p(p).func_177230_c().equals(Blocks.field_185766_cS)) {
                stacks.add((Object)new ItemStack((IItemProvider)Blocks.field_185766_cS));
            } else {
                stacks.addAll(BlockUtils.getBlockDrops(this.world, p));
            }
            this.world.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
        }
    }

    public int getTopRowY() {
        int i = 0;
        for (BlockPos blockPos : this.chorus) {
            if (blockPos.func_177956_o() <= i) continue;
            i = blockPos.func_177956_o();
        }
        return i;
    }

    public List<BlockPos> getChorus() {
        return this.chorus;
    }
}

