/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block.filter;

import com.buuz135.industrial.proxy.block.filter.IFilter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class RegulatorFilter<TYPE, CAP> {
    private final int sizeX;
    private final int sizeY;
    private final int locX;
    private final int locY;
    private final int smallMultiplier;
    private final int bigMultiplier;
    private final int maxAmount;
    private final String label;
    private IFilter.GhostSlot[] filter;

    public RegulatorFilter(int locX, int locY, int sizeX, int sizeY, int smallMultiplier, int bigMultiplier, int maxAmount, String label) {
        this.locX = locX;
        this.locY = locY;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.smallMultiplier = smallMultiplier;
        this.bigMultiplier = bigMultiplier;
        this.maxAmount = maxAmount;
        this.label = label;
        this.filter = new IFilter.GhostSlot[sizeX * sizeY];
        int pos = 0;
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                this.filter[pos] = new IFilter.GhostSlot(pos, locX + x * 18, locY + y * 18);
                this.filter[pos].setMaxAmount(this.maxAmount);
                ++pos;
            }
        }
    }

    public abstract int matches(TYPE var1, CAP var2, boolean var3);

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getLocX() {
        return this.locX;
    }

    public int getLocY() {
        return this.locY;
    }

    public IFilter.GhostSlot[] getFilter() {
        return this.filter;
    }

    public void setFilter(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.getFilter().length) {
            this.getFilter()[slot].setStack(stack);
            this.getFilter()[slot].setAmount(stack.func_190916_E());
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        for (int i = 0; i < this.getFilter().length; ++i) {
            if (this.getFilter()[i].getStack().func_190926_b()) continue;
            CompoundNBT slot = new CompoundNBT();
            slot.func_218657_a("Stack", (INBT)this.getFilter()[i].getStack().serializeNBT());
            slot.func_74768_a("Amount", this.getFilter()[i].getAmount());
            compound.func_218657_a(String.valueOf(i), (INBT)slot);
        }
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        for (int i = 0; i < this.getFilter().length; ++i) {
            if (nbt.func_74764_b(String.valueOf(i))) {
                CompoundNBT slot = nbt.func_74775_l(String.valueOf(i));
                this.getFilter()[i].setStack(ItemStack.func_199557_a((CompoundNBT)slot.func_74775_l("Stack")));
                this.getFilter()[i].setAmount(slot.func_74762_e("Amount"));
                continue;
            }
            this.getFilter()[i].setStack(ItemStack.field_190927_a);
        }
    }

    public boolean isEmpty() {
        for (IFilter.GhostSlot slot : this.getFilter()) {
            if (slot.getStack().func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int getSmallMultiplier() {
        return this.smallMultiplier;
    }

    public int getBigMultiplier() {
        return this.bigMultiplier;
    }

    public String getLabel() {
        return this.label;
    }
}

