/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.fluid;

import com.buuz135.industrial.fluid.OreFluidInstance;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.hrznstudio.titanium.util.TagUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class OreTitaniumFluidAttributes
extends FluidAttributes {
    public static final String NBT_TAG = "Tag";

    public OreTitaniumFluidAttributes(FluidAttributes.Builder builder, Fluid fluid) {
        super(builder, fluid);
    }

    public int getColor(FluidStack stack) {
        if (Minecraft.func_71410_x().field_71441_e != null && stack.hasTag() && stack.getTag().func_74764_b(NBT_TAG)) {
            String tag = stack.getTag().func_74779_i(NBT_TAG);
            List items = TagCollectionManager.func_242178_a().func_241836_b().func_241834_b(new ResourceLocation(tag.replace("forge:ores/", "forge:dusts/"))).func_230236_b_();
            if (items.size() > 0) {
                return ItemStackUtils.getColor(new ItemStack((IItemProvider)items.get(0)));
            }
        }
        return super.getColor(stack);
    }

    public String getTranslationKey(FluidStack stack) {
        String extra = "";
        if (stack.hasTag() && stack.getTag().func_74764_b(NBT_TAG)) {
            String tag = stack.getTag().func_74779_i(NBT_TAG);
            List items = TagCollectionManager.func_242178_a().func_241836_b().func_241834_b(new ResourceLocation(tag)).func_230236_b_();
            if (items.size() > 0) {
                extra = " (" + new TranslationTextComponent(((Item)items.get(0)).func_77658_a()).getString() + ")";
            }
        }
        return new TranslationTextComponent(super.getTranslationKey(stack)).getString() + extra;
    }

    public ITextComponent getDisplayName(FluidStack stack) {
        String extra = "";
        if (stack.hasTag() && stack.getTag().func_74764_b(NBT_TAG)) {
            String tag = stack.getTag().func_74779_i(NBT_TAG);
            List items = TagCollectionManager.func_242178_a().func_241836_b().func_241834_b(new ResourceLocation(tag)).func_230236_b_();
            if (items.size() > 0) {
                extra = " (" + new TranslationTextComponent(((Item)items.get(0)).func_77658_a()).getString() + ")";
            }
        }
        return new StringTextComponent(super.getDisplayName(stack).getString() + extra);
    }

    public static FluidStack getFluidWithTag(OreFluidInstance fluidInstance, int amount, ResourceLocation itemITag) {
        FluidStack stack = new FluidStack((Fluid)fluidInstance.getSourceFluid(), amount);
        stack.getOrCreateTag().func_74778_a(NBT_TAG, itemITag.toString());
        return stack;
    }

    public static String getFluidTag(FluidStack stack) {
        return stack.getOrCreateTag().func_74779_i(NBT_TAG);
    }

    public static boolean isValid(ResourceLocation resourceLocation) {
        return TagCollectionManager.func_242178_a().func_241836_b().func_199908_a().contains(new ResourceLocation(resourceLocation.toString().replace("forge:ores/", "forge:dusts/"))) && !TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(resourceLocation.toString().replace("forge:ores/", "forge:dusts/"))).func_230236_b_().isEmpty() && !TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(resourceLocation).func_230236_b_().isEmpty();
    }

    public static ItemStack getOutputDust(FluidStack stack) {
        String tag = OreTitaniumFluidAttributes.getFluidTag(stack);
        return TagUtil.getItemWithPreference((ITag)TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(tag.replace("forge:ores/", "forge:dusts/"))));
    }

    public ItemStack getBucket(FluidStack stack) {
        ItemStack bucket = super.getBucket(stack);
        if (stack.hasTag() && stack.getTag().func_74764_b(NBT_TAG)) {
            String tag = stack.getTag().func_74779_i(NBT_TAG);
            bucket.func_196082_o().func_74778_a(NBT_TAG, tag);
        }
        return bucket;
    }
}

