/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import java.util.function.BiFunction;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class RangeManager {
    private BlockPos current;
    private AxisAlignedBB box;
    private RangeType type;
    private Direction direction;

    public RangeManager(BlockPos current, Direction facing, RangeType rangeType) {
        this.current = current;
        this.type = rangeType;
        this.direction = facing;
        this.box = rangeType.getOffsetCreation().apply(facing, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(current));
    }

    public VoxelShape get(int range) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)this.type.getOffsetRange().apply(this, range));
    }

    public BlockPos getCurrent() {
        return this.current;
    }

    public AxisAlignedBB getBox() {
        return this.box;
    }

    public RangeType getType() {
        return this.type;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static enum RangeType {
        FRONT((direction, axisAlignedBB) -> axisAlignedBB.func_72317_d((double)direction.func_176730_m().func_177958_n(), (double)direction.func_176730_m().func_177956_o(), (double)direction.func_176730_m().func_177952_p()), (rangeManager, integer) -> rangeManager.getBox().func_72317_d((double)(rangeManager.getDirection().func_176730_m().func_177958_n() * integer), (double)(rangeManager.getDirection().func_176730_m().func_177956_o() * integer), (double)(rangeManager.getDirection().func_176730_m().func_177952_p() * integer)).func_72314_b((double)integer.intValue(), 0.0, (double)integer.intValue())),
        BEHIND((direction, axisAlignedBB) -> axisAlignedBB.func_72317_d((double)direction.func_176734_d().func_176730_m().func_177958_n(), (double)direction.func_176734_d().func_176730_m().func_177956_o(), (double)direction.func_176734_d().func_176730_m().func_177952_p()), (rangeManager, integer) -> rangeManager.getBox().func_72317_d((double)(rangeManager.getDirection().func_176734_d().func_176730_m().func_177958_n() * integer), (double)(rangeManager.getDirection().func_176734_d().func_176730_m().func_177956_o() * integer), (double)(rangeManager.getDirection().func_176734_d().func_176730_m().func_177952_p() * integer)).func_72314_b((double)integer.intValue(), 0.0, (double)integer.intValue())),
        TOP((direction, axisAlignedBB) -> axisAlignedBB.func_72317_d(0.0, 1.0, 0.0), (rangeManager, integer) -> rangeManager.getBox().func_72314_b((double)integer.intValue(), 0.0, (double)integer.intValue())),
        TOP_UP((direction, axisAlignedBB) -> axisAlignedBB.func_72317_d(0.0, 2.0, 0.0), (rangeManager, integer) -> rangeManager.getBox().func_72314_b((double)integer.intValue(), 0.0, (double)integer.intValue())),
        BOTTOM((direction, axisAlignedBB) -> axisAlignedBB.func_72317_d(0.0, -1.0, 0.0), (rangeManager, integer) -> rangeManager.getBox().func_72314_b((double)integer.intValue(), 0.0, (double)integer.intValue()));

        private final BiFunction<Direction, AxisAlignedBB, AxisAlignedBB> offsetCreation;
        private final BiFunction<RangeManager, Integer, AxisAlignedBB> offsetRange;

        private RangeType(BiFunction<Direction, AxisAlignedBB, AxisAlignedBB> offsetCreation, BiFunction<RangeManager, Integer, AxisAlignedBB> offsetRange) {
            this.offsetCreation = offsetCreation;
            this.offsetRange = offsetRange;
        }

        public BiFunction<Direction, AxisAlignedBB, AxisAlignedBB> getOffsetCreation() {
            return this.offsetCreation;
        }

        public BiFunction<RangeManager, Integer, AxisAlignedBB> getOffsetRange() {
            return this.offsetRange;
        }
    }
}

