/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.spawner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.incontrol.InControl;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.data.Statistics;
import mcjty.incontrol.spawner.SpawnerConditions;
import mcjty.incontrol.spawner.SpawnerParser;
import mcjty.incontrol.spawner.SpawnerRule;
import mcjty.incontrol.tools.varia.Box;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.TickEvent;

public class SpawnerSystem {
    private static Map<RegistryKey<World>, WorldSpawnerData> worldData = new HashMap<RegistryKey<World>, WorldSpawnerData>();
    private static Random random = new Random();
    public static MobEntity busySpawning = null;

    public static void reloadRules() {
        worldData.clear();
        SpawnerParser.readRules("spawner.json");
    }

    public static void addRule(SpawnerRule rule) {
        for (RegistryKey<World> dimension : rule.getConditions().getDimensions()) {
            worldData.computeIfAbsent(dimension, key -> new WorldSpawnerData()).rules.add(rule);
        }
    }

    public static void checkRules(TickEvent.WorldTickEvent event) {
        World world = event.world;
        WorldSpawnerData spawnerData = worldData.get(world.func_234923_W_());
        if (spawnerData == null) {
            return;
        }
        if (spawnerData.rules.isEmpty()) {
            return;
        }
        spawnerData.counter--;
        if (spawnerData.counter <= 0) {
            spawnerData.counter = 20;
            DataStorage data = DataStorage.getData(world);
            int i = 0;
            for (SpawnerRule rule : spawnerData.rules) {
                SpawnerSystem.executeRule(i, rule, world, data);
                ++i;
            }
        }
    }

    private static void executeRule(int ruleNr, SpawnerRule rule, World world, DataStorage data) {
        int count;
        if (!data.getPhases().containsAll(rule.getPhases())) {
            return;
        }
        SpawnerConditions conditions = rule.getConditions();
        if (conditions.getMaxtotal() != -1) {
            count = InControl.setup.cache.getCountHostile((IWorld)world);
            count += InControl.setup.cache.getCountPassive((IWorld)world);
            if ((count += InControl.setup.cache.getCountNeutral((IWorld)world)) >= conditions.getMaxtotal()) {
                return;
            }
        }
        if (conditions.getMaxhostile() != -1 && (count = InControl.setup.cache.getCountHostile((IWorld)world)) >= conditions.getMaxhostile()) {
            return;
        }
        if (conditions.getMaxpeaceful() != -1 && (count = InControl.setup.cache.getCountPassive((IWorld)world)) >= conditions.getMaxpeaceful()) {
            return;
        }
        if (conditions.getMaxneutral() != -1 && (count = InControl.setup.cache.getCountNeutral((IWorld)world)) >= conditions.getMaxneutral()) {
            return;
        }
        int daycounter = data.getDaycounter();
        if (daycounter < conditions.getMindaycount() && daycounter >= conditions.getMaxdaycount()) {
            return;
        }
        if (rule.getMobsFromBiome() != null) {
            SpawnerSystem.executeRule(ruleNr, rule, (ServerWorld)world, null, rule.getMobsFromBiome(), 1.0f);
        } else {
            List<EntityType<?>> mobs = rule.getMobs();
            List<Float> weights = rule.getWeights();
            float maxWeight = rule.getMaxWeight();
            for (int i = 0; i < mobs.size(); ++i) {
                EntityType<?> mob = mobs.get(i);
                float weight = i < weights.size() ? weights.get(i).floatValue() : 1.0f;
                SpawnerSystem.executeRule(ruleNr, rule, (ServerWorld)world, mob, null, weight / maxWeight);
            }
        }
    }

    private static void executeRule(int ruleNr, SpawnerRule rule, ServerWorld world, @Nullable EntityType<?> mob, @Nullable EntityClassification classification, float weight) {
        int maxspawn;
        int minspawn;
        if (random.nextFloat() > rule.getPersecond()) {
            return;
        }
        if (random.nextFloat() > weight) {
            return;
        }
        SpawnerConditions conditions = rule.getConditions();
        if (mob != null && SpawnerSystem.checkTooMany(world, mob, conditions)) {
            return;
        }
        int desiredAmount = minspawn + ((minspawn = rule.getMinSpawn()) == (maxspawn = rule.getMaxSpawn()) ? 0 : random.nextInt(maxspawn - minspawn));
        int spawned = 0;
        for (int i = 0; i < rule.getAttempts(); ++i) {
            Entity entity;
            BlockPos pos = SpawnerSystem.getRandomPosition((World)world, mob, conditions);
            if (pos == null || !world.func_175667_e(pos)) continue;
            EntityType<?> spawnable = SpawnerSystem.selectMob(world, mob, classification, conditions, pos);
            if (spawnable == null) {
                return;
            }
            boolean nocollisions = world.func_226664_a_(spawnable.func_220328_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
            if (!nocollisions || !((entity = spawnable.func_200721_a((World)world)) instanceof MobEntity) || entity instanceof IMob && world.func_175659_aa() == Difficulty.PEACEFUL) continue;
            MobEntity mobEntity = (MobEntity)entity;
            entity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
            busySpawning = mobEntity;
            int result = ForgeHooks.canEntitySpawn((MobEntity)mobEntity, (IWorld)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), null, (SpawnReason)SpawnReason.NATURAL);
            busySpawning = null;
            if (result == -1 || !SpawnerSystem.canSpawn((World)world, mobEntity, conditions) || !SpawnerSystem.isNotColliding((World)world, mobEntity, conditions)) continue;
            mobEntity.func_213386_a((IServerWorld)world, world.func_175649_E(entity.func_233580_cy_()), SpawnReason.NATURAL, null, null);
            world.func_242417_l(entity);
            Statistics.addSpawnerStat(ruleNr);
            if (++spawned < desiredAmount) continue;
            return;
        }
    }

    private static EntityType<?> selectMob(ServerWorld world, EntityType<?> mob, EntityClassification classification, SpawnerConditions conditions, BlockPos pos) {
        EntityType spawnable = mob;
        if (spawnable == null && classification != null) {
            List spawners = world.func_226691_t_(pos).func_242433_b().func_242559_a(classification);
            if (spawners.isEmpty()) {
                return null;
            }
            MobSpawnInfo.Spawners item = (MobSpawnInfo.Spawners)WeightedRandom.func_76271_a((Random)world.field_73012_v, (List)spawners);
            if (item == null) {
                return null;
            }
            spawnable = item.field_242588_c;
            if (SpawnerSystem.checkTooMany(world, spawnable, conditions)) {
                return null;
            }
        }
        return spawnable;
    }

    private static boolean checkTooMany(ServerWorld world, EntityType<?> mob, SpawnerConditions conditions) {
        int count;
        return conditions.getMaxthis() != -1 && (count = InControl.setup.cache.getCount((IWorld)world, mob)) >= conditions.getMaxthis();
    }

    private static boolean canSpawn(World world, MobEntity mobEntity, SpawnerConditions conditions) {
        if (conditions.isNoRestrictions()) {
            return true;
        }
        return mobEntity.func_213380_a((IWorld)world, SpawnReason.NATURAL);
    }

    private static boolean isNotColliding(World world, MobEntity mobEntity, SpawnerConditions conditions) {
        if (conditions.isInLiquid()) {
            return world.func_72953_d(mobEntity.func_174813_aQ()) && world.func_226668_i_((Entity)mobEntity);
        }
        if (conditions.isInWater()) {
            return SpawnerSystem.containsLiquid(world, mobEntity.func_174813_aQ(), (ITag.INamedTag<Fluid>)FluidTags.field_206959_a);
        }
        if (conditions.isInLava()) {
            return SpawnerSystem.containsLiquid(world, mobEntity.func_174813_aQ(), (ITag.INamedTag<Fluid>)FluidTags.field_206960_b);
        }
        return mobEntity.func_205019_a((IWorldReader)world);
    }

    private static boolean containsLiquid(World world, AxisAlignedBB box, ITag.INamedTag<Fluid> liquid) {
        int x1 = MathHelper.func_76128_c((double)box.field_72340_a);
        int x2 = MathHelper.func_76143_f((double)box.field_72336_d);
        int y1 = MathHelper.func_76128_c((double)box.field_72338_b);
        int y2 = MathHelper.func_76143_f((double)box.field_72337_e);
        int z1 = MathHelper.func_76128_c((double)box.field_72339_c);
        int z2 = MathHelper.func_76143_f((double)box.field_72334_f);
        BlockPos.Mutable mpos = new BlockPos.Mutable();
        for (int x = x1; x < x2; ++x) {
            for (int y = y1; y < y2; ++y) {
                for (int z = z1; z < z2; ++z) {
                    BlockState blockstate = world.func_180495_p((BlockPos)mpos.func_181079_c(x, y, z));
                    if (!blockstate.func_204520_s().func_206884_a(liquid)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private static BlockPos getRandomPosition(World world, EntityType<?> mob, SpawnerConditions conditions) {
        boolean inAir = conditions.isInAir();
        boolean inWater = conditions.isInWater();
        boolean inLava = conditions.isInLava();
        boolean inLiquid = conditions.isInLiquid();
        if (inAir || inWater || inLava || inLiquid) {
            return SpawnerSystem.getRandomPositionInBox(world, mob, conditions);
        }
        return SpawnerSystem.getRandomPositionOnGround(world, mob, conditions);
    }

    @Nullable
    private static BlockPos getRandomPositionInBox(World world, EntityType<?> mob, SpawnerConditions conditions) {
        List players = world.func_217369_A();
        PlayerEntity player = (PlayerEntity)players.get(random.nextInt(players.size()));
        int mindist = conditions.getMindist();
        int maxdist = conditions.getMaxdist();
        Box box = SpawnerSystem.createSpawnBox(conditions, player.func_233580_cy_());
        if (!box.isValid()) {
            return null;
        }
        if (SpawnerSystem.checkLocalCount((ServerWorld)world, mob, conditions, box)) {
            return null;
        }
        BlockPos pos = box.randomPos(random);
        double sqdist = pos.func_218140_a((double)player.func_233580_cy_().func_177958_n(), (double)player.func_233580_cy_().func_177956_o(), (double)player.func_233580_cy_().func_177952_p(), true);
        int counter = 100;
        while (sqdist < (double)(mindist * mindist) || sqdist > (double)(maxdist * maxdist)) {
            pos = box.randomPos(random);
            sqdist = pos.func_218140_a((double)player.func_233580_cy_().func_177958_n(), (double)player.func_233580_cy_().func_177956_o(), (double)player.func_233580_cy_().func_177952_p(), true);
            if (--counter > 0) continue;
            return null;
        }
        return pos;
    }

    @Nullable
    private static BlockPos getRandomPositionOnGround(World world, EntityType<?> mob, SpawnerConditions conditions) {
        List players = world.func_217369_A();
        PlayerEntity player = (PlayerEntity)players.get(random.nextInt(players.size()));
        int minheight = conditions.getMinheight();
        int maxheight = conditions.getMaxheight();
        int mindist = conditions.getMindist();
        int maxdist = conditions.getMaxdist();
        Box box = SpawnerSystem.createSpawnBox(conditions, player.func_233580_cy_());
        if (!box.isValid()) {
            return null;
        }
        if (SpawnerSystem.checkLocalCount((ServerWorld)world, mob, conditions, box)) {
            return null;
        }
        BlockPos pos = box.randomPos(random);
        double sqdist = (pos = SpawnerSystem.getValidSpawnablePosition((IWorldReader)world, pos.func_177958_n(), pos.func_177952_p(), minheight, maxheight)) == null ? Double.MAX_VALUE : pos.func_218140_a((double)player.func_233580_cy_().func_177958_n(), (double)player.func_233580_cy_().func_177956_o(), (double)player.func_233580_cy_().func_177952_p(), true);
        int counter = 100;
        while (sqdist < (double)(mindist * mindist) || sqdist > (double)(maxdist * maxdist)) {
            pos = box.randomPos(random);
            double d = sqdist = (pos = SpawnerSystem.getValidSpawnablePosition((IWorldReader)world, pos.func_177958_n(), pos.func_177952_p(), minheight, maxheight)) == null ? Double.MAX_VALUE : pos.func_218140_a((double)player.func_233580_cy_().func_177958_n(), (double)player.func_233580_cy_().func_177956_o(), (double)player.func_233580_cy_().func_177952_p(), true);
            if (--counter > 0) continue;
            return null;
        }
        return pos;
    }

    private static boolean checkLocalCount(ServerWorld world, EntityType<?> mob, SpawnerConditions conditions, Box box) {
        long count;
        return conditions.getMaxlocal() != -1 && (count = world.getEntities().filter(e -> e.func_200600_R() == mob && box.in(e.func_233580_cy_())).count()) >= (long)conditions.getMaxlocal();
    }

    private static Box createSpawnBox(SpawnerConditions conditions, BlockPos center) {
        int maxdist = conditions.getMaxdist();
        return Box.create().center(center, maxdist + 1, maxdist + 1, maxdist + 1).clampY(conditions.getMinheight() - 1, conditions.getMaxheight() + 1).build();
    }

    private static BlockPos getValidSpawnablePosition(IWorldReader worldIn, int x, int z, int minHeight, int maxHeight) {
        int height = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z) + 1;
        height = Math.min(height, maxHeight);
        height = random.nextInt(height + 1);
        BlockPos blockPos = new BlockPos(x, height - 1, z);
        while (blockPos.func_177956_o() >= minHeight && !SpawnerSystem.isValidSpawnPos(worldIn, blockPos)) {
            blockPos = blockPos.func_177977_b();
        }
        return blockPos.func_177956_o() < minHeight ? null : blockPos;
    }

    private static boolean isValidSpawnPos(IWorldReader world, BlockPos pos) {
        if (!world.func_180495_p(pos).func_196957_g((IBlockReader)world, pos, PathType.LAND)) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).func_200132_m();
    }

    public static class WorldSpawnerData {
        private final List<SpawnerRule> rules = new ArrayList<SpawnerRule>();
        private int counter = 1;
    }
}

