/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.data;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.StaticTemplateManager;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnRecipe;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleRecipe;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRecipe;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class IIRecipeReloadListener
implements IResourceManagerReloadListener {
    private final DataPackRegistries dataPackRegistries;
    RecipeManager clientRecipeManager;

    public IIRecipeReloadListener(DataPackRegistries dataPackRegistries) {
        this.dataPackRegistries = dataPackRegistries;
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
        Iterator it;
        MinecraftServer server;
        if (this.dataPackRegistries != null && (server = ServerLifecycleHooks.getCurrentServer()) != null && (it = server.func_212370_w().iterator()).hasNext()) {
            ApiUtils.addFutureServerTask((World)((World)it.next()), () -> StaticTemplateManager.syncMultiblockTemplates((PacketDistributor.PacketTarget)PacketDistributor.ALL.noArg(), (boolean)true));
        }
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        if (this.clientRecipeManager != null) {
            TagUtils.setTagCollectionGetters(ItemTags::func_199903_a, BlockTags::func_199896_a);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRecipesUpdated(RecipesUpdatedEvent event) {
        this.clientRecipeManager = event.getRecipeManager();
        if (!Minecraft.func_71410_x().func_71356_B()) {
            IIRecipeReloadListener.buildRecipeLists(this.clientRecipeManager);
        }
    }

    public static void buildRecipeLists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.func_199510_b();
        if (recipes.size() == 0) {
            return;
        }
        CrucibleRecipe.recipeList = IIRecipeReloadListener.filterRecipes(recipes, CrucibleRecipe.class, CrucibleRecipe.TYPE);
        ElectrolyzerRecipe.recipeList = IIRecipeReloadListener.filterRecipes(recipes, ElectrolyzerRecipe.class, ElectrolyzerRecipe.TYPE);
        RotaryKilnRecipe.recipeList = IIRecipeReloadListener.filterRecipes(recipes, RotaryKilnRecipe.class, RotaryKilnRecipe.TYPE);
        CarKilnRecipe.recipeList = IIRecipeReloadListener.filterRecipes(recipes, CarKilnRecipe.class, CarKilnRecipe.TYPE).values().stream().sorted(Comparator.comparingInt(e -> e.inputs.length).reversed().thenComparing(Comparator.comparingInt(e -> e.getInputAmount()).reversed())).collect(Collectors.toList());
    }

    static <R extends IRecipe<?>> Map<ResourceLocation, R> filterRecipes(Collection<IRecipe<?>> recipes, Class<R> recipeClass, IRecipeType<R> recipeType) {
        return recipes.stream().filter(iRecipe -> iRecipe.func_222127_g() == recipeType).map(recipeClass::cast).collect(Collectors.toMap(recipe -> recipe.func_199560_c(), recipe -> recipe));
    }
}

