/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.steamturbine;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.IIContent;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class SteamTurbineTileEntity
extends MultiblockPartTileEntity<SteamTurbineTileEntity>
implements IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.ISoundTile {
    public FluidTank tanks;
    public boolean active = false;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(SteamTurbineTileEntity::getShape);
    private final List<CapabilityReference<IEnergyStorage>> outputs = Arrays.asList(CapabilityReference.forTileEntityAt((TileEntity)this, () -> new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(0, 1, 6)).func_177982_a(0, 1, 0), Direction.DOWN), (Capability)CapabilityEnergy.ENERGY), CapabilityReference.forTileEntityAt((TileEntity)this, () -> new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(2, 1, 6)).func_177982_a(0, 1, 0), Direction.DOWN), (Capability)CapabilityEnergy.ENERGY));

    public SteamTurbineTileEntity() {
        super(IIContent.IIMultiblocks.STEAMTURBINE, (TileEntityType)IIContent.IITileTypes.STEAMTURBINE.get(), true);
        this.tanks = new FluidTank(24000, fluidStack -> {
            ITag steamTag = FluidTags.func_226157_a_().func_199910_a(new ResourceLocation("forge", "steam"));
            if (steamTag != null) {
                return fluidStack.getFluid().func_207185_a(steamTag);
            }
            return fluidStack.getFluid() == ForgeRegistries.FLUIDS.getValue(new ResourceLocation("steampowered", "steam"));
        });
    }

    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.tanks.readFromNBT(nbt.func_74775_l("tank"));
        }
        this.active = nbt.func_74767_n("active");
    }

    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.func_218657_a("tank0", (INBT)this.tanks.writeToNBT(new CompoundNBT()));
        }
        nbt.func_74757_a("active", this.active);
    }

    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        SteamTurbineTileEntity master = (SteamTurbineTileEntity)this.master();
        if (master != null && this.posInMultiblock.func_177952_p() == 0 && this.posInMultiblock.func_177956_o() == 1 && this.posInMultiblock.func_177958_n() == 2 && (side == null || side == this.getFacing())) {
            return new FluidTank[]{master.tanks};
        }
        return new FluidTank[0];
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        boolean pactive = this.active;
        if (!this.isDummy()) {
            if (!this.field_145850_b.field_72995_K) {
                if (!this.isRSDisabled() && !this.tanks.isEmpty()) {
                    List presentOutputs = this.outputs.stream().map(CapabilityReference::getNullable).filter(Objects::nonNull).collect(Collectors.toList());
                    if (!presentOutputs.isEmpty()) {
                        int out = (Integer)IIConfig.COMMON.steamTurbineGenerator.get();
                        if (!presentOutputs.isEmpty() && this.tanks.getFluidAmount() >= 64 && EnergyHelper.distributeFlux(presentOutputs, (int)out, (boolean)false) < out) {
                            this.active = true;
                            this.tanks.drain(64, IFluidHandler.FluidAction.EXECUTE);
                        } else {
                            this.active = false;
                        }
                    } else {
                        this.active = false;
                    }
                } else if (this.active) {
                    this.active = false;
                }
                if (pactive != this.active) {
                    this.func_70296_d();
                    this.markContainingBlockForUpdate(null);
                }
            } else if (this.active) {
                ImmersiveEngineering.proxy.handleTileSound(IESounds.dieselGenerator, (TileEntity)this, this.active, 0.15f, 1.0f);
            }
        }
    }

    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack fluidStack) {
        return true;
    }

    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    @Nonnull
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return this.getShape(SHAPES);
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        if (posInMultiblock.func_177952_p() == 0 && posInMultiblock.func_177958_n() == 0) {
            return posInMultiblock.func_177956_o() == 0 ? ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AxisAlignedBB(0.5, 0.5, 0.0, 0.0, 1.0, 1.0)) : ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0));
        }
        if (posInMultiblock.func_177952_p() == 5 && posInMultiblock.func_177956_o() == 1) {
            if (posInMultiblock.func_177958_n() % 2 == 0) {
                return Utils.flipBoxes((boolean)false, (posInMultiblock.func_177958_n() == 2 ? 1 : 0) != 0, (AxisAlignedBB[])new AxisAlignedBB[]{new AxisAlignedBB(1.0, 0.0, 0.0, 0.25, 0.5, 1.0)});
            }
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (posInMultiblock.func_177958_n() % 2 == 0 && posInMultiblock.func_177952_p() != 6) {
            if (posInMultiblock.func_177956_o() == 0) {
                return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)Utils.flipBox((boolean)false, (posInMultiblock.func_177958_n() == 2 ? 1 : 0) != 0, (AxisAlignedBB)new AxisAlignedBB(1.0, 0.5, 0.0, 0.25, 1.0, 1.0)));
            }
            if (posInMultiblock.func_177952_p() == 0) {
                if (posInMultiblock.func_177956_o() == 2) {
                    return ImmutableList.of((Object)new AxisAlignedBB(0.25, 0.0, 0.8, 0.75, 0.7, 1.0));
                }
                return ImmutableList.of((Object)new AxisAlignedBB(0.25, 0.25, 0.125, 0.75, 0.75, 1.0), (Object)new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.125));
            }
            if (posInMultiblock.func_177956_o() == 1) {
                return Utils.flipBoxes((boolean)false, (posInMultiblock.func_177958_n() == 2 ? 1 : 0) != 0, (AxisAlignedBB[])new AxisAlignedBB[]{new AxisAlignedBB(1.0, 0.0, 0.0, 0.25, 1.0, 1.0)});
            }
            return ImmutableList.of((Object)new AxisAlignedBB(0.25, 0.0, 1.0, 0.75, 0.7, 0.0));
        }
        if (posInMultiblock.func_177956_o() == 2) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 1.0, 1.0, 0.5, 0.0));
        }
        if (posInMultiblock.equals((Object)new BlockPos(1, 0, 0))) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 0));
    }

    public boolean shouldPlaySound(String sound) {
        return this.active;
    }

    public float getSoundRadiusSq() {
        return 64.0f;
    }
}

