/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.rotarykiln;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableSet;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnProcess;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class RotaryKilnTileEntity
extends MultiblockPartTileEntity<RotaryKilnTileEntity>
implements IEBlockInterfaces.IBlockBounds,
EnergyHelper.IIEInternalFluxHandler,
IIEInventory,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IProcessTile {
    public int processMax = 0;
    public int process = 0;
    public int cd = 0;
    public int tickEnergy = 0;
    boolean active;
    public int angle;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private List<RotaryKilnProcess> processes = new ArrayList<RotaryKilnProcess>();
    public FluxStorageAdvanced energyStorage = new FluxStorageAdvanced(32000);
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper((EnergyHelper.IIEInternalFluxConnector)this, null);
    public FluidTank[] tankout = new FluidTank[]{new FluidTank(32000)};
    private static BlockPos itemout = new BlockPos(1, 0, 7);
    private static BlockPos fluidout = new BlockPos(1, 3, 4);
    private CapabilityReference<IItemHandler> outputItemCap = CapabilityReference.forTileEntityAt((TileEntity)this, () -> {
        Direction fw = this.getFacing().func_176746_e();
        return new DirectionalBlockPos(this.getBlockPosForPos(itemout), fw);
    }, (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private CapabilityReference<IFluidHandler> outputfCap = CapabilityReference.forTileEntityAt((TileEntity)this, () -> new DirectionalBlockPos(this.getBlockPosForPos(fluidout), Direction.DOWN), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    LazyOptional<IItemHandler> inHandler = this.registerConstantCap(new IEInventoryHandler(1, (IIEInventory)this, 0, true, false));
    LazyOptional<IItemHandler> outHandler = this.registerConstantCap(new IEInventoryHandler(2, (IIEInventory)this, 3, false, true));

    public RotaryKilnTileEntity() {
        super(IIContent.IIMultiblocks.ROTARY_KILN, (TileEntityType)IIContent.IITileTypes.ROTARY_KILN.get(), false);
    }

    protected boolean canDrainTankFrom(int i, Direction side) {
        RotaryKilnTileEntity master = (RotaryKilnTileEntity)this.master();
        return master != null;
    }

    protected boolean canFillTankFrom(int arg0, Direction arg1, FluidStack arg2) {
        return false;
    }

    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        RotaryKilnTileEntity master = (RotaryKilnTileEntity)this.master();
        if (master != null && this.posInMultiblock.func_177952_p() == 4 && this.posInMultiblock.func_177956_o() == 2 && this.posInMultiblock.func_177958_n() == 1) {
            return master.tankout;
        }
        return new FluidTank[0];
    }

    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos bp = this.func_174877_v();
        if (!this.isDummy()) {
            return new AxisAlignedBB((double)(bp.func_177958_n() - (this.getFacing().func_176740_k() == Direction.Axis.Z ? 1 : 3)), (double)(bp.func_177956_o() - 1), (double)(bp.func_177952_p() - (this.getFacing().func_176740_k() == Direction.Axis.X ? 1 : 3)), (double)(bp.func_177958_n() + (this.getFacing().func_176740_k() == Direction.Axis.Z ? 2 : 4)), (double)(bp.func_177956_o() + 3), (double)(bp.func_177952_p() + (this.getFacing().func_176740_k() == Direction.Axis.X ? 2 : 4)));
        }
        return new AxisAlignedBB(bp);
    }

    private ItemStack fillInSlot(int slot, ItemStack tofill) {
        ItemStack out = (ItemStack)this.inventory.get(slot);
        if (out.func_190926_b()) {
            this.inventory.set(slot, (Object)tofill);
            return ItemStack.field_190927_a;
        }
        if (out.func_190916_E() < out.func_77976_d() && ItemHandlerHelper.canItemStacksStack((ItemStack)out, (ItemStack)tofill)) {
            int amount = Math.min(out.func_77976_d() - out.func_190916_E(), tofill.func_190916_E());
            tofill.func_190918_g(amount);
            out.func_190917_f(amount);
        }
        return tofill;
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (!this.isDummy()) {
            if (!this.field_145850_b.field_72995_K) {
                int energyConsume = this.tickEnergy;
                this.tryOutput();
                boolean flag = false;
                if (!this.isRSDisabled() && this.energyStorage.getEnergyStored() >= energyConsume) {
                    this.processMax = 0;
                    this.process = 0;
                    if (!this.processes.isEmpty()) {
                        int lp = 0;
                        int lpm = 0;
                        for (RotaryKilnProcess p : this.processes) {
                            lp = p.tick(lp + lpm / 16 - 2);
                            lpm = p.processMax;
                        }
                        if (!this.processes.isEmpty()) {
                            RotaryKilnProcess p = this.processes.get(0);
                            this.processMax = p.processMax;
                            this.process = p.process;
                            if (p.finished()) {
                                p.result = this.fillInSlot(3, p.result);
                                p.sresult = this.fillInSlot(4, p.sresult);
                                if (!p.fresult.isEmpty()) {
                                    p.fresult.shrink(this.tankout[0].fill(p.fresult, IFluidHandler.FluidAction.EXECUTE));
                                }
                            }
                        }
                        this.energyStorage.extractEnergy(energyConsume, false);
                        if (!this.active) {
                            this.active = true;
                        }
                        this.processes.removeIf(RotaryKilnProcess::removable);
                        this.markContainingBlockForUpdate(null);
                    } else if (this.active) {
                        this.active = false;
                        this.tickEnergy = 0;
                        flag = true;
                    }
                    if (this.cd > 0) {
                        --this.cd;
                    }
                    if (!((ItemStack)this.inventory.get(2)).func_190926_b()) {
                        RotaryKilnRecipe recipe;
                        if (this.processes.size() < 16 && this.cd <= 0 && (recipe = this.getRecipe(2)) != null) {
                            ((ItemStack)this.inventory.get(2)).func_190918_g(recipe.input.getCount());
                            this.processes.add(new RotaryKilnProcess(recipe.output.func_77946_l(), recipe.output_fluid.copy(), recipe.time, recipe.secoutput, recipe.secoutputchance));
                            this.cd = recipe.time / 16;
                            this.tickEnergy = Math.max(this.tickEnergy, recipe.tickEnergy);
                        }
                    } else if (!((ItemStack)this.inventory.get(0)).func_190926_b() || !((ItemStack)this.inventory.get(1)).func_190926_b()) {
                        this.inventory.set(2, (Object)((ItemStack)this.inventory.get(1)));
                        this.inventory.set(1, (Object)((ItemStack)this.inventory.get(0)).func_77979_a(16));
                    }
                    if (flag) {
                        this.markContainingBlockForUpdate(null);
                    }
                } else if (this.active) {
                    this.active = false;
                    this.markContainingBlockForUpdate(null);
                }
            } else if (this.active) {
                this.angle += 10;
                if (this.angle >= 360) {
                    this.angle = 0;
                }
            }
        }
    }

    public void tryOutput() {
        boolean update = false;
        if (this.tankout[0].getFluidAmount() > 0) {
            IFluidHandler output;
            int accepted;
            FluidStack out = Utils.copyFluidStackWithAmount((FluidStack)this.tankout[0].getFluid(), (int)Math.min(this.tankout[0].getFluidAmount(), 80), (boolean)false);
            if (this.outputfCap.isPresent() && (accepted = (output = (IFluidHandler)this.outputfCap.getNullable()).fill(out, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                this.tankout[0].drain(drained, IFluidHandler.FluidAction.EXECUTE);
                out.shrink(accepted);
                update |= true;
            }
        }
        if (this.outputItemCap.isPresent() && this.field_145850_b.func_82737_E() % 8L == 0L) {
            ItemStack stack;
            if (!((ItemStack)this.inventory.get(3)).func_190926_b()) {
                stack = ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.inventory.get(3)), (int)1);
                if ((stack = Utils.insertStackIntoInventory(this.outputItemCap, (ItemStack)stack, (boolean)false)).func_190926_b()) {
                    ((ItemStack)this.inventory.get(3)).func_190918_g(1);
                    if (((ItemStack)this.inventory.get(3)).func_190916_E() <= 0) {
                        this.inventory.set(3, (Object)ItemStack.field_190927_a);
                    }
                    update |= true;
                }
            }
            if (!((ItemStack)this.inventory.get(4)).func_190926_b()) {
                stack = ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.inventory.get(4)), (int)1);
                if ((stack = Utils.insertStackIntoInventory(this.outputItemCap, (ItemStack)stack, (boolean)false)).func_190926_b()) {
                    ((ItemStack)this.inventory.get(4)).func_190918_g(1);
                    if (((ItemStack)this.inventory.get(4)).func_190916_E() <= 0) {
                        this.inventory.set(4, (Object)ItemStack.field_190927_a);
                    }
                    update |= true;
                }
            }
        }
        if (update) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Nonnull
    public VoxelShape getBlockBounds(@Nullable ISelectionContext iSelectionContext) {
        return VoxelShapes.func_197868_b();
    }

    @Nullable
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)this.master();
    }

    public boolean canUseGui(PlayerEntity playerEntity) {
        return this.formed;
    }

    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return this.formed && this.isEnergyPos() ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 0));
    }

    public boolean isEnergyPos() {
        return this.getEnergyPos().contains(this.posInMultiblock);
    }

    public void postEnergyTransferUpdate(int energy, boolean simulate) {
        if (!simulate) {
            this.updateMasterBlock(null, energy != 0);
        }
    }

    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 5));
    }

    @Nonnull
    public FluxStorage getFluxStorage() {
        RotaryKilnTileEntity master = (RotaryKilnTileEntity)this.master();
        return master != null ? master.energyStorage : this.energyStorage;
    }

    @Nullable
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        return this.formed && this.isEnergyPos() ? this.wrapper : null;
    }

    @Nullable
    public NonNullList<ItemStack> getInventory() {
        if (this.master() != null) {
            return ((RotaryKilnTileEntity)this.master()).inventory;
        }
        return this.inventory;
    }

    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage.readFromNBT(nbt);
        this.tankout[0].readFromNBT(nbt.func_74775_l("tankout"));
        this.active = nbt.func_74767_n("active");
        this.process = nbt.func_74762_e("process");
        this.processMax = nbt.func_74762_e("processMax");
        if (!descPacket) {
            this.cd = nbt.func_74762_e("next");
            this.tickEnergy = nbt.func_74762_e("tickEnergy");
            ListNBT r = nbt.func_150295_c("queue", 10);
            this.processes.clear();
            r.stream().map(e -> (CompoundNBT)e).map(RotaryKilnProcess::new).forEach(this.processes::add);
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        }
    }

    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        this.energyStorage.writeToNBT(nbt);
        nbt.func_218657_a("tankout", (INBT)this.tankout[0].writeToNBT(new CompoundNBT()));
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("process", this.process);
        nbt.func_74768_a("processMax", this.processMax);
        if (!descPacket) {
            nbt.func_74768_a("next", this.cd);
            nbt.func_74768_a("tickEnergy", this.tickEnergy);
            ListNBT nl = new ListNBT();
            for (RotaryKilnProcess p : this.processes) {
                nl.add((Object)p.serialize());
            }
            nbt.func_218657_a("queue", (INBT)nl);
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        }
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
        if (facing != null && this.posInMultiblock.func_177958_n() == 1 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.posInMultiblock.func_177952_p() == 0 && this.posInMultiblock.func_177956_o() == 2) {
                return this.inHandler.cast();
            }
            if (this.posInMultiblock.func_177952_p() == 6 && this.posInMultiblock.func_177956_o() == 0) {
                return this.outHandler.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    @Nullable
    public RotaryKilnRecipe getRecipe(int slot) {
        RotaryKilnRecipe recipe = RotaryKilnRecipe.findRecipe((ItemStack)this.inventory.get(slot));
        if (recipe == null) {
            return null;
        }
        return recipe;
    }

    public int[] getCurrentProcessesStep() {
        RotaryKilnTileEntity master = (RotaryKilnTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    public int[] getCurrentProcessesMax() {
        RotaryKilnTileEntity master = (RotaryKilnTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }

    public boolean isStackValid(int i, ItemStack itemStack) {
        return i == 0;
    }

    public int getSlotLimit(int i) {
        return 64;
    }

    public void doGraphicalUpdates() {
    }
}

