/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.carkiln;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.RegistryObject;

public class CarKilnRecipe
extends IESerializableRecipe {
    public static IRecipeType<CarKilnRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<CarKilnRecipe>> SERIALIZER;
    public final IngredientWithSize[] inputs;
    public final ItemStack[] output;
    public final FluidStack input_fluid;
    public final int time;
    public final int tickEnergy;
    public final int start_fluid_cost;
    public static List<CarKilnRecipe> recipeList;

    public CarKilnRecipe(ResourceLocation id, ItemStack[] output, IngredientWithSize[] inputs, FluidStack input_fluid, int time, int tickEnergy, int start_fluid_cost) {
        super(output[0], TYPE, id);
        this.output = output;
        this.inputs = inputs;
        this.input_fluid = input_fluid;
        this.time = time;
        this.tickEnergy = tickEnergy;
        this.start_fluid_cost = start_fluid_cost;
    }

    protected IERecipeSerializer getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack func_77571_b() {
        return this.output[0];
    }

    public int getInputAmount() {
        int total = 0;
        for (IngredientWithSize iws : this.inputs) {
            total += iws.getCount();
        }
        return total;
    }

    public static boolean isValidInput(ItemStack stack) {
        for (CarKilnRecipe recipe : recipeList) {
            for (IngredientWithSize is : recipe.inputs) {
                if (!is.testIgnoringSize(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static CarKilnRecipe findRecipe(List<ItemStack> input, FluidStack f, int startIndex, int endIndex) {
        int size = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            if (input.get(i).func_190926_b()) continue;
            ++size;
        }
        if (size <= 0) {
            return null;
        }
        block1: for (CarKilnRecipe recipe : recipeList) {
            if (recipe.inputs.length > size || !recipe.input_fluid.isEmpty() && (!f.isFluidEqual(recipe.input_fluid) || f.getAmount() < recipe.input_fluid.getAmount() + recipe.start_fluid_cost)) continue;
            block2: for (IngredientWithSize iws : recipe.inputs) {
                for (int i = startIndex; i < endIndex; ++i) {
                    if (iws.test(input.get(i))) continue block2;
                }
                continue block1;
            }
            return recipe;
        }
        return null;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (IngredientWithSize is : this.inputs) {
            nonnulllist.add((Object)is.getBaseIngredient());
        }
        return nonnulllist;
    }

    static {
        recipeList = Collections.emptyList();
    }
}

