/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.compat;

import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnCategory;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnRecipe;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnScreen;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleCategory;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleRecipe;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleScreen;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerCategory;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerScreen;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerCategory;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerScreen;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnCategory;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRecipe;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("immersiveindustry", "jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)IIContent.IIBlocks.burning_chamber), new ResourceLocation[]{CrucibleCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)IIContent.IIBlocks.electrolyzer), new ResourceLocation[]{ElectrolyzerCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)IIContent.IIMultiblocks.industrial_electrolyzer), new ResourceLocation[]{IndustrialElectrolyzerCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)IIContent.IIMultiblocks.rotary_kiln), new ResourceLocation[]{RotaryKilnCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)IIContent.IIMultiblocks.car_kiln), new ResourceLocation[]{CarKilnCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        JEICompat.checkNotNull(world, "minecraft world");
        IndustrialElectrolyzerCategory.electrodes = ForgeRegistries.ITEMS.getValues().stream().filter(e -> e.getTags().contains(IndustrialElectrolyzerCategory.Electrode_Tag)).collect(Collectors.toList());
        registration.addRecipes(new ArrayList<CrucibleRecipe>(CrucibleRecipe.recipeList.values()), CrucibleCategory.UID);
        registration.addRecipes((Collection)ElectrolyzerRecipe.recipeList.values().stream().filter(r -> !r.flag).filter(r -> r.inputs.length < 2).collect(Collectors.toList()), ElectrolyzerCategory.UID);
        registration.addRecipes((Collection)ElectrolyzerRecipe.recipeList.values().stream().filter(r -> r.inputs.length < 3).collect(Collectors.toList()), IndustrialElectrolyzerCategory.UID);
        registration.addRecipes(new ArrayList<RotaryKilnRecipe>(RotaryKilnRecipe.recipeList.values()), RotaryKilnCategory.UID);
        registration.addRecipes(CarKilnRecipe.recipeList, CarKilnCategory.UID);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleCategory(guiHelper), new ElectrolyzerCategory(guiHelper), new IndustrialElectrolyzerCategory(guiHelper), new RotaryKilnCategory(guiHelper), new CarKilnCategory(guiHelper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ElectrolyzerScreen.class, 76, 35, 21, 25, new ResourceLocation[]{ElectrolyzerCategory.UID});
        registry.addRecipeClickArea(IndustrialElectrolyzerScreen.class, 76, 35, 21, 25, new ResourceLocation[]{IndustrialElectrolyzerCategory.UID});
        registry.addRecipeClickArea(CrucibleScreen.class, 76, 14, 19, 25, new ResourceLocation[]{CrucibleCategory.UID});
        registry.addRecipeClickArea(RotaryKilnScreen.class, 92, 41, 35, 18, new ResourceLocation[]{RotaryKilnCategory.UID});
        registry.addRecipeClickArea(CarKilnScreen.class, 82, 25, 40, 18, new ResourceLocation[]{CarKilnCategory.UID});
    }

    public static <T> void checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
    }
}

