/*
 * Decompiled with CFR 0.152.
 */
package malte0811.modelsplitter.model;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import malte0811.modelsplitter.math.EpsilonMath;
import malte0811.modelsplitter.math.Plane;
import malte0811.modelsplitter.math.Vec3d;
import malte0811.modelsplitter.model.Polygon;
import malte0811.modelsplitter.model.Vertex;

public class OBJModel<Texture> {
    private final List<Polygon<Texture>> faces;

    public OBJModel(List<Polygon<Texture>> faces) {
        this.faces = ImmutableList.copyOf(faces);
    }

    public static OBJModel<Void> readFromStream(InputStream source) {
        ArrayList points = new ArrayList();
        ArrayList uvs = new ArrayList();
        ArrayList faces = new ArrayList();
        new BufferedReader(new InputStreamReader(source)).lines().forEach(line -> {
            String type;
            StringTokenizer tokenizer = new StringTokenizer((String)line);
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            switch (type = tokenizer.nextToken()) {
                case "v": {
                    points.add(new Vec3d(OBJModel.readTokens(tokenizer, 3)));
                    break;
                }
                case "vt": {
                    uvs.add(OBJModel.readTokens(tokenizer, 2));
                    break;
                }
                case "f": {
                    ArrayList<Vertex> vertices = new ArrayList<Vertex>();
                    while (tokenizer.hasMoreTokens()) {
                        String vertex = tokenizer.nextToken();
                        int slash = vertex.indexOf(47);
                        int v = Integer.parseInt(vertex.substring(0, slash)) - 1;
                        int vt = Integer.parseInt(vertex.substring(slash + 1)) - 1;
                        vertices.add(new Vertex((Vec3d)points.get(v), new Vec3d(0.0, 1.0, 0.0), (double[])uvs.get(vt)));
                    }
                    faces.add(new Polygon<Object>(vertices, null));
                    break;
                }
                default: {
                    System.out.println("Ignoring line " + line);
                }
            }
        });
        return new OBJModel<Void>(faces);
    }

    public OBJModel() {
        this((List<Polygon<Texture>>)ImmutableList.of());
    }

    public static <Texture> OBJModel<Texture> union(@Nullable OBJModel<Texture> a, @Nullable OBJModel<Texture> b) {
        ArrayList<Polygon<Texture>> result = new ArrayList<Polygon<Texture>>();
        if (a != null) {
            result.addAll(a.getFaces());
        }
        if (b != null) {
            result.addAll(b.getFaces());
        }
        return new OBJModel<Texture>(result);
    }

    private static double[] readTokens(StringTokenizer tokenizer, int tokens) {
        double[] data = new double[tokens];
        for (int i = 0; i < tokens; ++i) {
            data[i] = Double.parseDouble(tokenizer.nextToken());
        }
        return data;
    }

    public Map<EpsilonMath.Sign, OBJModel<Texture>> split(Plane p) {
        EnumMap<EpsilonMath.Sign, List> resultFaces = new EnumMap<EpsilonMath.Sign, List>(EpsilonMath.Sign.class);
        for (Polygon<Texture> f : this.faces) {
            Map<EpsilonMath.Sign, Polygon<Texture>> splitResult = f.splitAlong(p);
            for (Map.Entry<EpsilonMath.Sign, Polygon<Texture>> e2 : splitResult.entrySet()) {
                resultFaces.computeIfAbsent(e2.getKey(), s -> new ArrayList()).add(e2.getValue());
            }
        }
        return resultFaces.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new OBJModel((List)e.getValue())));
    }

    public void write(OutputStream outRaw) {
        PrintStream out = new PrintStream(outRaw);
        Object2IntOpenHashMap points = new Object2IntOpenHashMap();
        Object2IntOpenCustomHashMap uvs = new Object2IntOpenCustomHashMap(DoubleArrays.HASH_STRATEGY);
        for (Polygon<Texture> f : this.faces) {
            StringJoiner line = new StringJoiner(" ", "f ", "");
            for (Vertex v : f.getPoints()) {
                int vIndex = points.computeIntIfAbsent((Object)v.getPosition(), arg_0 -> OBJModel.lambda$write$3(out, (Object2IntMap)points, arg_0)) + 1;
                int uvIndex = uvs.computeIntIfAbsent((Object)v.getUV(), arg_0 -> OBJModel.lambda$write$4(out, (Object2IntMap)uvs, arg_0)) + 1;
                line.add(vIndex + "/" + uvIndex);
            }
            out.println(line.toString());
        }
    }

    public boolean isEmpty() {
        return this.faces.isEmpty();
    }

    public List<Polygon<Texture>> getFaces() {
        return this.faces;
    }

    public OBJModel<Texture> translate(int axis, double amount) {
        ArrayList<Polygon<Texture>> translatedFaces = new ArrayList<Polygon<Texture>>(this.faces.size());
        for (Polygon<Texture> p : this.faces) {
            translatedFaces.add(p.translate(axis, amount));
        }
        return new OBJModel<Texture>(translatedFaces);
    }

    public OBJModel<Texture> translate(Vec3d offset) {
        ArrayList<Polygon<Texture>> translatedFaces = new ArrayList<Polygon<Texture>>(this.faces.size());
        for (Polygon<Texture> p : this.faces) {
            translatedFaces.add(p.translate(offset));
        }
        return new OBJModel<Texture>(translatedFaces);
    }

    public OBJModel<Texture> quadify() {
        ArrayList<Polygon<Texture>> translatedFaces = new ArrayList<Polygon<Texture>>(this.faces.size());
        for (Polygon<Texture> p : this.faces) {
            translatedFaces.addAll(p.quadify());
        }
        return new OBJModel<Texture>(translatedFaces);
    }

    private static /* synthetic */ int lambda$write$4(PrintStream out, Object2IntMap uvs, double[] uv) {
        out.printf("vt %.6f %.6f\n", uv[0], uv[1]);
        return uvs.size();
    }

    private static /* synthetic */ int lambda$write$3(PrintStream out, Object2IntMap points, Vec3d pos) {
        out.printf("v %.4f %.4f %.4f\n", pos.get(0), pos.get(1), pos.get(2));
        return points.size();
    }
}

