/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.inventory;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MultiFluidTank
implements IFluidTank,
IFluidHandler {
    public List<FluidStack> fluids = new ArrayList<FluidStack>();
    private final int capacity;

    public MultiFluidTank(int capacity) {
        this.capacity = capacity;
    }

    public MultiFluidTank readFromNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("fluids", 9)) {
            this.fluids.clear();
            ListNBT tagList = nbt.func_150295_c("fluids", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                FluidStack fs = FluidStack.loadFluidStackFromNBT((CompoundNBT)tagList.func_150305_b(i));
                if (fs.isEmpty()) continue;
                this.fluids.add(fs);
            }
        }
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        ListNBT tagList = new ListNBT();
        for (FluidStack fs : this.fluids) {
            if (fs.isEmpty()) continue;
            tagList.add((Object)fs.writeToNBT(new CompoundNBT()));
        }
        nbt.func_218657_a("fluids", (INBT)tagList);
        return nbt;
    }

    public int getFluidTypes() {
        return this.fluids.size();
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.fluids.size() > 0 ? this.fluids.get(this.fluids.size() - 1) : FluidStack.EMPTY;
    }

    public int getFluidAmount() {
        int sum = 0;
        for (FluidStack fs : this.fluids) {
            sum += fs.getAmount();
        }
        return sum;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    public int getTanks() {
        return this.fluids.size() + 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank < this.fluids.size()) {
            return this.fluids.get(tank);
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        if (tank < this.fluids.size()) {
            return this.fluids.get(tank).getAmount();
        }
        return this.capacity - this.getFluidAmount();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int space = this.capacity - this.getFluidAmount();
        int toFill = Math.min(resource.getAmount(), space);
        if (action.simulate()) {
            return toFill;
        }
        for (FluidStack fs : this.fluids) {
            if (!fs.isFluidEqual(resource)) continue;
            fs.grow(toFill);
            return toFill;
        }
        this.fluids.add(Utils.copyFluidStackWithAmount(resource, toFill, true));
        return toFill;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Iterator<FluidStack> it = this.fluids.iterator();
        while (it.hasNext()) {
            FluidStack fs = it.next();
            if (!fs.isFluidEqual(resource)) continue;
            int amount = Math.min(resource.getAmount(), fs.getAmount());
            if (action.execute()) {
                fs.shrink(amount);
                if (fs.getAmount() <= 0) {
                    it.remove();
                }
            }
            return Utils.copyFluidStackWithAmount(resource, amount, true);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(FluidTagInput fluidTag, IFluidHandler.FluidAction action) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Iterator<FluidStack> it = this.fluids.iterator();
        while (it.hasNext()) {
            FluidStack fs = it.next();
            if (!fluidTag.testIgnoringAmount(fs)) continue;
            int amount = Math.min(fluidTag.getAmount(), fs.getAmount());
            FluidStack ret = Utils.copyFluidStackWithAmount(fs, amount, true);
            if (action.execute()) {
                fs.shrink(amount);
                if (fs.getAmount() <= 0) {
                    it.remove();
                }
            }
            return ret;
        }
        return FluidStack.EMPTY;
    }

    public static FluidStack drain(int remove, FluidStack removeFrom, Iterator<FluidStack> removeIt, IFluidHandler.FluidAction action) {
        int amount = Math.min(remove, removeFrom.getAmount());
        if (action.execute()) {
            removeFrom.shrink(amount);
            if (removeFrom.isEmpty()) {
                removeIt.remove();
            }
        }
        return Utils.copyFluidStackWithAmount(removeFrom, amount, true);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this.drain(new FluidStack(this.getFluid(), maxDrain), doDrain);
    }
}

