/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class SawbladeEntity
extends IEProjectileEntity {
    public static final EntityType<SawbladeEntity> TYPE = EntityType.Builder.func_220322_a(SawbladeEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.75f, 0.2f).func_206830_a("immersiveengineering:sawblade");
    private ItemStack ammo = ItemStack.field_190927_a;
    private static final DataParameter<ItemStack> dataMarker_ammo;

    public SawbladeEntity(EntityType<SawbladeEntity> type, World world) {
        super(type, world);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
    }

    public SawbladeEntity(World world, LivingEntity living, double ax, double ay, double az, ItemStack ammo) {
        super(TYPE, world, living, ax, ay, az);
        this.ammo = ammo;
        this.setAmmoSynced();
        this.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
        this.func_213872_b((byte)3);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataMarker_ammo, (Object)ItemStack.field_190927_a);
    }

    @Override
    @Nonnull
    protected ItemStack func_184550_j() {
        return this.ammo;
    }

    public void setAmmoSynced() {
        if (!this.getAmmo().func_190926_b()) {
            this.field_70180_af.func_187227_b(dataMarker_ammo, (Object)this.getAmmo());
        }
    }

    public ItemStack getAmmoSynced() {
        return (ItemStack)this.field_70180_af.func_187225_a(dataMarker_ammo);
    }

    public ItemStack getAmmo() {
        return this.ammo;
    }

    @Override
    public double getGravity() {
        return 0.005;
    }

    @Override
    public int getMaxTicksInGround() {
        return 1200;
    }

    public void func_70030_z() {
        if (this.getAmmo().func_190926_b() && this.field_70170_p.field_72995_K) {
            this.ammo = this.getAmmoSynced();
        }
        super.func_70030_z();
    }

    @Override
    public void func_70227_a(RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K && !this.getAmmo().func_190926_b()) {
            Entity shooter;
            if (mop instanceof EntityRayTraceResult) {
                Entity hit = ((EntityRayTraceResult)mop).func_216348_a();
                shooter = this.func_234616_v_();
                hit.func_70097_a(IEDamageSources.causeSawbladeDamage(this, shooter), 12.0f);
            }
            int dmg = Math.round((float)this.getAmmo().func_77958_k() * 0.05f);
            shooter = this.func_234616_v_();
            if (this.getAmmo().func_96631_a(dmg, this.field_70170_p.field_73012_v, shooter instanceof ServerPlayerEntity ? (ServerPlayerEntity)shooter : null)) {
                this.func_70106_y();
            }
            if (mop instanceof BlockRayTraceResult) {
                this.func_230299_a_((BlockRayTraceResult)mop);
            }
        }
    }

    @Override
    protected void handlePiecing(Entity target) {
        PlayerEntity shooter;
        super.handlePiecing(target);
        if (this.piercedEntities.size() >= 3 && this.getShooterUUID() != null && (shooter = this.field_70170_p.func_217371_b(this.getShooterUUID())) != null) {
            Utils.unlockIEAdvancement(shooter, "main/secret_ravenholm");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (!this.ammo.func_190926_b()) {
            nbt.func_218657_a("ammo", (INBT)this.ammo.func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.ammo = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("ammo"));
    }

    static {
        TYPE.setRegistryName("immersiveengineering", "sawblade");
        dataMarker_ammo = EntityDataManager.func_187226_a(SawbladeEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    }
}

