/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.blocks.IETileProviderBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;

public class ConveyorBlock
extends IETileProviderBlock<ConveyorBeltTileEntity>
implements ConveyorHandler.IConveyorBlock {
    private final ResourceLocation typeName;
    public static final EnumProperty<Direction> FACING = IEProperties.FACING_HORIZONTAL;

    public ConveyorBlock(ResourceLocation type) {
        super(ConveyorHandler.getRegistryNameFor(type).func_110623_a(), Lazy.of(() -> ConveyorHandler.getTEType(type)), AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 15.0f).func_226896_b_(), BlockItemIE::new);
        this.typeName = type;
        this.lightOpacity = 0;
        ConveyorHandler.conveyorBlocks.put(type, this);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, BlockStateProperties.field_208198_y});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        String flavourKey = this.func_149739_a() + ".flavour";
        if (I18n.func_188566_a((String)flavourKey)) {
            tooltip.add((ITextComponent)new TranslationTextComponent(flavourKey));
        }
    }

    @Override
    public void onIEBlockPlacedBy(BlockItemUseContext context, BlockState state) {
        super.onIEBlockPlacedBy(context, state);
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ConveyorBeltTileEntity) {
            ConveyorBeltTileEntity conveyor = (ConveyorBeltTileEntity)tile;
            Direction f = conveyor.getFacing();
            tile = world.func_175625_s(pos.func_177972_a(f));
            TileEntity tileUp = world.func_175625_s(pos.func_177972_a(f).func_177982_a(0, 1, 0));
            ConveyorHandler.IConveyorBelt subType = conveyor.getConveyorSubtype();
            if (subType != null && (!(tile instanceof ConveyorHandler.IConveyorTile) || ((ConveyorHandler.IConveyorTile)tile).getFacing() == f.func_176734_d()) && tileUp instanceof ConveyorHandler.IConveyorTile && ((ConveyorHandler.IConveyorTile)tileUp).getFacing() != f.func_176734_d() && world.func_175623_d(pos.func_177982_a(0, 1, 0))) {
                subType.setConveyorDirection(ConveyorHandler.ConveyorDirection.UP);
            }
        }
    }

    @Override
    public boolean allowHammerHarvest(BlockState blockState) {
        return true;
    }

    @Override
    public ResourceLocation getTypeName() {
        return this.typeName;
    }
}

