/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import com.google.common.base.Preconditions;
import java.util.function.Function;

public class FastEither<L, R> {
    private final L left;
    private final R right;

    private FastEither(L left, R right) {
        Preconditions.checkState((boolean)(left != null ^ right != null));
        this.left = left;
        this.right = right;
    }

    public static <L, R> FastEither<L, R> left(L l) {
        return new FastEither<L, Object>(l, null);
    }

    public static <L, R> FastEither<L, R> right(R r) {
        return new FastEither<Object, R>(null, r);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public L leftNonnull() {
        return (L)Preconditions.checkNotNull(this.left);
    }

    public R rightNonnull() {
        return (R)Preconditions.checkNotNull(this.right);
    }

    public <T> T map(Function<L, T> left, Function<R, T> right) {
        if (this.isLeft()) {
            return left.apply(this.leftNonnull());
        }
        return right.apply(this.rightNonnull());
    }
}

