/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.item.upgrade;

import java.util.HashMap;
import java.util.Map;

public record AircraftStat(String name, boolean positive, float defaultValue) {
    public static final Map<String, AircraftStat> STATS = new HashMap<String, AircraftStat>();
    public static final AircraftStat ENGINE_SPEED = AircraftStat.register("engineSpeed", true);
    public static final AircraftStat VERTICAL_SPEED = AircraftStat.register("verticalSpeed", true);
    public static final AircraftStat YAW_SPEED = AircraftStat.register("yawSpeed", true);
    public static final AircraftStat PITCH_SPEED = AircraftStat.register("pitchSpeed", true);
    public static final AircraftStat PUSH_SPEED = AircraftStat.register("pushSpeed", true);
    public static final AircraftStat ACCELERATION = AircraftStat.register("acceleration", true, 1.0f);
    public static final AircraftStat DURABILITY = AircraftStat.register("durability", true, 1.0f);
    public static final AircraftStat FUEL = AircraftStat.register("fuel", false);
    public static final AircraftStat FRICTION = AircraftStat.register("friction", false, 0.015f);
    public static final AircraftStat GLIDE_FACTOR = AircraftStat.register("glideFactor", true);
    public static final AircraftStat LIFT = AircraftStat.register("lift", true);
    public static final AircraftStat ROLL_FACTOR = AircraftStat.register("rollFactor", true);
    public static final AircraftStat GROUND_PITCH = AircraftStat.register("groundPitch", true);
    public static final AircraftStat STABILIZER = AircraftStat.register("stabilizer", true, 0.0f);
    public static final AircraftStat WIND = AircraftStat.register("wind", false);
    public static final AircraftStat MASS = AircraftStat.register("mass", false, 1.0f);
    public static final AircraftStat GROUND_FRICTION = AircraftStat.register("groundFriction", false, 0.95f);
    public static final AircraftStat ROTATION_DECAY = AircraftStat.register("rotationDecay", false, 0.97f);
    public static final AircraftStat HORIZONTAL_DECAY = AircraftStat.register("horizontalDecay", false, 0.97f);
    public static final AircraftStat VERTICAL_DECAY = AircraftStat.register("verticalDecay", false, 0.97f);

    public static AircraftStat register(String name, boolean positive) {
        return AircraftStat.register(name, positive, 0.0f);
    }

    public static AircraftStat register(String name, boolean positive, float defaultValue) {
        AircraftStat stat = new AircraftStat(name, positive, defaultValue);
        STATS.put(name, stat);
        return stat;
    }
}

