/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.item.upgrade.AircraftStat;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import org.joml.Vector3f;

public class QuadrocopterEntity
extends Rotorcraft {
    public QuadrocopterEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world, true);
        this.adaptPlayerRotation = false;
    }

    @Override
    protected float getInputInterpolationSteps() {
        return 5.0f;
    }

    @Override
    protected class_3414 getEngineSound() {
        return Sounds.PROPELLER_TINY.get();
    }

    @Override
    public class_1792 asItem() {
        return Items.QUADROCOPTER.get();
    }

    @Override
    protected float getGravity() {
        return this.field_5957 ? 0.04f : (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    protected void updateController() {
        this.setEngineTarget(1.0f);
        if (!this.method_24828()) {
            this.method_36457(this.method_36455() + this.getProperties().get(AircraftStat.PITCH_SPEED) * this.pressingInterpolatedZ.getSmooth());
        }
        this.method_36457(this.method_36455() * (1.0f - this.getProperties().getAdditive(AircraftStat.STABILIZER)));
        this.method_18799(this.method_18798().method_1031(0.0, (double)(this.getEnginePower() * this.getProperties().get(AircraftStat.VERTICAL_SPEED) * this.pressingInterpolatedY.getSmooth()), 0.0));
        class_1309 pilot = this.method_5642();
        if (pilot != null) {
            float diff = pilot.method_5791() - this.method_36454();
            if (diff > 180.0f) {
                diff -= 360.0f;
            } else if (diff < -180.0f) {
                diff += 360.0f;
            }
            this.method_36456(this.method_36454() + (diff *= this.getProperties().get(AircraftStat.YAW_SPEED)));
        }
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.getProperties().get(AircraftStat.ENGINE_SPEED));
        Vector3f direction = this.getRightDirection().mul(thrust * this.pressingInterpolatedX.getSmooth());
        this.method_18799(this.method_18798().method_1031((double)direction.x, (double)direction.y, (double)direction.z));
        direction = this.getForwardDirection().mul(thrust * this.pressingInterpolatedZ.getSmooth());
        this.method_18799(this.method_18798().method_1031((double)direction.x, (double)direction.y, (double)direction.z));
    }

    @Override
    protected void convertPower(class_243 direction) {
    }
}

