/*
 * Decompiled with CFR 0.152.
 */
package space.essem.image2map.renderer;

import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1935;
import net.minecraft.class_22;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import space.essem.image2map.Image2Map;

public class MapRenderer {
    private static final double[] shadeCoeffs = new double[]{0.71, 0.86, 1.0, 0.53};

    private static double distance(double[] vectorA, double[] vectorB) {
        return Math.sqrt(Math.pow(vectorA[0] - vectorB[0], 2.0) + Math.pow(vectorA[1] - vectorB[1], 2.0) + Math.pow(vectorA[2] - vectorB[2], 2.0));
    }

    private static double[] applyShade(double[] color, int ind) {
        double coeff = shadeCoeffs[ind];
        return new double[]{color[0] * coeff, color[1] * coeff, color[2] * coeff};
    }

    public static CanvasImage render(BufferedImage image, Image2Map.DitherMode mode, int width, int height) {
        Image resizedImage = image.getScaledInstance(width, height, 1);
        BufferedImage resized = MapRenderer.convertToBufferedImage(resizedImage);
        int[][] pixels = MapRenderer.convertPixelArray(resized);
        CanvasImage state = new CanvasImage(width, height);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (mode.equals((Object)Image2Map.DitherMode.FLOYD)) {
                    state.set(i, j, MapRenderer.floydDither(pixels, i, j, pixels[j][i]));
                    continue;
                }
                state.set(i, j, CanvasUtils.findClosestColorARGB((int)pixels[j][i]));
            }
        }
        return state;
    }

    public static List<class_1799> toVanillaItems(CanvasImage image, class_3218 world, String url) {
        int xSections = class_3532.method_15384((double)((double)image.getWidth() / 128.0));
        int ySections = class_3532.method_15384((double)((double)image.getHeight() / 128.0));
        int xDelta = (xSections * 128 - image.getWidth()) / 2;
        int yDelta = (ySections * 128 - image.getHeight()) / 2;
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (int ys = 0; ys < ySections; ++ys) {
            for (int xs = 0; xs < xSections; ++xs) {
                int id = world.method_17889();
                class_22 state = class_22.method_32363((double)0.0, (double)0.0, (byte)0, (boolean)false, (boolean)false, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("image2map", "generated")));
                for (int xl = 0; xl < 128; ++xl) {
                    for (int yl = 0; yl < 128; ++yl) {
                        int x = xl + xs * 128 - xDelta;
                        int y = yl + ys * 128 - yDelta;
                        if (x < 0 || y < 0 || x >= image.getWidth() || y >= image.getHeight()) continue;
                        state.field_122[xl + yl * 128] = image.getRaw(x, y);
                    }
                }
                world.method_17890(class_1806.method_17440((int)id), state);
                class_1799 stack = new class_1799((class_1935)class_1802.field_8204);
                stack.method_7948().method_10569("map", id);
                class_2499 lore = new class_2499();
                lore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)(xs + " / " + ys)).method_27692(class_124.field_1080))));
                lore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)url))));
                stack.method_7948().method_10569("image2map:x", xs);
                stack.method_7948().method_10569("image2map:y", ys);
                stack.method_7948().method_10569("image2map:width", xSections);
                stack.method_7948().method_10569("image2map:height", ySections);
                stack.method_7911("display").method_10566("Lore", (class_2520)lore);
                items.add(stack);
            }
        }
        return items;
    }

    private static int mapColorToRGBColor(CanvasColor color) {
        int mcColor = color.getRgbColor();
        double[] mcColorVec = new double[]{class_5253.class_5254.method_27765((int)mcColor), class_5253.class_5254.method_27766((int)mcColor), class_5253.class_5254.method_27767((int)mcColor)};
        double coeff = shadeCoeffs[color.getColor().field_16021 & 3];
        return class_5253.class_5254.method_27764((int)0, (int)((int)(mcColorVec[0] * coeff)), (int)((int)(mcColorVec[1] * coeff)), (int)((int)(mcColorVec[2] * coeff)));
    }

    private static CanvasColor floydDither(int[][] pixels, int x, int y, int imageColor) {
        CanvasColor closestColor = CanvasUtils.findClosestColorARGB((int)imageColor);
        int palletedColor = MapRenderer.mapColorToRGBColor(closestColor);
        int errorR = class_5253.class_5254.method_27765((int)imageColor) - class_5253.class_5254.method_27765((int)palletedColor);
        int errorG = class_5253.class_5254.method_27766((int)imageColor) - class_5253.class_5254.method_27766((int)palletedColor);
        int errorB = class_5253.class_5254.method_27767((int)imageColor) - class_5253.class_5254.method_27767((int)palletedColor);
        if (pixels[0].length > x + 1) {
            pixels[y][x + 1] = MapRenderer.applyError(pixels[y][x + 1], errorR, errorG, errorB, 0.4375);
        }
        if (pixels.length > y + 1) {
            if (x > 0) {
                pixels[y + 1][x - 1] = MapRenderer.applyError(pixels[y + 1][x - 1], errorR, errorG, errorB, 0.1875);
            }
            pixels[y + 1][x] = MapRenderer.applyError(pixels[y + 1][x], errorR, errorG, errorB, 0.3125);
            if (pixels[0].length > x + 1) {
                pixels[y + 1][x + 1] = MapRenderer.applyError(pixels[y + 1][x + 1], errorR, errorG, errorB, 0.0625);
            }
        }
        return closestColor;
    }

    private static int applyError(int pixelColor, int errorR, int errorG, int errorB, double quantConst) {
        int pR = MapRenderer.clamp(class_5253.class_5254.method_27765((int)pixelColor) + (int)((double)errorR * quantConst), 0, 255);
        int pG = MapRenderer.clamp(class_5253.class_5254.method_27766((int)pixelColor) + (int)((double)errorG * quantConst), 0, 255);
        int pB = MapRenderer.clamp(class_5253.class_5254.method_27767((int)pixelColor) + (int)((double)errorB * quantConst), 0, 255);
        return class_5253.class_5254.method_27764((int)class_5253.class_5254.method_27762((int)pixelColor), (int)pR, (int)pG, (int)pB);
    }

    private static int clamp(int i, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("max value cannot be less than min value");
        }
        if (i < min) {
            return min;
        }
        if (i > max) {
            return max;
        }
        return i;
    }

    private static int[][] convertPixelArray(BufferedImage image) {
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] result = new int[height][width];
        int pixelLength = 4;
        int pixel = 0;
        int row = 0;
        int col = 0;
        while (pixel + 3 < pixels.length) {
            int argb = 0;
            argb += (pixels[pixel] & 0xFF) << 24;
            argb += pixels[pixel + 1] & 0xFF;
            argb += (pixels[pixel + 2] & 0xFF) << 8;
            result[row][col] = argb += (pixels[pixel + 3] & 0xFF) << 16;
            if (++col == width) {
                col = 0;
                ++row;
            }
            pixel += 4;
        }
        return result;
    }

    private static BufferedImage convertToBufferedImage(Image image) {
        BufferedImage newImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return newImage;
    }
}

