/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;

public class ResourceReloadListener<T>
extends JsonReloadListener {
    private static final Gson DEFAULT_GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Class<T> classType;
    private final Gson parser;
    private T defaultObj = null;
    public HashMap<ResourceLocation, T> objects = new HashMap();

    public ResourceReloadListener(String resourceFolder, Class<T> classType) {
        this(DEFAULT_GSON, resourceFolder, classType);
    }

    public ResourceReloadListener(Gson gsonParser, String resourceFolder, Class<T> classType) {
        super(gsonParser, resourceFolder);
        this.classType = classType;
        this.parser = gsonParser;
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListener);
    }

    public <K extends ResourceReloadListener<T>> K setDefault(T defaultObj) {
        this.defaultObj = defaultObj;
        return (K)((Object)this);
    }

    protected void apply(Map<ResourceLocation, JsonElement> json, IResourceManager iResourceManager, IProfiler iProfiler) {
        json.forEach((k, v) -> {
            try {
                this.objects.put((ResourceLocation)k, (T)this.parser.fromJson(v, this.classType));
            }
            catch (Exception e) {
                iChunUtil.LOGGER.warn("Error parsing resource : {}", k);
            }
        });
    }

    @Nullable
    public T get(ResourceLocation key) {
        return this.objects.containsKey(key) ? this.objects.get(key) : this.defaultObj;
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)this);
    }
}

