/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.module.tabula.formats.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.module.tabula.formats.types.Importer;
import me.ichun.mods.ichunutil.common.module.tabula.legacy.importer.ImportTabulaLegacy;
import me.ichun.mods.ichunutil.common.module.tabula.legacy.project.ProjectInfo;
import me.ichun.mods.ichunutil.common.module.tabula.project.Identifiable;
import me.ichun.mods.ichunutil.common.module.tabula.project.Project;
import org.apache.commons.io.IOUtils;

public class ImporterTabula
implements Importer {
    @Override
    public Project createProject(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ZipEntry modelInfo = null;
            InputStream image = null;
            boolean tampered = false;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                if (entry.getName().endsWith(".png") && entry.getCrc() != Long.decode("0xf970c898").longValue()) {
                    image = zipFile.getInputStream(entry);
                }
                if (entry.getName().endsWith(".json")) {
                    modelInfo = entry;
                }
                if (entry.getName().endsWith(".png") || entry.getName().endsWith(".json")) continue;
                tampered = true;
            }
            Project info = null;
            if (modelInfo != null) {
                info = ImporterTabula.readModelFile(zipFile.getInputStream(modelInfo), image);
            }
            zipFile.close();
            if (info == null || info.projVersion <= 4) {
                info = ImporterTabula.convertProjectInfo(ImportTabulaLegacy.createProjectInfo(file));
            } else if (tampered) {
                info.tampered = true;
                iChunUtil.LOGGER.warn("{} is a tampered Tabula model file.", (Object)file.getName());
            }
            return info;
        }
        catch (Exception e1) {
            iChunUtil.LOGGER.warn("Something went wrong loading Tabula file: {}", (Object)file.getName());
            e1.printStackTrace();
            return null;
        }
    }

    public Project createProject(InputStream in) {
        try {
            ZipInputStream zipStream = new ZipInputStream(in);
            ZipEntry entry = null;
            ByteArrayInputStream modelInfo = null;
            ByteArrayInputStream image = null;
            boolean tampered = false;
            while ((entry = zipStream.getNextEntry()) != null) {
                ByteArrayOutputStream baos;
                if (entry.isDirectory()) continue;
                if (entry.getName().endsWith(".png") && entry.getCrc() != Long.decode("0xf970c898").longValue()) {
                    baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)zipStream, (OutputStream)baos);
                    image = new ByteArrayInputStream(baos.toByteArray());
                }
                if (entry.getName().endsWith(".json")) {
                    baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)zipStream, (OutputStream)baos);
                    modelInfo = new ByteArrayInputStream(baos.toByteArray());
                }
                if (entry.getName().endsWith(".png") || entry.getName().endsWith(".json")) continue;
                tampered = true;
            }
            Project info = null;
            if (modelInfo != null) {
                info = ImporterTabula.readModelFile(modelInfo, image);
            }
            zipStream.close();
            if (info == null || info.projVersion <= 4) {
                iChunUtil.LOGGER.error("We have a null/old tabula file. Please no! We don't know how to handle this!");
                Thread.dumpStack();
            } else if (tampered) {
                info.tampered = true;
                iChunUtil.LOGGER.warn("Loaded a tampered Tabula model file.");
            }
            return info;
        }
        catch (Exception e1) {
            iChunUtil.LOGGER.warn("Something went wrong loading Tabula input stream.");
            e1.printStackTrace();
            return null;
        }
    }

    @Override
    public int getProjectVersion() {
        return 5;
    }

    public static Project readModelFile(InputStream json, InputStream image) throws IOException {
        if (json == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)json, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        json.close();
        String jsonString = writer.toString();
        Project project = (Project)Project.SIMPLE_GSON.fromJson(jsonString, Project.class);
        if (image != null) {
            project.setImageBytes(IOUtils.toByteArray((InputStream)image));
            image.close();
        }
        return project;
    }

    public static Project convertProjectInfo(ProjectInfo old) {
        if (old == null) {
            return null;
        }
        old.repair();
        Project project = new Project();
        project.isOldTabula = true;
        project.name = old.modelName;
        project.author = old.authorName;
        project.notes.addAll(old.metadata);
        project.texWidth = old.textureWidth;
        project.texHeight = old.textureHeight;
        project.scaleX = (float)old.scale[0];
        project.scaleY = (float)old.scale[1];
        project.scaleZ = (float)old.scale[2];
        ImporterTabula.addGroup(old.cubeGroups, project.parts, project);
        ImporterTabula.addParts(old.cubes, project.parts, project);
        project.partCountProjectLife = old.cubeCount;
        project.setImageBytes(old.textureBytes);
        return project;
    }

    public static void addGroup(ArrayList<ProjectInfo.CubeGroup> cubeGroups, ArrayList<Project.Part> parts, Identifiable<?> parent) {
        for (ProjectInfo.CubeGroup group : cubeGroups) {
            ImporterTabula.addGroup(group.cubeGroups, parts, parent);
            ImporterTabula.addParts(group.cubes, parts, parent);
        }
    }

    public static void addParts(ArrayList<ProjectInfo.CubeInfo> cubes, ArrayList<Project.Part> parts, Identifiable<?> parent) {
        cubes.forEach(cube -> {
            Project.Part part = new Project.Part(parent, 0);
            part.name = cube.name;
            Project.Part.Box box = part.boxes.get(0);
            box.dimX = cube.dimensions[0];
            box.dimY = cube.dimensions[1];
            box.dimZ = cube.dimensions[2];
            part.rotPX = (float)cube.position[0];
            part.rotPY = (float)cube.position[1];
            part.rotPZ = (float)cube.position[2];
            box.posX = (float)cube.offset[0];
            box.posY = (float)cube.offset[1];
            box.posZ = (float)cube.offset[2];
            part.rotAX = (float)cube.rotation[0];
            part.rotAY = (float)cube.rotation[1];
            part.rotAZ = (float)cube.rotation[2];
            part.texOffX = cube.txOffset[0];
            part.texOffY = cube.txOffset[1];
            part.mirror = cube.txMirror;
            box.expandY = box.expandZ = (float)cube.mcScale;
            box.expandX = box.expandZ;
            boolean bl = part.showModel = !cube.hidden;
            if (cube.metadata != null) {
                part.notes.addAll(cube.metadata);
            }
            ImporterTabula.addParts(cube.children, part.children, part);
            part.identifier = cube.identifier;
            parts.add(part);
        });
    }
}

