/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.util.TriConsumer;

public class LootTableGen
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator gen;
    private final HashSet<Data> sets = new HashSet();

    public LootTableGen(DataGenerator gen, Data ... set) {
        this.gen = gen;
        this.sets.addAll(Arrays.asList(set));
        if (this.sets.isEmpty()) {
            throw new RuntimeException("Trying to generate loot tables with no data");
        }
    }

    public String func_200397_b() {
        return "LootTables";
    }

    public void func_200398_a(DirectoryCache cache) {
        HashMap map = Maps.newHashMap();
        TriConsumer consumer = (set, key, builder) -> {
            if (map.put(key, builder.func_216039_a(set).func_216038_b()) != null) {
                throw new IllegalStateException("Duplicate loot table " + key);
            }
        };
        for (Data data : this.sets) {
            data.accept((key, builder) -> consumer.accept((Object)data.lootSet(), key, builder));
        }
        map.forEach((key, table) -> {
            Path target = this.gen.func_200391_b().resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)table), (Path)target);
                iChunUtil.LOGGER.info("Saved loot table {}", (Object)target);
            }
            catch (IOException ioexception) {
                iChunUtil.LOGGER.error("Couldn't save loot table {}", (Object)target, (Object)ioexception);
            }
        });
    }

    public static interface Data
    extends Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        public LootParameterSet lootSet();
    }

    public static class Entities
    extends EntityLootTables
    implements Data {
        private HashMap<EntityType<?>, BiConsumer<EntityLootTables, EntityType<?>>> entitiesToGen = new HashMap();

        public Entities add(EntityType<?> type, BiConsumer<EntityLootTables, EntityType<?>> consumer) {
            this.entitiesToGen.put(type, consumer);
            return this;
        }

        @Override
        public LootParameterSet lootSet() {
            return LootParameterSets.field_216263_d;
        }

        @Override
        public void accept(@Nonnull BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.entitiesToGen.forEach((block, blockConsumer) -> blockConsumer.accept(this, block));
            HashSet set = Sets.newHashSet();
            this.entitiesToGen.keySet().forEach(type -> {
                ResourceLocation table;
                if (type.func_220339_d() != EntityClassification.MISC && (table = type.func_220348_g()) != LootTables.field_186419_a && set.add(table)) {
                    LootTable.Builder builder = (LootTable.Builder)this.field_218587_b.remove(table);
                    if (builder == null) {
                        throw new IllegalStateException(String.format("Missing loot table '%s' for '%s'", table, type.getRegistryName()));
                    }
                    consumer.accept(table, builder);
                }
            });
            if (!this.field_218587_b.isEmpty()) {
                throw new IllegalStateException("Created entity loot tables for non-living entities: " + this.field_218587_b.keySet());
            }
        }
    }

    public static class Blocks
    extends BlockLootTables
    implements Data {
        private HashMap<Block, BiConsumer<BlockLootTables, Block>> blocksToGen = new HashMap();

        public Blocks add(Block block, BiConsumer<BlockLootTables, Block> consumer) {
            this.blocksToGen.put(block, consumer);
            return this;
        }

        @Override
        public LootParameterSet lootSet() {
            return LootParameterSets.field_216267_h;
        }

        @Override
        public void accept(@Nonnull BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.blocksToGen.forEach((block, blockConsumer) -> blockConsumer.accept(this, block));
            HashSet set = Sets.newHashSet();
            this.blocksToGen.keySet().forEach(block -> {
                ResourceLocation table = block.func_220068_i();
                if (!LootTables.field_186419_a.equals((Object)table) && set.add(table)) {
                    LootTable.Builder builder = (LootTable.Builder)this.field_218581_i.remove(table);
                    if (builder == null) {
                        throw new IllegalStateException(String.format("Missing loot table '%s' for '%s'", table, block.getRegistryName()));
                    }
                    consumer.accept(table, builder);
                }
            });
            if (!this.field_218581_i.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + this.field_218581_i.keySet());
            }
        }
    }
}

