/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public class ElementScrollBar<T extends ElementScrollBar>
extends Element {
    public final Orientation orientation;
    private float scrollBarSize;
    public Consumer<T> callback;
    public float scrollProg;
    public boolean resizing;
    public Element.MousePos pos;

    public ElementScrollBar(@Nonnull Fragment parent, Orientation orientation, float scrollBarSize) {
        super(parent);
        this.orientation = orientation;
        this.scrollBarSize = scrollBarSize;
    }

    public T setCallback(Consumer<T> callback) {
        this.callback = callback;
        return (T)this;
    }

    public void setScrollBarSize(float f) {
        f = Math.min(f, 1.01f);
        float oldSize = this.scrollBarSize;
        this.scrollBarSize = f;
        float size = (float)(this.orientation == Orientation.VERTICAL ? this.height : this.width) * f;
        if (size < 4.0f) {
            this.scrollBarSize = 4.0f / (float)this.getDistance();
        }
        this.updateSize(oldSize);
    }

    public float getScrollbarSize() {
        return this.scrollBarSize;
    }

    public void setScrollProg(float f) {
        float scroll = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        if (scroll != this.scrollProg) {
            this.scrollProg = scroll;
            if (this.callback != null) {
                this.callback.accept(this);
            }
        }
    }

    private void updateSize(float oldSize) {
        if (this.scrollBarSize > 1.0f) {
            switch (this.orientation) {
                case VERTICAL: {
                    this.width = 0;
                    break;
                }
                case HORIZONTAL: {
                    this.height = 0;
                }
            }
            this.setScrollProg(0.0f);
        } else {
            this.setScrollProg(this.scrollProg / oldSize * this.scrollBarSize);
        }
        if (!this.resizing && (oldSize <= 1.0f && this.scrollBarSize > 1.0f || this.scrollBarSize <= 1.0f && oldSize > 1.0f)) {
            this.resizing = true;
            this.constraint.apply();
            this.parentFragment.resize(this.getWorkspace().getMinecraft(), this.parentFragment.getParentWidth(), this.parentFragment.getParentHeight());
            this.resizing = false;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        int scrollBar = Math.max(8, (int)((float)this.getDistance() * this.scrollBarSize));
        int space = this.getDistance() - scrollBar;
        int preSpace = (int)((float)space * this.scrollProg);
        if (this.renderMinecraftStyle() > 0) {
            ElementScrollBar.bindTexture(this.resourceTabItems());
            if (this.orientation == Orientation.VERTICAL) {
                int dist;
                RenderHelper.startDrawBatch();
                int i = this.height - 6;
                int x = this.getTop() + 3;
                while (i > 0) {
                    dist = Math.min(i, 106);
                    RenderHelper.drawBatch(stack, this.getLeft(), x, 14.0, dist, 0.0, 0.6796875, 0.734375, 0.078125, 0.4921875);
                    i -= dist;
                    x += dist;
                }
                RenderHelper.drawBatch(stack, this.getLeft(), this.getTop(), 14.0, 3.0, 0.0, 0.6796875, 0.734375, 0.06640625, 0.078125);
                RenderHelper.drawBatch(stack, this.getLeft(), this.getBottom() - 3, 14.0, 3.0, 0.0, 0.6796875, 0.734375, 0.4921875, 0.50390625);
                RenderHelper.endDrawBatch();
                ElementScrollBar.bindTexture(this.resourceTabs());
                RenderHelper.startDrawBatch();
                i = scrollBar - 7 - 2;
                x = this.getTop() + preSpace + 4 + 1;
                while (i > 0) {
                    dist = Math.min(i, 8);
                    RenderHelper.drawBatch(stack, this.getLeft() + 1, x, 12.0, dist, 0.0, 0.90625, 0.953125, 0.015625, (double)(4 + dist) / 256.0);
                    i -= dist;
                    x += dist;
                }
                RenderHelper.drawBatch(stack, this.getLeft() + 1, this.getTop() + preSpace + 1, 12.0, 4.0, 0.0, 0.90625, 0.953125, 0.0, 0.015625);
                RenderHelper.drawBatch(stack, this.getLeft() + 1, this.getTop() + preSpace + scrollBar - 3 - 1, 12.0, 3.0, 0.0, 0.90625, 0.953125, 0.046875, 0.05859375);
                RenderHelper.endDrawBatch();
            } else {
                int dist;
                int i = this.width - 6;
                int x = this.getLeft() + 3;
                while (i > 0) {
                    dist = Math.min(i, 106);
                    ElementScrollBar.draw(stack, x, this.getTop(), dist, 14.0, 0.0, 0.6796875, 0.734375, 0.078125, 0.4921875);
                    i -= dist;
                    x += dist;
                }
                ElementScrollBar.draw(stack, this.getLeft(), this.getTop(), 3.0, 14.0, 0.0, 0.6796875, 0.734375, 0.06640625, 0.078125);
                ElementScrollBar.draw(stack, this.getRight() - 3, this.getTop(), 3.0, 14.0, 0.0, 0.6796875, 0.734375, 0.4921875, 0.50390625);
                ElementScrollBar.bindTexture(this.resourceTabs());
                i = scrollBar - 7 - 2;
                x = this.getLeft() + preSpace + 4 + 1;
                while (i > 0) {
                    dist = Math.min(i, 8);
                    ElementScrollBar.draw(stack, x, this.getTop() + 1, dist, 12.0, 0.0, 0.90625, 0.953125, 0.015625, (double)(4 + dist) / 256.0);
                    i -= dist;
                    x += dist;
                }
                ElementScrollBar.draw(stack, this.getLeft() + preSpace + 1, this.getTop() + 1, 4.0, 12.0, 0.0, 0.90625, 0.953125, 0.0, 0.015625);
                ElementScrollBar.draw(stack, this.getLeft() + preSpace + scrollBar - 3 - 1, this.getTop() + 1, 3.0, 12.0, 0.0, 0.90625, 0.953125, 0.046875, 0.05859375);
            }
        } else {
            this.fill(stack, this.getTheme().elementTreeScrollBar, 0);
            if (this.orientation == Orientation.VERTICAL) {
                RenderHelper.drawColour(stack, this.getTheme().elementTreeScrollBarBorder[0], this.getTheme().elementTreeScrollBarBorder[1], this.getTheme().elementTreeScrollBarBorder[2], 255, this.getLeft() + 6, this.getTop() + 4, 2.0, this.height - 8, 0.0);
                RenderHelper.drawColour(stack, this.getTheme().elementTreeScrollBarBorder[0], this.getTheme().elementTreeScrollBarBorder[1], this.getTheme().elementTreeScrollBarBorder[2], 255, this.getLeft(), this.getTop() + preSpace, 14.0, scrollBar, 0.0);
                RenderHelper.drawColour(stack, this.getTheme().elementTreeScrollBar[0], this.getTheme().elementTreeScrollBar[1], this.getTheme().elementTreeScrollBar[2], 255, this.getLeft() + 1, this.getTop() + preSpace + 1, 12.0, scrollBar - 2, 0.0);
            } else {
                RenderHelper.drawColour(stack, this.getTheme().elementTreeScrollBarBorder[0], this.getTheme().elementTreeScrollBarBorder[1], this.getTheme().elementTreeScrollBarBorder[2], 255, this.getLeft() + 4, this.getTop() + 6, this.width - 8, 2.0, 0.0);
                RenderHelper.drawColour(stack, this.getTheme().elementTreeScrollBarBorder[0], this.getTheme().elementTreeScrollBarBorder[1], this.getTheme().elementTreeScrollBarBorder[2], 255, this.getLeft() + preSpace, this.getTop(), scrollBar, 14.0, 0.0);
                RenderHelper.drawColour(stack, this.getTheme().elementTreeScrollBar[0], this.getTheme().elementTreeScrollBar[1], this.getTheme().elementTreeScrollBar[2], 255, this.getLeft() + preSpace + 1, this.getTop() + 1, scrollBar - 2, 12.0, 0.0);
            }
        }
    }

    public int getDistance() {
        return this.orientation == Orientation.VERTICAL ? this.height : this.width;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            this.pos = new Element.MousePos((int)mouseX, (int)mouseY);
            return true;
        }
        return false;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double distX, double distY) {
        if (this.pos != null) {
            int moved = this.orientation == Orientation.VERTICAL ? (int)mouseY - this.pos.y : (int)mouseX - this.pos.x;
            if (moved != 0) {
                this.setScrollProg(this.scrollProg + (float)moved / ((float)this.getDistance() * (1.0f - this.scrollBarSize)));
            }
            this.pos.x = (int)mouseX;
            this.pos.y = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double dist) {
        if (this.func_231047_b_(mouseX, mouseY) && this.scrollBarSize < 1.0f) {
            if (Screen.func_231173_s_()) {
                this.setScrollProg((float)dist * -100.0f);
            } else if (Screen.func_231172_r_()) {
                this.setScrollProg(this.scrollProg + (float)(dist * -0.01));
            } else {
                this.secondHandScroll(dist);
            }
            return true;
        }
        return false;
    }

    public void secondHandScroll(double dist) {
        this.setScrollProg(this.scrollProg + (float)(dist * -0.1));
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.pos = null;
        super.func_231048_c_(mouseX, mouseY, button);
        this.parentFragment.func_231035_a_(null);
        return this.func_241217_q_() != null && this.func_241217_q_().func_231048_c_(mouseX, mouseY, button);
    }

    @Override
    public boolean func_231049_c__(boolean direction) {
        return false;
    }

    @Override
    public int getMinWidth() {
        return this.orientation == Orientation.VERTICAL && this.scrollBarSize < 1.0f ? 14 : 0;
    }

    @Override
    public int getMinHeight() {
        return this.orientation == Orientation.HORIZONTAL && this.scrollBarSize < 1.0f ? 14 : 0;
    }

    @Override
    public int getMaxWidth() {
        return this.orientation == Orientation.VERTICAL && this.scrollBarSize < 1.0f ? 14 : (this.orientation == Orientation.HORIZONTAL ? 10000 : 0);
    }

    @Override
    public int getMaxHeight() {
        return this.orientation == Orientation.HORIZONTAL && this.scrollBarSize < 1.0f ? 14 : (this.orientation == Orientation.VERTICAL ? 10000 : 0);
    }

    public static void draw(MatrixStack stack, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix, (float)posX, (float)(posY + height), (float)zLevel).func_225583_a_((float)u2, (float)v1).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).func_225583_a_((float)u2, (float)v2).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(posX + width), (float)posY, (float)zLevel).func_225583_a_((float)u1, (float)v2).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)posX, (float)posY, (float)zLevel).func_225583_a_((float)u1, (float)v1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

