/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowDock;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.util.Util;

public abstract class Window<M extends IWindows>
extends Fragment {
    public Supplier<Integer> borderSize;
    public Supplier<Integer> titleSize = () -> this.borderSize.get() + 10;
    @Nonnull
    public final M parent;
    @Nonnull
    public List<View<?>> views;
    public View<? extends Window<?>> currentView;
    public EdgeGrab edgeGrab;
    private boolean showTitle = true;
    private boolean canDrag = true;
    private boolean canDragResize = true;
    private boolean canBringToFront = true;
    private boolean canBeDocked = true;
    private boolean canBeUndocked = true;
    private boolean canDockStack = true;
    private boolean isUnique = true;

    public Window(M parent) {
        super(null);
        this.parent = parent;
        this.views = new ArrayList();
        this.borderSize = () -> (parent.isDocked(this) ? 1 : 0) + (this.renderMinecraftStyle() > 0 ? 4 : 3);
    }

    public <T extends Window<?>> T pos(int x, int y) {
        this.posX = x;
        this.posY = y;
        return (T)this;
    }

    public <T extends Window<?>> T size(int width, int height) {
        this.width = width;
        this.height = height;
        return (T)this;
    }

    public <T extends Window<?>> T setBorderSize(Supplier<Integer> borderSize) {
        this.borderSize = borderSize;
        return (T)this;
    }

    public <T extends Window<?>> T disableTitle() {
        this.showTitle = false;
        return (T)this;
    }

    public <T extends Window<?>> T disableDrag() {
        this.canDrag = false;
        return (T)this;
    }

    public <T extends Window<?>> T disableDragResize() {
        this.canDragResize = false;
        return (T)this;
    }

    public <T extends Window<?>> T disableBringToFront() {
        this.canBringToFront = false;
        return (T)this;
    }

    public <T extends Window<?>> T disableDockingEntirely() {
        this.canBeDocked = false;
        this.canBeUndocked = false;
        this.canDockStack = false;
        return (T)this;
    }

    public <T extends Window<?>> T disableDocking() {
        this.canBeDocked = false;
        return (T)this;
    }

    public <T extends Window<?>> T disableUndocking() {
        this.canBeUndocked = false;
        return (T)this;
    }

    public <T extends Window<?>> T disableDockStacking() {
        this.canDockStack = false;
        return (T)this;
    }

    public <T extends Window<?>> T isNotUnique() {
        this.isUnique = false;
        return (T)this;
    }

    public <V extends View<?>> V getCurrentView() {
        return (V)this.currentView;
    }

    @Override
    public void init() {
        this.constraint.apply();
        this.views.forEach(Fragment::init);
    }

    public List<View<?>> func_231039_at__() {
        return this.currentView != null ? ImmutableList.of(this.currentView) : this.views;
    }

    public void setView(View<?> v) {
        this.views.add(v);
        this.setCurrentView(v);
    }

    public void setCurrentView(View<?> v) {
        this.currentView = v;
    }

    public boolean canShowTitle() {
        return this.showTitle;
    }

    public boolean hasTitle() {
        return this.canShowTitle() && !this.currentView.title.isEmpty();
    }

    public boolean canDrag() {
        return this.canDrag;
    }

    public boolean canDragResize() {
        return this.canDragResize;
    }

    public boolean canBringToFront() {
        return this.canBringToFront;
    }

    public boolean canBeDocked() {
        return this.canBeDocked;
    }

    public boolean canBeUndocked() {
        return this.canBeUndocked;
    }

    public boolean canDockStack() {
        return this.canDockStack;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        boolean isDocked;
        EdgeGrab grab;
        if (this.func_231047_b_(mouseX, mouseY) && (this.canDrag() || this.canDragResize()) && (grab = new EdgeGrab((!(isDocked = this.parent.isDocked(this)) && !this.constraint.hasLeft() || isDocked && (!this.constraint.hasLeft() || this.parent.sameDockStack(this, this.constraint.get(Constraint.Property.Type.LEFT).getReference()))) && Window.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.borderSize.get()), (!isDocked && !this.constraint.hasRight() || isDocked && (!this.constraint.hasRight() || this.parent.sameDockStack(this, this.constraint.get(Constraint.Property.Type.RIGHT).getReference()))) && Window.isMouseBetween(mouseX, this.getRight() - this.borderSize.get(), this.getRight()), (!isDocked && !this.constraint.hasTop() || isDocked && (!this.constraint.hasTop() || this.parent.sameDockStack(this, this.constraint.get(Constraint.Property.Type.TOP).getReference()))) && Window.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.borderSize.get()), (!isDocked && !this.constraint.hasBottom() || isDocked && (!this.constraint.hasBottom() || this.parent.sameDockStack(this, this.constraint.get(Constraint.Property.Type.BOTTOM).getReference()))) && Window.isMouseBetween(mouseY, this.getBottom() - this.borderSize.get(), this.getBottom()), (!isDocked || this.canBeUndocked()) && Window.isMouseBetween(mouseY, this.getTop() + this.borderSize.get(), this.getTop() + this.titleSize.get()) && this.hasTitle(), mouseX, mouseY)).isActive()) {
            this.getWorkspace().cursorState = grab.titleGrab ? Workspace.CURSOR_CROSSHAIR : (grab.left || grab.right ? Workspace.CURSOR_HRESIZE : Workspace.CURSOR_VRESIZE);
        }
        this.renderDockHighlight(stack, mouseX, mouseY, partialTick);
        this.setScissor();
        this.renderBackground(stack);
        if (this.hasTitle()) {
            this.drawString(stack, this.currentView.title, this.getLeft() + this.borderSize.get() + 1, this.getTop() + this.borderSize.get());
        }
        this.currentView.func_230430_a_(stack, mouseX, mouseY, partialTick);
        this.endScissor();
    }

    public void renderDockHighlight(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        if (this.getWorkspace().canDockWindows() && this.getWorkspace().func_241217_q_() == this && this.getWorkspace().func_231041_ay__() && (this.canBeDocked() || this.canDockStack()) && this.edgeGrab != null && this.edgeGrab.titleGrab) {
            boolean draw;
            WindowDock<? extends Workspace> dock = this.getWorkspace().getDock();
            double left = 0.0;
            double top = 0.0;
            double right = this.getWorkspace().getWidth();
            double bottom = this.getWorkspace().getHeight();
            for (Map.Entry<WindowDock.ArrayListHolder, Constraint.Property.Type> e : dock.docked.entrySet()) {
                for (Window<?> key : e.getKey().windows) {
                    Constraint.Property.Type value = e.getValue();
                    switch (value) {
                        case LEFT: {
                            if (!((double)key.getRight() > left)) break;
                            left = key.getRight();
                            break;
                        }
                        case TOP: {
                            if (!((double)key.getBottom() > top)) break;
                            top = key.getBottom();
                            break;
                        }
                        case RIGHT: {
                            if (!((double)key.getLeft() < right)) break;
                            right = key.getLeft();
                            break;
                        }
                        case BOTTOM: {
                            if (!((double)key.getTop() < bottom)) break;
                            bottom = key.getTop();
                        }
                    }
                }
            }
            Window window = this;
            int oriX = window.posX;
            int oriY = window.posY;
            window.pos(-10000, -10000);
            IWindows.DockInfo info = dock.getDockInfo(mouseX, mouseY, window.canDockStack());
            window.pos(oriX, oriY);
            boolean bl = draw = info != null && info.window != null;
            if (draw) {
                left = info.window.getLeft();
                right = info.window.getRight();
                top = info.window.getTop();
                bottom = info.window.getBottom();
            } else if (this.canBeDocked() && !this.getWorkspace().isDocked(this)) {
                HashSet<Constraint.Property.Type> disabledDocks = this.getWorkspace().getDock().disabledDocks;
                int dockSnap = iChunUtil.configClient.guiDockBorder;
                if ((double)mouseY >= top && (double)mouseY < bottom) {
                    if ((double)mouseX >= left && (double)mouseX < left + (double)dockSnap && !disabledDocks.contains((Object)Constraint.Property.Type.LEFT)) {
                        right = left + (double)dockSnap;
                        draw = true;
                    } else if ((double)mouseX >= right - (double)dockSnap && (double)mouseX < right && !disabledDocks.contains((Object)Constraint.Property.Type.RIGHT)) {
                        left = right - (double)dockSnap;
                        draw = true;
                    }
                }
                if ((double)mouseX >= left && (double)mouseX < right) {
                    if ((double)mouseY >= top && (double)mouseY < top + (double)dockSnap && !disabledDocks.contains((Object)Constraint.Property.Type.TOP)) {
                        bottom = top + (double)dockSnap;
                        draw = true;
                    } else if ((double)mouseY >= bottom - (double)dockSnap && bottom < right && !disabledDocks.contains((Object)Constraint.Property.Type.BOTTOM)) {
                        top = bottom - (double)dockSnap;
                        draw = true;
                    }
                }
            }
            if (draw) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                if (this.renderMinecraftStyle() > 0) {
                    float scale = 8.0f;
                    float scaleTex = 512.0f;
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.depthFunc((int)514);
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    Fragment.bindTexture(ItemRenderer.field_110798_h);
                    RenderSystem.matrixMode((int)5890);
                    RenderSystem.pushMatrix();
                    RenderSystem.scalef((float)scale, (float)scale, (float)scale);
                    float f = (float)(Util.func_211177_b() % 3000L) / 3000.0f / scale;
                    RenderSystem.translatef((float)f, (float)0.0f, (float)0.0f);
                    RenderSystem.rotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    RenderHelper.draw(stack, left, top, right - left, bottom - top, 0.0, left / (double)scaleTex, right / (double)scaleTex, top / (double)scaleTex, bottom / (double)scaleTex);
                    RenderSystem.popMatrix();
                    RenderSystem.pushMatrix();
                    RenderSystem.scalef((float)scale, (float)scale, (float)scale);
                    float f1 = (float)(Util.func_211177_b() % 4873L) / 4873.0f / scale;
                    RenderSystem.translatef((float)(-f1), (float)0.0f, (float)0.0f);
                    RenderSystem.rotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    RenderHelper.draw(stack, left, top, right - left, bottom - top, 0.0, left / (double)scaleTex, right / (double)scaleTex, top / (double)scaleTex, bottom / (double)scaleTex);
                    RenderSystem.popMatrix();
                    RenderSystem.matrixMode((int)5888);
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    RenderSystem.depthFunc((int)515);
                    RenderSystem.depthMask((boolean)true);
                } else {
                    RenderHelper.drawColour(stack, this.getTheme().tabBorder[0], this.getTheme().tabBorder[1], this.getTheme().tabBorder[2], 150, left, top, right - left, bottom - top, 0.0);
                }
                RenderSystem.disableBlend();
            }
        }
    }

    public void renderBackground(MatrixStack stack) {
        if (this.renderMinecraftStyle() > 0) {
            RenderSystem.enableAlphaTest();
            Window.bindTexture(this.resourceTabs());
            RenderHelper.startDrawBatch();
            RenderHelper.drawBatch(stack, this.getLeft() + 4, this.getTop() + 4, this.width - 8, this.height - 8, 0.0, 0.015625, 0.09375, 0.140625, 0.234375);
            RenderHelper.drawBatch(stack, this.getLeft(), this.getTop() + 4, 4.0, this.height - 8, 0.0, 0.0, 0.015625, 0.140625, 0.234375);
            RenderHelper.drawBatch(stack, this.getLeft() + 4, this.getTop(), this.width - 8, 4.0, 0.0, 0.015625, 0.09375, 0.125, 0.140625);
            RenderHelper.drawBatch(stack, this.getRight() - 4, this.getTop() + 4, 4.0, this.height - 8, 0.0, 0.09375, 0.109375, 0.140625, 0.234375);
            RenderHelper.drawBatch(stack, this.getLeft() + 4, this.getBottom() - 4, this.width - 8, 4.0, 0.0, 0.015625, 0.09375, 0.484375, 0.5);
            RenderHelper.drawBatch(stack, this.getLeft(), this.getTop(), 4.0, 4.0, 0.0, 0.0, 0.015625, 0.125, 0.140625);
            RenderHelper.drawBatch(stack, this.getRight() - 4, this.getTop(), 4.0, 4.0, 0.0, 0.09375, 0.109375, 0.125, 0.140625);
            RenderHelper.drawBatch(stack, this.getLeft(), this.getBottom() - 4, 4.0, 4.0, 0.0, 0.0, 0.015625, 0.484375, 0.5);
            RenderHelper.drawBatch(stack, this.getRight() - 4, this.getBottom() - 4, 4.0, 4.0, 0.0, 0.09375, 0.109375, 0.484375, 0.5);
            RenderHelper.endDrawBatch();
        } else {
            this.fill(stack, this.getTheme().windowBorder, 0);
        }
    }

    public Workspace getWorkspace() {
        return (Workspace)this.parent;
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        this.constraint.apply();
        this.currentView.resize(mc, this.width, this.height);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            boolean isDocked;
            EdgeGrab grab;
            if (button == 0 && (this.canDrag() || this.canDragResize()) && (grab = new EdgeGrab((!(isDocked = this.parent.isDocked(this)) && !this.constraint.hasLeft() || isDocked && (!this.constraint.hasLeft() || this.parent.sameDockStack(this, this.constraint.get(Constraint.Property.Type.LEFT).getReference()))) && Window.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.borderSize.get()), (!isDocked && !this.constraint.hasRight() || isDocked && (!this.constraint.hasRight() || this.parent.sameDockStack(this, this.constraint.get(Constraint.Property.Type.RIGHT).getReference()))) && Window.isMouseBetween(mouseX, this.getRight() - this.borderSize.get(), this.getRight()), (!isDocked && !this.constraint.hasTop() || isDocked && (!this.constraint.hasTop() || this.parent.sameDockStack(this, this.constraint.get(Constraint.Property.Type.TOP).getReference()))) && Window.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.borderSize.get()), (!isDocked && !this.constraint.hasBottom() || isDocked && (!this.constraint.hasBottom() || this.parent.sameDockStack(this, this.constraint.get(Constraint.Property.Type.BOTTOM).getReference()))) && Window.isMouseBetween(mouseY, this.getBottom() - this.borderSize.get(), this.getBottom()), (!isDocked || this.canBeUndocked()) && Window.isMouseBetween(mouseY, this.getTop() + this.borderSize.get(), this.getTop() + this.titleSize.get()) && this.hasTitle(), (int)mouseX, (int)mouseY)).isActive()) {
                this.edgeGrab = grab;
                this.func_231037_b__(true);
            }
            if (this.edgeGrab == null) {
                super.func_231044_a_(mouseX, mouseY, button);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.edgeGrab != null) {
            if (this.edgeGrab.titleGrab && this.canBeDocked() && !this.parent.isDocked(this)) {
                int oriX = this.posX;
                int oriY = this.posY;
                this.pos(-10000, -10000);
                IWindows.DockInfo dockInfo = this.parent.getDockInfo(mouseX, mouseY, this.canDockStack());
                this.pos(oriX, oriY);
                if (dockInfo != null) {
                    if (dockInfo.window != null) {
                        this.parent.addToDocked(dockInfo.window, this);
                    } else {
                        this.parent.addToDock(this, dockInfo.type);
                    }
                }
            }
            this.edgeGrab = null;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double distX, double distY) {
        if (this.edgeGrab != null) {
            if (this.edgeGrab.titleGrab) {
                if (this.canDrag()) {
                    if (this.parent.isDocked(this) && this.canBeUndocked()) {
                        int oriX = this.posX;
                        int oriY = this.posY;
                        int oriWidth = this.width;
                        this.parent.removeFromDock(this);
                        this.posX += oriX - this.posX + (oriWidth - this.width) / 2;
                        this.posY += oriY - this.posY;
                    }
                    this.posX -= this.edgeGrab.x - (int)mouseX;
                    this.posY -= this.edgeGrab.y - (int)mouseY;
                    this.edgeGrab.x = (int)mouseX;
                    this.edgeGrab.y = (int)mouseY;
                }
            } else if (this.canDragResize()) {
                if (this.parent.isDocked(this)) {
                    this.dragResize(mouseX, mouseY, this.edgeGrab);
                    if (this.edgeGrab.left) {
                        this.getWorkspace().getDock().edgeGrab(this, mouseX, mouseY, new EdgeGrab(true, false, false, false, false, this.edgeGrab.x, this.edgeGrab.y));
                    }
                    if (this.edgeGrab.right) {
                        this.getWorkspace().getDock().edgeGrab(this, mouseX, mouseY, new EdgeGrab(false, true, false, false, false, this.edgeGrab.x, this.edgeGrab.y));
                    }
                    if (this.edgeGrab.top) {
                        this.getWorkspace().getDock().edgeGrab(this, mouseX, mouseY, new EdgeGrab(false, false, true, false, false, this.edgeGrab.x, this.edgeGrab.y));
                    }
                    if (this.edgeGrab.bottom) {
                        this.getWorkspace().getDock().edgeGrab(this, mouseX, mouseY, new EdgeGrab(false, false, false, true, false, this.edgeGrab.x, this.edgeGrab.y));
                    }
                } else {
                    this.dragResize(mouseX, mouseY, this.edgeGrab);
                }
            }
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, distX, distY);
    }

    public void dragResize(double mouseX, double mouseY, EdgeGrab grab) {
        int left = this.getLeft();
        int right = this.getRight();
        int top = this.getTop();
        int bottom = this.getBottom();
        if (grab.left) {
            this.setLeft((int)mouseX);
            this.setRight(right);
        } else if (grab.right) {
            this.setRight((int)mouseX);
        }
        if (grab.top) {
            this.setTop((int)mouseY);
            this.setBottom(bottom);
        } else if (grab.bottom) {
            this.setBottom((int)mouseY);
        }
        if (this.width < 20) {
            this.width = 20;
            this.setLeft(left);
        }
        if (this.height < 20) {
            this.height = 20;
            this.setTop(top);
        }
        this.resize(Minecraft.func_71410_x(), this.parent.getWidth(), this.parent.getHeight());
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    @Override
    public boolean func_231047_b_(double mouseX, double mouseY) {
        return !this.parent.isObstructed(this, mouseX, mouseY) && Window.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.width) && Window.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.height);
    }

    public boolean func_231049_c__(boolean direction) {
        if (this.parent.func_241217_q_() == this) {
            return super.func_231049_c__(direction);
        }
        return false;
    }

    @Override
    public boolean requireScissor() {
        return true;
    }

    @Override
    public void resetScissorToParent() {
        this.endScissor();
    }

    @Override
    public int getLeft() {
        return this.posX;
    }

    @Override
    public int getRight() {
        return this.posX + this.width;
    }

    @Override
    public int getTop() {
        return this.posY;
    }

    @Override
    public int getBottom() {
        return this.posY + this.height;
    }

    @Override
    public void setLeft(int x) {
        this.posX = x;
    }

    @Override
    public void setRight(int x) {
        this.width = x - this.posX;
    }

    @Override
    public void setTop(int y) {
        this.posY = y;
    }

    @Override
    public void setBottom(int y) {
        this.height = y - this.posY;
    }

    @Override
    public int getParentWidth() {
        return this.parent.getWidth();
    }

    @Override
    public int getParentHeight() {
        return this.parent.getHeight();
    }

    @Override
    public Theme getTheme() {
        return this.parent.getTheme();
    }

    @Override
    public int renderMinecraftStyle() {
        return this.parent.renderMinecraftStyle();
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.parent.getFontRenderer();
    }

    public static class EdgeGrab {
        boolean left;
        boolean right;
        boolean top;
        boolean bottom;
        boolean titleGrab;
        int x;
        int y;

        public EdgeGrab(boolean left, boolean right, boolean top, boolean bottom, boolean titleGrab, int x, int y) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
            this.titleGrab = titleGrab;
            this.x = x;
            this.y = y;
        }

        public boolean isActive() {
            return this.left || this.right || this.top || this.bottom || this.titleGrab;
        }
    }
}

