/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.Loader;
import com.anthonyhilyard.iceberg.events.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.util.StringRecomposer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8002;
import net.minecraft.class_918;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joml.Matrix4f;

public class Tooltips {
    private static final TooltipColors DEFAULT_COLORS = new TooltipColors(class_5251.method_27717((int)-267386864), class_5251.method_27717((int)-267386864), class_5251.method_27717((int)0x505000FF), class_5251.method_27717((int)1344798847));
    private static final class_5481 SPACE = class_5481.method_30747((String)" ", (class_2583)class_2583.field_24360);
    private static class_918 itemRenderer = null;
    private static boolean tooltipWidthWarningShown = false;
    public static TooltipColors currentColors = DEFAULT_COLORS;

    public static int calculateTitleLines(List<class_5684> components) {
        if (components == null || components.isEmpty()) {
            return 0;
        }
        int titleLines = 0;
        boolean foundTitleBreak = false;
        for (class_5684 component : components) {
            if (component instanceof class_5683) {
                ++titleLines;
                continue;
            }
            if (!(component instanceof TitleBreakComponent)) continue;
            foundTitleBreak = true;
            break;
        }
        if (!foundTitleBreak) {
            titleLines = 1;
        }
        return titleLines;
    }

    @Deprecated
    public static void renderItemTooltip(@Nonnull class_1799 stack, class_4587 poseStack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, false);
    }

    @Deprecated
    public static void renderItemTooltip(@Nonnull class_1799 stack, class_4587 poseStack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, comparison, false);
    }

    @Deprecated
    public static void renderItemTooltip(@Nonnull class_1799 stack, class_4587 poseStack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, backgroundColor, borderColorStart, borderColorEnd, comparison, constrain, false, 0);
    }

    @Deprecated
    public static void renderItemTooltip(@Nonnull class_1799 stack, class_4587 poseStack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColorStart, int backgroundColorEnd, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain, boolean centeredTitle, int index) {
        class_310 minecraft = class_310.method_1551();
        class_332 graphics = new class_332(minecraft, poseStack, minecraft.method_22940().method_23000());
        Tooltips.renderItemTooltip(stack, info, rect, screenWidth, screenHeight, backgroundColorStart, backgroundColorEnd, borderColorStart, borderColorEnd, graphics, class_8001.field_41687, comparison, constrain, centeredTitle, index);
    }

    public static void renderItemTooltip(@Nonnull class_1799 stack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColorStart, int backgroundColorEnd, int borderColorStart, int borderColorEnd, class_332 graphics, class_8000 positioner, boolean comparison, boolean constrain, boolean centeredTitle, int index) {
        int componentNumber;
        if (info.getComponents().isEmpty()) {
            return;
        }
        if (itemRenderer == null) {
            itemRenderer = class_310.method_1551().method_1480();
        }
        if (centeredTitle) {
            info = new TooltipInfo(Tooltips.centerTitle(info.getComponents(), info.getFont(), info.getMaxLineWidth(), info.getTitleLines()), info.getFont(), info.getTitleLines());
        }
        int rectX = rect.method_3321() + 4;
        int rectY = rect.method_3322() + 4;
        RenderTooltipEvents.PreExtResult preResult = ((RenderTooltipEvents.PreExt)RenderTooltipEvents.PREEXT.invoker()).onPre(stack, graphics, rectX, rectY, screenWidth, screenHeight, info.getFont(), info.getComponents(), positioner, comparison, index);
        if (preResult.result() != class_1269.field_5811) {
            return;
        }
        rectX = preResult.x();
        rectY = preResult.y();
        screenWidth = preResult.screenWidth();
        screenHeight = preResult.screenHeight();
        info.setFont(preResult.font());
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        int zLevel = 400;
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        RenderTooltipEvents.ColorExtResult colors = ((RenderTooltipEvents.ColorExt)RenderTooltipEvents.COLOREXT.invoker()).onColor(stack, graphics, rectX, rectY, info.getFont(), backgroundColorStart, backgroundColorEnd, borderColorStart, borderColorEnd, info.getComponents(), comparison, index);
        backgroundColorStart = colors.backgroundStart();
        backgroundColorEnd = colors.backgroundEnd();
        borderColorStart = colors.borderStart();
        borderColorEnd = colors.borderEnd();
        currentColors = new TooltipColors(class_5251.method_27717((int)backgroundColorStart), class_5251.method_27717((int)backgroundColorEnd), class_5251.method_27717((int)borderColorStart), class_5251.method_27717((int)borderColorEnd));
        int finalRectX = rectX;
        int finalRectY = rectY;
        graphics.method_51741(() -> class_8002.method_47946((class_332)graphics, (int)finalRectX, (int)finalRectY, (int)rect.method_3319(), (int)rect.method_3320(), (int)400));
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        poseStack.method_46416(0.0f, 0.0f, 400.0f);
        int tooltipTop = rectY;
        int titleLines = info.getTitleLines();
        for (componentNumber = 0; componentNumber < info.getComponents().size(); ++componentNumber) {
            class_5684 textComponent = info.getComponents().get(componentNumber);
            textComponent.method_32665(preResult.font(), rectX, tooltipTop, matrix4f, bufferSource);
            tooltipTop += textComponent.method_32661();
            if (!(textComponent instanceof class_5683) && !(textComponent instanceof InlineComponent) || titleLines <= 0 || (titleLines -= textComponent instanceof InlineComponent ? 2 : 1) > 0) continue;
            tooltipTop += 2;
        }
        bufferSource.method_22993();
        tooltipTop = rectY;
        for (componentNumber = 0; componentNumber < info.getComponents().size(); ++componentNumber) {
            class_5684 imageComponent = info.getComponents().get(componentNumber);
            imageComponent.method_32666(info.getFont(), rectX, tooltipTop, graphics);
            tooltipTop += imageComponent.method_32661() + (componentNumber == 0 ? 2 : 0);
        }
        poseStack.method_22909();
        ((RenderTooltipEvents.PostExt)RenderTooltipEvents.POSTEXT.invoker()).onPost(stack, graphics, rectX, rectY, info.getFont(), rect.method_3319(), rect.method_3320(), info.getComponents(), comparison, index);
    }

    private static class_5684 getClientComponent(class_5632 componentData) {
        class_5684 result = null;
        try {
            result = class_5684.method_32663((class_5632)componentData);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (result == null) {
            result = ((TooltipComponentCallback)TooltipComponentCallback.EVENT.invoker()).getComponent(componentData);
        }
        if (result == null) {
            try {
                result = (class_5684)componentData;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Unknown TooltipComponent");
        }
        return result;
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, class_327 forcedFont, class_327 fallbackFont, int maxWidth) {
        return Tooltips.gatherTooltipComponents(stack, textElements, itemComponent, mouseX, screenWidth, screenHeight, forcedFont, fallbackFont, maxWidth, 0);
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, class_327 forcedFont, class_327 fallbackFont, int maxWidth, int index) {
        class_327 font = forcedFont == null ? fallbackFont : forcedFont;
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        RenderTooltipEvents.GatherResult eventResult = ((RenderTooltipEvents.Gather)RenderTooltipEvents.GATHER.invoker()).onGather(stack, screenWidth, screenHeight, elements, maxWidth, index);
        if (eventResult.result() != class_1269.field_5811) {
            return List.of();
        }
        int tooltipTextWidth = eventResult.tooltipElements().stream().mapToInt(either -> (Integer)either.map(component -> {
            try {
                return font.method_27525(component);
            }
            catch (Exception e) {
                if (!tooltipWidthWarningShown) {
                    Loader.LOGGER.error("Error rendering tooltip component: \n" + ExceptionUtils.getStackTrace((Throwable)e));
                    tooltipWidthWarningShown = true;
                }
                return 0;
            }
        }, component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (eventResult.maxWidth() > 0 && tooltipTextWidth > eventResult.maxWidth()) {
            tooltipTextWidth = eventResult.maxWidth();
            needsWrap = true;
        }
        int tooltipTextWidthFinal = tooltipTextWidth;
        if (needsWrap) {
            return eventResult.tooltipElements().stream().flatMap(either -> (Stream)either.map(text -> font.method_1728(text, tooltipTextWidthFinal).stream().map(class_5684::method_32662), component -> Stream.of(Tooltips.getClientComponent(component)))).toList();
        }
        return eventResult.tooltipElements().stream().map(either -> (class_5684)either.map(text -> class_5684.method_32662((class_5481)(text instanceof class_2561 ? ((class_2561)text).method_30937() : class_2477.method_10517().method_30934(text))), Tooltips::getClientComponent)).toList();
    }

    @Deprecated
    public static class_768 calculateRect(class_1799 stack, class_4587 poseStack, List<class_5684> components, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, class_327 font) {
        return Tooltips.calculateRect(stack, poseStack, components, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font, 0, false);
    }

    @Deprecated
    public static class_768 calculateRect(class_1799 stack, class_4587 poseStack, List<class_5684> components, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, class_327 font, int minWidth, boolean centeredTitle) {
        class_310 minecraft = class_310.method_1551();
        class_332 graphics = new class_332(minecraft, poseStack, minecraft.method_22940().method_23000());
        return Tooltips.calculateRect(stack, graphics, class_8001.field_41687, components, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font, minWidth, centeredTitle);
    }

    public static class_768 calculateRect(class_1799 stack, class_332 graphics, class_8000 positioner, List<class_5684> components, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, class_327 font, int minWidth, boolean centeredTitle) {
        int componentWidth;
        class_768 rect = new class_768(0, 0, 0, 0);
        if (components == null || components.isEmpty() || stack == null) {
            return rect;
        }
        RenderTooltipEvents.PreExtResult preResult = ((RenderTooltipEvents.PreExt)RenderTooltipEvents.PREEXT.invoker()).onPre(stack, graphics, mouseX, mouseY, screenWidth, screenHeight, font, components, positioner, false, 0);
        if (preResult.result() != class_1269.field_5811) {
            return rect;
        }
        mouseX = preResult.x();
        mouseY = preResult.y();
        screenWidth = preResult.screenWidth();
        screenHeight = preResult.screenHeight();
        font = preResult.font();
        int tooltipTextWidth = minWidth;
        int tooltipHeight = components.size() == 1 ? -2 : 0;
        int titleLines = Tooltips.calculateTitleLines(components);
        if (centeredTitle) {
            for (class_5684 component : components) {
                componentWidth = component.method_32664(font);
                if (componentWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = componentWidth;
            }
            components = Tooltips.centerTitle(components, font, tooltipTextWidth, titleLines);
        }
        tooltipTextWidth = minWidth;
        for (class_5684 component : components) {
            componentWidth = component.method_32664(font);
            if (componentWidth > tooltipTextWidth) {
                tooltipTextWidth = componentWidth;
            }
            tooltipHeight += component.method_32661();
        }
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - 12;
        if (tooltipX + tooltipTextWidth > screenWidth) {
            tooltipX -= 28 + tooltipTextWidth;
        }
        if (tooltipY + tooltipHeight + 6 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 6;
        }
        rect = new class_768(tooltipX - 2, tooltipY - 4, tooltipTextWidth, tooltipHeight);
        return rect;
    }

    public static List<class_5684> centerTitle(List<class_5684> components, class_327 font, int width) {
        return Tooltips.centerTitle(components, font, width, Tooltips.calculateTitleLines(components));
    }

    public static List<class_5684> centerTitle(List<class_5684> components, class_327 font, int width, int titleLines) {
        ArrayList<class_5684> result = new ArrayList<class_5684>(components);
        if (components.isEmpty() || titleLines <= 0 || titleLines >= components.size()) {
            return result;
        }
        int titleIndex = 0;
        for (class_5684 clientTooltipComponent : components) {
            if (clientTooltipComponent instanceof class_5683) break;
            ++titleIndex;
        }
        for (int i = 0; i < titleLines; ++i) {
            class_5684 titleComponent = components.get(titleIndex + i);
            if (titleComponent == null) continue;
            List<class_5348> recomposedLines = StringRecomposer.recompose(List.of(titleComponent));
            if (recomposedLines.isEmpty()) {
                return components;
            }
            class_5481 title = class_2477.method_10517().method_30934(recomposedLines.get(0));
            while (class_5684.method_32662((class_5481)title).method_32664(font) < width && (title = class_5481.method_30755(List.of(SPACE, title, SPACE))) != null) {
            }
            result.set(titleIndex + i, class_5684.method_32662((class_5481)title));
        }
        return result;
    }

    public static class TitleBreakComponent
    implements class_5632,
    class_5684 {
        public int method_32661() {
            return 0;
        }

        public int method_32664(class_327 font) {
            return 0;
        }

        public static void registerFactory() {
            TooltipComponentCallback.EVENT.register(data -> {
                if (data instanceof TitleBreakComponent) {
                    TitleBreakComponent titleBreakComponent = (TitleBreakComponent)data;
                    return titleBreakComponent;
                }
                return null;
            });
        }
    }

    public static class TooltipInfo {
        private int tooltipWidth = 0;
        private int titleLines = 1;
        private class_327 font;
        private List<class_5684> components = new ArrayList<class_5684>();

        public TooltipInfo(List<class_5684> components, class_327 font) {
            this(components, font, Tooltips.calculateTitleLines(components));
        }

        public TooltipInfo(List<class_5684> components, class_327 font, int titleLines) {
            this.components = components;
            this.font = font;
            this.titleLines = titleLines;
            this.tooltipWidth = this.getMaxLineWidth();
        }

        public int getTooltipWidth() {
            return this.tooltipWidth;
        }

        public int getTooltipHeight() {
            return this.components.size() > this.titleLines ? this.components.size() * 10 + 2 : 8;
        }

        public int getTitleLines() {
            return this.titleLines;
        }

        public class_327 getFont() {
            return this.font;
        }

        public List<class_5684> getComponents() {
            return this.components;
        }

        public void setFont(class_327 font) {
            this.font = font;
        }

        public int getMaxLineWidth() {
            return this.getMaxLineWidth(0);
        }

        public int getMaxLineWidth(int minWidth) {
            int textWidth = minWidth;
            for (class_5684 component : this.components) {
                int componentWidth = component.method_32664(this.font);
                if (componentWidth <= textWidth) continue;
                textWidth = componentWidth;
            }
            return textWidth;
        }
    }

    public record TooltipColors(class_5251 backgroundColorStart, class_5251 backgroundColorEnd, class_5251 borderColorStart, class_5251 borderColorEnd) {
    }

    public static interface InlineComponent {
    }
}

