/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockPixieHouse;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenPixieVillage
extends Feature<NoFeatureConfig> {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public WorldGenPixieVillage(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator p_230362_3_, Random rand, BlockPos position, NoFeatureConfig p_230362_6_) {
        if (!IafWorldRegistry.isDimensionListedForFeatures((IServerWorld)worldIn)) {
            return false;
        }
        if (!IafConfig.spawnPixies || rand.nextInt(IafConfig.spawnPixiesChance) != 0 || !IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, position)) {
            return false;
        }
        position = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, position);
        int maxRoads = IafConfig.pixieVillageSize + rand.nextInt(5);
        BlockPos buildPosition = position;
        for (int placedRoads = 0; placedRoads < maxRoads; ++placedRoads) {
            int roadLength = 10 + rand.nextInt(15);
            Direction buildingDirection = Direction.func_176731_b((int)rand.nextInt(3));
            for (int i = 0; i < roadLength; ++i) {
                BlockPos buildPosition2 = buildPosition.func_177967_a(buildingDirection, i);
                if (worldIn.func_180495_p(buildPosition2 = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, buildPosition2).func_177977_b()).func_204520_s().func_206888_e()) {
                    worldIn.func_180501_a(buildPosition2, Blocks.field_185774_da.func_176223_P(), 2);
                } else {
                    worldIn.func_180501_a(buildPosition2, Blocks.field_196664_o.func_176223_P(), 2);
                }
                if (rand.nextInt(8) != 0) continue;
                Direction houseDir = rand.nextBoolean() ? buildingDirection.func_176746_e() : buildingDirection.func_176735_f();
                BlockState houseState = IafBlockRegistry.PIXIE_HOUSE_OAK.func_176223_P();
                int houseColor = rand.nextInt(5);
                switch (houseColor) {
                    case 0: {
                        houseState = (BlockState)IafBlockRegistry.PIXIE_HOUSE_MUSHROOM_RED.func_176223_P().func_206870_a((Property)BlockPixieHouse.FACING, (Comparable)houseDir.func_176734_d());
                        break;
                    }
                    case 1: {
                        houseState = (BlockState)IafBlockRegistry.PIXIE_HOUSE_MUSHROOM_BROWN.func_176223_P().func_206870_a((Property)BlockPixieHouse.FACING, (Comparable)houseDir.func_176734_d());
                        break;
                    }
                    case 2: {
                        houseState = (BlockState)IafBlockRegistry.PIXIE_HOUSE_OAK.func_176223_P().func_206870_a((Property)BlockPixieHouse.FACING, (Comparable)houseDir.func_176734_d());
                        break;
                    }
                    case 3: {
                        houseState = (BlockState)IafBlockRegistry.PIXIE_HOUSE_BIRCH.func_176223_P().func_206870_a((Property)BlockPixieHouse.FACING, (Comparable)houseDir.func_176734_d());
                        break;
                    }
                    case 4: {
                        houseState = (BlockState)IafBlockRegistry.PIXIE_HOUSE_SPRUCE.func_176223_P().func_206870_a((Property)BlockPixieHouse.FACING, (Comparable)houseDir.func_176734_d());
                        break;
                    }
                    case 5: {
                        houseState = (BlockState)IafBlockRegistry.PIXIE_HOUSE_DARK_OAK.func_176223_P().func_206870_a((Property)BlockPixieHouse.FACING, (Comparable)houseDir.func_176734_d());
                    }
                }
                EntityPixie pixie = (EntityPixie)IafEntityRegistry.PIXIE.func_200721_a((World)worldIn.func_201672_e());
                pixie.func_213386_a((IServerWorld)worldIn, worldIn.func_175649_E(buildPosition2.func_177984_a()), SpawnReason.SPAWNER, null, null);
                pixie.func_70107_b(buildPosition2.func_177958_n(), buildPosition2.func_177956_o() + 2, buildPosition2.func_177952_p());
                pixie.func_110163_bv();
                worldIn.func_217376_c((Entity)pixie);
                worldIn.func_180501_a(buildPosition2.func_177972_a(houseDir).func_177984_a(), houseState, 2);
                if (worldIn.func_180495_p(buildPosition2.func_177972_a(houseDir)).func_200132_m()) continue;
                worldIn.func_180501_a(buildPosition2.func_177972_a(houseDir), Blocks.field_196660_k.func_176223_P(), 2);
                worldIn.func_180501_a(buildPosition2.func_177972_a(houseDir).func_177977_b(), Blocks.field_196660_k.func_176223_P(), 2);
            }
            buildPosition = buildPosition.func_177967_a(buildingDirection, rand.nextInt(roadLength));
        }
        return true;
    }
}

