/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import net.minecraft.block.material.Material;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class StymphalianBirdAIAirTarget
extends Goal {
    private EntityStymphalianBird bird;
    private World theWorld;

    public StymphalianBirdAIAirTarget(EntityStymphalianBird bird) {
        this.bird = bird;
        this.theWorld = bird.field_70170_p;
    }

    public static BlockPos getNearbyAirTarget(EntityStymphalianBird bird) {
        if (bird.func_70638_az() == null) {
            BlockPos pos = DragonUtils.getBlockInViewStymphalian(bird);
            if (pos != null && bird.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151579_a) {
                return pos;
            }
            if (bird.flock != null && bird.flock.isLeader(bird)) {
                bird.flock.setTarget(bird.airTarget);
            }
        } else {
            return new BlockPos((double)((int)bird.func_70638_az().func_226277_ct_()), (double)((float)((int)bird.func_70638_az().func_226278_cu_()) + bird.func_70638_az().func_70047_e()), (double)((int)bird.func_70638_az().func_226281_cx_()));
        }
        return bird.func_233580_cy_();
    }

    public boolean func_75250_a() {
        if (this.bird != null) {
            if (!this.bird.isFlying()) {
                return false;
            }
            if (this.bird.func_70631_g_()) {
                return false;
            }
            if (this.bird.doesWantToLand()) {
                return false;
            }
            if (this.bird.airTarget != null && this.bird.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)this.bird.airTarget))) {
                this.bird.airTarget = null;
            }
            if (this.bird.airTarget != null) {
                return false;
            }
            Vector3d vec = this.findAirTarget();
            if (vec == null) {
                return false;
            }
            this.bird.airTarget = new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (!this.bird.isFlying()) {
            return false;
        }
        if (this.bird.func_70631_g_()) {
            return false;
        }
        return this.bird.airTarget != null;
    }

    public Vector3d findAirTarget() {
        return Vector3d.func_237489_a_((Vector3i)StymphalianBirdAIAirTarget.getNearbyAirTarget(this.bird));
    }
}

