/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityPixie;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class PixieAIFollowOwner
extends Goal {
    private final EntityPixie tameable;
    private final double followSpeed;
    World world;
    float maxDist;
    float minDist;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public PixieAIFollowOwner(EntityPixie tameableIn, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.tameable = tameableIn;
        this.world = tameableIn.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        LivingEntity LivingEntity2 = this.tameable.func_70902_q();
        if (LivingEntity2 == null) {
            return false;
        }
        if (LivingEntity2 instanceof PlayerEntity && LivingEntity2.func_175149_v()) {
            return false;
        }
        if (this.tameable.isPixieSitting()) {
            return false;
        }
        if (this.tameable.func_70068_e((Entity)LivingEntity2) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = LivingEntity2;
        return true;
    }

    public boolean func_75253_b() {
        return !this.tameable.isPixieSitting() && this.tameable.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tameable.func_184643_a(PathNodeType.WATER);
        this.tameable.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.tameable.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        this.tameable.slowSpeed = false;
    }

    private boolean isEmptyBlock(BlockPos pos) {
        BlockState BlockState2 = this.world.func_180495_p(pos);
        return BlockState2.func_185904_a() == Material.field_151579_a || !BlockState2.func_200132_m();
    }

    public void func_75246_d() {
        this.tameable.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.tameable.func_70646_bf());
        if (!this.tameable.isPixieSitting() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            this.tameable.func_70605_aq().func_75642_a(this.owner.func_226277_ct_(), this.owner.func_226278_cu_() + (double)this.owner.func_70047_e(), this.owner.func_226281_cx_(), 0.25);
            this.tameable.slowSpeed = true;
            if (!this.tameable.func_110167_bD() && this.tameable.func_70068_e((Entity)this.owner) >= 50.0) {
                int i = MathHelper.func_76128_c((double)this.owner.func_226277_ct_()) - 2;
                int j = MathHelper.func_76128_c((double)this.owner.func_226281_cx_()) - 2;
                int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isEmptyBlock(new BlockPos(i + l, k, j + i1)) || !this.isEmptyBlock(new BlockPos(i + l, k + 1, j + i1))) continue;
                        this.tameable.func_70012_b((float)(i + l) + 0.5f, (double)k + 1.5, (float)(j + i1) + 0.5f, this.tameable.field_70177_z, this.tameable.field_70125_A);
                        return;
                    }
                }
            }
        }
    }
}

