/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class EntityStoneStatue
extends LivingEntity
implements IBlacklistedFromStatues {
    public boolean smallArms;
    private static final DataParameter<String> TRAPPED_ENTITY_TYPE = EntityDataManager.func_187226_a(EntityStoneStatue.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<CompoundNBT> TRAPPED_ENTITY_DATA = EntityDataManager.func_187226_a(EntityStoneStatue.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Float> TRAPPED_ENTITY_WIDTH = EntityDataManager.func_187226_a(EntityStoneStatue.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> TRAPPED_ENTITY_HEIGHT = EntityDataManager.func_187226_a(EntityStoneStatue.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> TRAPPED_ENTITY_SCALE = EntityDataManager.func_187226_a(EntityStoneStatue.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> CRACK_AMOUNT = EntityDataManager.func_187226_a(EntityStoneStatue.class, (IDataSerializer)DataSerializers.field_187192_b);
    private EntitySize stoneStatueSize = EntitySize.func_220311_c((float)0.5f, (float)0.5f);

    public EntityStoneStatue(EntityType t, World worldIn) {
        super(t, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233823_f_, 1.0);
    }

    public void func_70108_f(Entity entityIn) {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRAPPED_ENTITY_TYPE, (Object)"minecraft:pig");
        this.field_70180_af.func_187214_a(TRAPPED_ENTITY_DATA, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(TRAPPED_ENTITY_WIDTH, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(TRAPPED_ENTITY_HEIGHT, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(TRAPPED_ENTITY_SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(CRACK_AMOUNT, (Object)0);
    }

    public EntityType getTrappedEntityType() {
        String str = this.getTrappedEntityTypeString();
        return EntityType.func_220327_a((String)str).orElse(EntityType.field_200784_X);
    }

    public String getTrappedEntityTypeString() {
        return (String)this.field_70180_af.func_187225_a(TRAPPED_ENTITY_TYPE);
    }

    public void setTrappedEntityTypeString(String string) {
        this.field_70180_af.func_187227_b(TRAPPED_ENTITY_TYPE, (Object)string);
    }

    public CompoundNBT getTrappedTag() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(TRAPPED_ENTITY_DATA);
    }

    public void setTrappedTag(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(TRAPPED_ENTITY_DATA, (Object)tag);
    }

    public float getTrappedWidth() {
        return ((Float)this.field_70180_af.func_187225_a(TRAPPED_ENTITY_WIDTH)).floatValue();
    }

    public void setTrappedEntityWidth(float size) {
        this.field_70180_af.func_187227_b(TRAPPED_ENTITY_WIDTH, (Object)Float.valueOf(size));
    }

    public float getTrappedHeight() {
        return ((Float)this.field_70180_af.func_187225_a(TRAPPED_ENTITY_HEIGHT)).floatValue();
    }

    public void setTrappedHeight(float size) {
        this.field_70180_af.func_187227_b(TRAPPED_ENTITY_HEIGHT, (Object)Float.valueOf(size));
    }

    public float getTrappedScale() {
        return ((Float)this.field_70180_af.func_187225_a(TRAPPED_ENTITY_SCALE)).floatValue();
    }

    public void setTrappedScale(float size) {
        this.field_70180_af.func_187227_b(TRAPPED_ENTITY_SCALE, (Object)Float.valueOf(size));
    }

    public static EntityStoneStatue buildStatueEntity(LivingEntity parent) {
        EntityStoneStatue statue = (EntityStoneStatue)IafEntityRegistry.STONE_STATUE.func_200721_a(parent.field_70170_p);
        CompoundNBT entityTag = new CompoundNBT();
        try {
            parent.func_189511_e(entityTag);
        }
        catch (Exception e) {
            IceAndFire.LOGGER.debug("Encountered issue creating stone statue from {}", (Object)parent);
        }
        statue.setTrappedTag(entityTag);
        statue.setTrappedEntityTypeString(Registry.field_212629_r.func_177774_c((Object)parent.func_200600_R()).toString());
        statue.setTrappedEntityWidth(parent.func_213311_cf());
        statue.setTrappedHeight(parent.func_213302_cg());
        statue.setTrappedScale(parent.func_213355_cm());
        return statue;
    }

    @Nullable
    public AxisAlignedBB getCollisionBox(Entity entityIn) {
        return this.getCollisionBoundingBox();
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox() {
        return this.func_174813_aQ();
    }

    public boolean isAIDisabled() {
        return true;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("CrackAmount", this.getCrackAmount());
        tag.func_74776_a("StatueWidth", this.getTrappedWidth());
        tag.func_74776_a("StatueHeight", this.getTrappedHeight());
        tag.func_74776_a("StatueScale", this.getTrappedScale());
        tag.func_74778_a("StatueEntityType", this.getTrappedEntityTypeString());
        tag.func_218657_a("StatueEntityTag", (INBT)this.getTrappedTag());
    }

    public float func_213355_cm() {
        return this.getTrappedScale();
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setCrackAmount(tag.func_74771_c("CrackAmount"));
        this.setTrappedEntityWidth(tag.func_74760_g("StatueWidth"));
        this.setTrappedHeight(tag.func_74760_g("StatueHeight"));
        this.setTrappedScale(tag.func_74760_g("StatueScale"));
        this.setTrappedEntityTypeString(tag.func_74779_i("StatueEntityType"));
        if (tag.func_74764_b("StatueEntityTag")) {
            this.setTrappedTag(tag.func_74775_l("StatueEntityTag"));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return source == DamageSource.field_76380_i;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.stoneStatueSize;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70759_as = this.field_70177_z = this.field_70761_aq;
        if ((double)Math.abs(this.func_213311_cf() - this.getTrappedWidth()) > 0.01 || (double)Math.abs(this.func_213302_cg() - this.getTrappedHeight()) > 0.01) {
            double prevX = this.func_226277_ct_();
            double prevZ = this.func_226281_cx_();
            this.stoneStatueSize = EntitySize.func_220314_b((float)this.getTrappedWidth(), (float)this.getTrappedHeight());
            this.func_213323_x_();
            this.func_70107_b(prevX, this.func_226278_cu_(), prevZ);
        }
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public Iterable<ItemStack> func_184193_aE() {
        return ImmutableList.of();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    public int getCrackAmount() {
        return (Integer)this.field_70180_af.func_187225_a(CRACK_AMOUNT);
    }

    public void setCrackAmount(int crackAmount) {
        this.field_70180_af.func_187227_b(CRACK_AMOUNT, (Object)crackAmount);
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }
}

