/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.iceandfire.client.model.ModelHydraBody;
import com.github.alexthe666.iceandfire.client.model.ModelHydraHead;
import com.github.alexthe666.iceandfire.client.render.entity.RenderHydra;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerHydraHead
extends LayerRenderer<EntityHydra, ModelHydraBody> {
    public static final ResourceLocation TEXTURE_STONE = new ResourceLocation("iceandfire:textures/models/hydra/stone.png");
    private static final float[][] TRANSLATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.15f, 0.15f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.3f, 0.0f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.4f, -0.1f, 0.1f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.5f, -0.2f, 0.0f, 0.2f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.0f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.1f, 0.2f, 0.4f, 0.6f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.0f, 0.1f, 0.2f, 0.4f, 0.6f}};
    private static final float[][] ROTATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, 0.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {25.0f, 10.0f, -10.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {30.0f, 15.0f, 0.0f, -15.0f, -30.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 25.0f, 5.0f, -5.0f, -25.0f, -40.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 30.0f, 15.0f, 0.0f, -15.0f, -30.0f, -40.0f, 0.0f, 0.0f}, {45.0f, 30.0f, 20.0f, 5.0f, -5.0f, -20.0f, -30.0f, -45.0f, 0.0f}, {50.0f, 37.0f, 25.0f, 15.0f, 0.0f, -15.0f, -25.0f, -37.0f, -50.0f}};
    private final RenderHydra renderer;
    private static ModelHydraHead[] modelArr = new ModelHydraHead[9];

    public LayerHydraHead(RenderHydra renderer) {
        super((IEntityRenderer)renderer);
        this.renderer = renderer;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityHydra entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.func_82150_aj()) {
            return;
        }
        LayerHydraHead.renderHydraHeads((ModelHydraBody)this.renderer.func_217764_d(), false, matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
    }

    public static void renderHydraHeads(ModelHydraBody model, boolean stone, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityHydra hydra, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.func_227860_a_();
        int heads = hydra.getHeadCount();
        LayerHydraHead.translateToBody(model, matrixStackIn);
        RenderType type = RenderType.func_228638_b_((ResourceLocation)(stone ? TEXTURE_STONE : LayerHydraHead.getHeadTexture(hydra)));
        for (int head = 1; head <= heads; ++head) {
            matrixStackIn.func_227860_a_();
            float bodyWidth = 0.5f;
            matrixStackIn.func_227861_a_((double)(TRANSLATE[heads - 1][head - 1] * bodyWidth), 0.0, 0.0);
            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, ROTATE[heads - 1][head - 1], true));
            modelArr[head - 1].setRotationAngles(hydra, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            modelArr[head - 1].func_225598_a_(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)hydra, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
    }

    public static ResourceLocation getHeadTexture(EntityHydra gorgon) {
        switch (gorgon.getVariant()) {
            default: {
                return RenderHydra.TEXUTURE_0;
            }
            case 1: {
                return RenderHydra.TEXUTURE_1;
            }
            case 2: 
        }
        return RenderHydra.TEXUTURE_2;
    }

    public ResourceLocation getEntityTexture(EntityHydra gorgon) {
        switch (gorgon.getVariant()) {
            default: {
                return RenderHydra.TEXUTURE_0;
            }
            case 1: {
                return RenderHydra.TEXUTURE_1;
            }
            case 2: 
        }
        return RenderHydra.TEXUTURE_2;
    }

    protected static void translateToBody(ModelHydraBody model, MatrixStack stack) {
        LayerHydraHead.postRender(model.BodyUpper, stack, 0.0625f);
    }

    protected static void postRender(AdvancedModelBox renderer, MatrixStack matrixStackIn, float scale) {
        if (renderer.field_78795_f == 0.0f && renderer.field_78796_g == 0.0f && renderer.field_78808_h == 0.0f) {
            if (renderer.field_78800_c != 0.0f || renderer.field_78797_d != 0.0f || renderer.field_78798_e != 0.0f) {
                matrixStackIn.func_227861_a_((double)(renderer.field_78800_c * scale), (double)(renderer.field_78797_d * scale), (double)(renderer.field_78798_e * scale));
            }
        } else {
            matrixStackIn.func_227861_a_((double)(renderer.field_78800_c * scale), (double)(renderer.field_78797_d * scale), (double)(renderer.field_78798_e * scale));
            if (renderer.field_78808_h != 0.0f) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(renderer.field_78808_h));
            }
            if (renderer.field_78796_g != 0.0f) {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(renderer.field_78796_g));
            }
            if (renderer.field_78795_f != 0.0f) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(renderer.field_78795_f));
            }
        }
    }

    static {
        for (int i = 0; i < modelArr.length; ++i) {
            LayerHydraHead.modelArr[i] = new ModelHydraHead(i);
        }
    }
}

