/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.ModelGhost;
import com.github.alexthe666.iceandfire.client.render.IafRenderType;
import com.github.alexthe666.iceandfire.entity.EntityGhost;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class RenderGhost
extends MobRenderer<EntityGhost, ModelGhost> {
    public static final ResourceLocation TEXTURE_0 = new ResourceLocation("iceandfire:textures/models/ghost/ghost_white.png");
    public static final ResourceLocation TEXTURE_1 = new ResourceLocation("iceandfire:textures/models/ghost/ghost_blue.png");
    public static final ResourceLocation TEXTURE_2 = new ResourceLocation("iceandfire:textures/models/ghost/ghost_green.png");
    public static final ResourceLocation TEXTURE_SHOPPING_LIST = new ResourceLocation("iceandfire:textures/models/ghost/haunted_shopping_list.png");

    public RenderGhost(EntityRendererManager renderManager) {
        super(renderManager, (EntityModel)new ModelGhost(), 0.55f);
    }

    public static ResourceLocation getGhostOverlayForType(int ghost) {
        switch (ghost) {
            default: {
                return TEXTURE_0;
            }
            case 1: {
                return TEXTURE_1;
            }
            case 2: {
                return TEXTURE_2;
            }
            case -1: 
        }
        return TEXTURE_SHOPPING_LIST;
    }

    public void render(EntityGhost entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        RenderType rendertype;
        Direction direction;
        boolean shouldSit;
        this.field_76989_e = 0.0f;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntity)entityIn, (LivingRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn))) {
            return;
        }
        matrixStackIn.func_227860_a_();
        ((ModelGhost)this.field_77045_g).field_217112_c = this.func_77040_d((LivingEntity)entityIn, partialTicks);
        ((ModelGhost)this.field_77045_g).field_217113_d = shouldSit = entityIn.func_184218_aH() && entityIn.func_184187_bx() != null && entityIn.func_184187_bx().shouldRiderSit();
        ((ModelGhost)this.field_77045_g).field_217114_e = entityIn.func_70631_g_();
        float f = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70760_ar, (float)entityIn.field_70761_aq);
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70758_at, (float)entityIn.field_70759_as);
        float f2 = f1 - f;
        if (shouldSit && entityIn.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.func_184187_bx();
            f = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            f2 = f1 - f;
            float f3 = MathHelper.func_76142_g((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_70127_C, (float)entityIn.field_70125_A);
        if (entityIn.func_213283_Z() == Pose.SLEEPING && (direction = entityIn.func_213376_dz()) != null) {
            float f4 = entityIn.func_213307_e(Pose.STANDING) - 0.1f;
            matrixStackIn.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float f7 = this.func_77044_a((LivingEntity)entityIn, partialTicks);
        this.func_225621_a_((LivingEntity)entityIn, matrixStackIn, f7, f, partialTicks);
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.preRenderCallback(entityIn, matrixStackIn, partialTicks);
        matrixStackIn.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.func_70089_S()) {
            f8 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_184618_aE, (float)entityIn.field_70721_aZ);
            f5 = entityIn.field_184619_aG - entityIn.field_70721_aZ * (1.0f - partialTicks);
            if (entityIn.func_70631_g_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((ModelGhost)this.field_77045_g).func_212843_a_((Entity)entityIn, f5, f8, partialTicks);
        ((ModelGhost)this.field_77045_g).setRotationAngles(entityIn, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean flag = this.func_225622_a_((LivingEntity)entityIn);
        boolean flag1 = !flag && !entityIn.func_98034_c((PlayerEntity)minecraft.field_71439_g);
        float alphaForRender = this.getAlphaForRender(entityIn, partialTicks);
        RenderType renderType = rendertype = entityIn.isDaytimeMode() ? IafRenderType.getGhostDaytime(this.getEntityTexture(entityIn)) : IafRenderType.getGhost(this.getEntityTexture(entityIn));
        if (rendertype != null && !entityIn.func_82150_aj()) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(rendertype);
            int i = RenderGhost.func_229117_c_((LivingEntity)entityIn, (float)this.func_225625_b_((LivingEntity)entityIn, partialTicks));
            if (entityIn.isHauntedShoppingList()) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(0.0, (double)0.8f + Math.sin(((float)entityIn.field_70173_aa + partialTicks) * 0.15f) * (double)0.1f, 0.0);
                matrixStackIn.func_227862_a_(0.6f, 0.6f, 0.6f);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStackIn.func_227860_a_();
                MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
                Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
                Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, -2, 0, 1.0f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, -2, 0, 0.5f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, 2, 0, 0.5f, 1.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, 2, 0, 1.0f, 1.0f, 0, 1, 0, 240);
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStackIn.func_227860_a_();
                matrixstack$entry = matrixStackIn.func_227866_c_();
                matrix4f = matrixstack$entry.func_227870_a_();
                matrix3f = matrixstack$entry.func_227872_b_();
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, -2, 0, 0.0f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, -2, 0, 0.5f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, 2, 0, 0.5f, 1.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, 2, 0, 0.0f, 1.0f, 0, 1, 0, 240);
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227865_b_();
            } else {
                ((ModelGhost)this.field_77045_g).func_225598_a_(matrixStackIn, ivertexbuilder, 240, i, 1.0f, 1.0f, 1.0f, alphaForRender);
            }
        }
        if (!entityIn.func_175149_v()) {
            for (LayerRenderer layerrenderer : this.field_177097_h) {
                layerrenderer.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        matrixStackIn.func_227865_b_();
        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent((Entity)entityIn, entityIn.func_145748_c_(), (EntityRenderer)this, matrixStackIn, bufferIn, packedLightIn, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.func_177070_b((MobEntity)entityIn))) {
            this.func_225629_a_((Entity)entityIn, renderNameplateEvent.getContent(), matrixStackIn, bufferIn, packedLightIn);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)entityIn, (LivingRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn));
    }

    protected float getDeathMaxRotation(EntityGhost ghost) {
        return 0.0f;
    }

    public float getAlphaForRender(EntityGhost entityIn, float partialTicks) {
        if (entityIn.isDaytimeMode()) {
            return MathHelper.func_76131_a((float)((float)(101 - Math.min(entityIn.getDaytimeCounter(), 100)) / 100.0f), (float)0.0f, (float)1.0f);
        }
        return MathHelper.func_76131_a((float)(((float)Math.sin(((float)entityIn.field_70173_aa + partialTicks) * 0.1f) + 1.0f) * 0.5f + 0.1f), (float)0.0f, (float)1.0f);
    }

    public void preRenderCallback(EntityGhost LivingEntityIn, MatrixStack stack, float partialTickTime) {
    }

    public ResourceLocation getEntityTexture(EntityGhost ghost) {
        switch (ghost.getColor()) {
            default: {
                return TEXTURE_0;
            }
            case 1: {
                return TEXTURE_1;
            }
            case 2: {
                return TEXTURE_2;
            }
            case -1: 
        }
        return TEXTURE_SHOPPING_LIST;
    }

    public void drawVertex(Matrix4f stack, Matrix3f normal, IVertexBuilder builder, int packedRed, int alphaInt, int x, int y, int z, float u, float v, int lightmap, int lightmap3, int lightmap2, int lightmap4) {
        builder.func_227888_a_(stack, (float)x, (float)y, (float)z).func_225586_a_(255, 255, 255, alphaInt).func_225583_a_(u, v).func_227891_b_(packedRed).func_227886_a_(lightmap4).func_227887_a_(normal, (float)lightmap, (float)lightmap2, (float)lightmap3).func_181675_d();
    }
}

