/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.HomePosition;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCaveStalactites;
import com.github.alexthe666.iceandfire.world.gen.WorldGenDragonCave;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenLightningDragonCave
extends WorldGenDragonCave {
    public static ResourceLocation LIGHTNING_DRAGON_CHEST = new ResourceLocation("iceandfire", "chest/lightning_dragon_female_cave");
    public static ResourceLocation LIGHTNING_DRAGON_CHEST_MALE = new ResourceLocation("iceandfire", "chest/lightning_dragon_male_cave");

    public WorldGenLightningDragonCave(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
        this.DRAGON_CHEST = LIGHTNING_DRAGON_CHEST;
        this.DRAGON_MALE_CHEST = LIGHTNING_DRAGON_CHEST_MALE;
        this.CEILING_DECO = new WorldGenCaveStalactites(IafBlockRegistry.CRACKLED_STONE, 9);
        this.PALETTE_BLOCK1 = IafBlockRegistry.CRACKLED_STONE.func_176223_P();
        this.PALETTE_BLOCK2 = IafBlockRegistry.CRACKLED_COBBLESTONE.func_176223_P();
        this.TREASURE_PILE = IafBlockRegistry.COPPER_PILE.func_176223_P();
        this.PALETTE_ORE1 = IafBlockRegistry.AMYTHEST_ORE.func_176223_P();
        this.PALETTE_ORE2 = Blocks.field_150412_bA.func_176223_P();
        this.generateGemOre = IafConfig.generateAmythestOre;
    }

    @Override
    EntityDragonBase createDragon(ISeedReader worldIn, Random rand, BlockPos position, int dragonAge) {
        EntityLightningDragon dragon = new EntityLightningDragon((EntityType)IafEntityRegistry.LIGHTNING_DRAGON.get(), (World)worldIn.func_201672_e());
        dragon.setGender(this.isMale);
        dragon.growDragon(dragonAge);
        dragon.setAgingDisabled(true);
        dragon.func_70606_j(dragon.func_110138_aP());
        dragon.setVariant(rand.nextInt(4));
        dragon.func_70080_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        dragon.func_233686_v_(true);
        dragon.homePos = new HomePosition(position, (World)worldIn.func_201672_e());
        dragon.setHunger(50);
        return dragon;
    }
}

