/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.HomePosition;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCaveStalactites;
import com.github.alexthe666.iceandfire.world.gen.WorldGenDragonCave;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenFireDragonCave
extends WorldGenDragonCave {
    public static ResourceLocation FIRE_DRAGON_CHEST = new ResourceLocation("iceandfire", "chest/fire_dragon_female_cave");
    public static ResourceLocation FIRE_DRAGON_CHEST_MALE = new ResourceLocation("iceandfire", "chest/fire_dragon_male_cave");

    public WorldGenFireDragonCave(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
        this.DRAGON_CHEST = FIRE_DRAGON_CHEST;
        this.DRAGON_MALE_CHEST = FIRE_DRAGON_CHEST_MALE;
        this.CEILING_DECO = new WorldGenCaveStalactites(IafBlockRegistry.CHARRED_STONE, 3);
        this.PALETTE_BLOCK1 = IafBlockRegistry.CHARRED_STONE.func_176223_P();
        this.PALETTE_BLOCK2 = IafBlockRegistry.CHARRED_COBBLESTONE.func_176223_P();
        this.TREASURE_PILE = IafBlockRegistry.GOLD_PILE.func_176223_P();
        this.PALETTE_ORE1 = Blocks.field_150412_bA.func_176223_P();
        this.PALETTE_ORE2 = Blocks.field_150412_bA.func_176223_P();
        this.generateGemOre = true;
    }

    @Override
    EntityDragonBase createDragon(ISeedReader worldIn, Random rand, BlockPos position, int dragonAge) {
        EntityFireDragon dragon = new EntityFireDragon((EntityType)IafEntityRegistry.FIRE_DRAGON.get(), (World)worldIn.func_201672_e());
        dragon.setGender(this.isMale);
        dragon.growDragon(dragonAge);
        dragon.setAgingDisabled(true);
        dragon.func_70606_j(dragon.func_110138_aP());
        dragon.setVariant(rand.nextInt(4));
        dragon.func_70080_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        dragon.func_233686_v_(true);
        dragon.homePos = new HomePosition(position, (World)worldIn.func_201672_e());
        dragon.setHunger(50);
        return dragon;
    }
}

