/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.feature;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SpawnDeathWorm
extends Feature<NoFeatureConfig> {
    public SpawnDeathWorm(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator p_230362_3_, Random rand, BlockPos position, NoFeatureConfig p_230362_6_) {
        if (!IafWorldRegistry.isDimensionListedForMobs((IServerWorld)worldIn)) {
            return false;
        }
        position = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, position.func_177982_a(8, 0, 8));
        if (IafConfig.spawnDeathWorm && IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, position) && rand.nextInt(IafConfig.deathWormSpawnRate + 1) == 0) {
            EntityDeathWorm deathWorm = (EntityDeathWorm)((EntityType)IafEntityRegistry.DEATH_WORM.get()).func_200721_a((World)worldIn.func_201672_e());
            deathWorm.func_70107_b((float)position.func_177958_n() + 0.5f, position.func_177956_o() + 1, (float)position.func_177952_p() + 0.5f);
            deathWorm.func_213386_a((IServerWorld)worldIn, worldIn.func_175649_E(position), SpawnReason.CHUNK_GENERATION, null, null);
            worldIn.func_217376_c((Entity)deathWorm);
        }
        return false;
    }
}

