/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding.raycoms;

import com.github.alexthe666.iceandfire.pathfinding.raycoms.AbstractAdvancedPathNavigate;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.IStuckHandler;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.SurfaceType;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PathingStuckHandler
implements IStuckHandler {
    private static final double MIN_TARGET_DIST = 3.0;
    private final List<Direction> directions = Arrays.asList(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
    private static final int MIN_TP_DELAY = 2400;
    private static final int MIN_DIST_FOR_TP = 10;
    private int teleportRange = 0;
    private int timePerBlockDistance = 100;
    private int stuckLevel = 0;
    private int globalTimeout = 0;
    private BlockPos prevDestination = BlockPos.field_177992_a;
    private boolean canBreakBlocks = false;
    private boolean canPlaceLadders = false;
    private boolean canBuildLeafBridges = false;
    private boolean canTeleportGoal = false;
    private boolean takeDamageOnCompleteStuck = false;
    private float damagePct = 0.2f;
    private int completeStuckBlockBreakRange = 0;
    private boolean hadPath = false;
    private int lastPathIndex = -1;
    private int progressedNodes = 0;
    private int delayBeforeActions;
    private int delayToNextUnstuckAction = this.delayBeforeActions = 1200;
    private BlockPos moveAwayStartPos = BlockPos.field_177992_a;
    private final Random rand = new Random();

    private PathingStuckHandler() {
    }

    public static PathingStuckHandler createStuckHandler() {
        return new PathingStuckHandler();
    }

    @Override
    public void checkStuck(AbstractAdvancedPathNavigate navigator) {
        if (navigator.getDesiredPos() == null || navigator.getDesiredPos().equals((Object)BlockPos.field_177992_a)) {
            return;
        }
        double distanceToGoal = navigator.getOurEntity().func_213303_ch().func_72438_d(new Vector3d((double)navigator.getDesiredPos().func_177958_n(), (double)navigator.getDesiredPos().func_177956_o(), (double)navigator.getDesiredPos().func_177952_p()));
        if (distanceToGoal < 3.0) {
            this.resetGlobalStuckTimers();
            return;
        }
        if (this.prevDestination.equals((Object)navigator.getDesiredPos())) {
            ++this.globalTimeout;
            if ((double)this.globalTimeout > Math.max(2400.0, (double)this.timePerBlockDistance * Math.max(10.0, distanceToGoal))) {
                this.completeStuckAction(navigator);
            }
        } else {
            this.resetGlobalStuckTimers();
        }
        this.prevDestination = navigator.getDesiredPos();
        if (navigator.func_75505_d() == null || navigator.func_75505_d().func_75879_b()) {
            this.lastPathIndex = -1;
            this.progressedNodes = 0;
            if (!this.hadPath) {
                this.tryUnstuck(navigator);
            }
        } else if (navigator.func_75505_d().func_75873_e() == this.lastPathIndex) {
            this.tryUnstuck(navigator);
        } else if (this.lastPathIndex != -1 && navigator.func_75505_d().func_224770_k().func_177951_i((Vector3i)this.prevDestination) < 25.0) {
            int n = this.progressedNodes = navigator.func_75505_d().func_75873_e() > this.lastPathIndex ? this.progressedNodes + 1 : this.progressedNodes - 1;
            if (!(this.progressedNodes <= 5 || navigator.func_75505_d().func_75870_c() != null && this.moveAwayStartPos.equals((Object)navigator.func_75505_d().func_75870_c().func_224759_a()))) {
                this.resetStuckTimers();
            }
        }
        this.lastPathIndex = navigator.func_75505_d() != null ? navigator.func_75505_d().func_75873_e() : -1;
        this.hadPath = navigator.func_75505_d() != null && !navigator.func_75505_d().func_75879_b();
    }

    private void resetGlobalStuckTimers() {
        this.globalTimeout = 0;
        this.prevDestination = BlockPos.field_177992_a;
        this.resetStuckTimers();
    }

    private void completeStuckAction(AbstractAdvancedPathNavigate navigator) {
        BlockPos tpPos;
        BlockPos desired = navigator.getDesiredPos();
        World world = navigator.getOurEntity().field_70170_p;
        MobEntity entity = navigator.getOurEntity();
        if (this.canTeleportGoal && (tpPos = PathingStuckHandler.findAround(world, desired, 10, 10, (posworld, pos) -> SurfaceType.getSurfaceType(posworld, posworld.func_180495_p(pos.func_177977_b()), pos.func_177977_b()) == SurfaceType.WALKABLE && SurfaceType.getSurfaceType(posworld, posworld.func_180495_p(pos), pos) == SurfaceType.DROPABLE && SurfaceType.getSurfaceType(posworld, posworld.func_180495_p(pos.func_177984_a()), pos.func_177984_a()) == SurfaceType.DROPABLE)) != null) {
            entity.func_70634_a((double)tpPos.func_177958_n() + 0.5, (double)tpPos.func_177956_o(), (double)tpPos.func_177952_p() + 0.5);
        }
        if (this.takeDamageOnCompleteStuck) {
            entity.func_70097_a((DamageSource)new EntityDamageSource("Stuck-damage", (Entity)entity), entity.func_110138_aP() * this.damagePct);
        }
        if (this.completeStuckBlockBreakRange > 0) {
            Direction facing = PathingStuckHandler.getFacing(entity.func_233580_cy_(), navigator.getDesiredPos());
            for (int i = 1; i <= this.completeStuckBlockBreakRange; ++i) {
                if (world.func_175623_d(new BlockPos((Vector3i)entity.func_233580_cy_()).func_177967_a(facing, i)) && world.func_175623_d(new BlockPos((Vector3i)entity.func_233580_cy_()).func_177967_a(facing, i).func_177984_a())) continue;
                this.breakBlocksAhead(world, new BlockPos((Vector3i)entity.func_233580_cy_()).func_177967_a(facing, i - 1), facing);
                break;
            }
        }
        navigator.func_75499_g();
        this.resetGlobalStuckTimers();
    }

    private void tryUnstuck(AbstractAdvancedPathNavigate navigator) {
        if (this.delayToNextUnstuckAction-- > 0) {
            return;
        }
        this.delayToNextUnstuckAction = 50;
        if (this.stuckLevel == 0) {
            ++this.stuckLevel;
            this.delayToNextUnstuckAction = 100;
            navigator.func_75499_g();
            return;
        }
        if (this.stuckLevel == 1) {
            ++this.stuckLevel;
            this.delayToNextUnstuckAction = 200;
            navigator.func_75499_g();
            navigator.moveAwayFromXYZ(new BlockPos((Vector3i)navigator.getOurEntity().func_233580_cy_()), 10.0, 1.0, false);
            navigator.getPathingOptions().setCanClimb(false);
            this.moveAwayStartPos = navigator.getOurEntity().func_233580_cy_();
            return;
        }
        if (this.stuckLevel == 2 && this.teleportRange > 0 && this.hadPath) {
            int index = Math.min(navigator.func_75505_d().func_75873_e() + this.teleportRange, navigator.func_75505_d().func_75874_d() - 1);
            PathPoint togo = navigator.func_75505_d().func_75877_a(index);
            navigator.getOurEntity().func_70634_a((double)togo.field_75839_a + 0.5, (double)togo.field_75837_b, (double)togo.field_75838_c + 0.5);
            this.delayToNextUnstuckAction = 300;
        }
        if (this.stuckLevel >= 3 && this.stuckLevel <= 5) {
            if (this.canPlaceLadders && this.rand.nextBoolean()) {
                this.delayToNextUnstuckAction = 200;
                this.placeLadders(navigator);
            } else if (this.canBuildLeafBridges && this.rand.nextBoolean()) {
                this.delayToNextUnstuckAction = 100;
                this.placeLeaves(navigator);
            }
        }
        if (this.stuckLevel >= 6 && this.stuckLevel <= 8 && this.canBreakBlocks) {
            this.delayToNextUnstuckAction = 200;
            this.breakBlocks(navigator);
        }
        this.chanceStuckLevel();
        if (this.stuckLevel == 9) {
            this.completeStuckAction(navigator);
            this.resetStuckTimers();
        }
    }

    private void chanceStuckLevel() {
        ++this.stuckLevel;
        if (this.stuckLevel > 1 && this.rand.nextInt(6) == 0) {
            this.stuckLevel -= 2;
        }
    }

    private void resetStuckTimers() {
        this.delayToNextUnstuckAction = this.delayBeforeActions;
        this.lastPathIndex = -1;
        this.progressedNodes = 0;
        this.stuckLevel = 0;
        this.moveAwayStartPos = BlockPos.field_177992_a;
    }

    private void breakBlocksAhead(World world, BlockPos start, Direction facing) {
        if (!world.func_175623_d(start.func_177981_b(3))) {
            this.setAirIfPossible(world, start.func_177981_b(3));
            return;
        }
        if (!world.func_175623_d(start.func_177984_a().func_177972_a(facing))) {
            this.setAirIfPossible(world, start.func_177984_a().func_177972_a(facing));
            return;
        }
        if (!world.func_175623_d(start.func_177972_a(facing))) {
            this.setAirIfPossible(world, start.func_177972_a(facing));
        }
    }

    private void setAirIfPossible(World world, BlockPos pos) {
        Block blockAtPos = world.func_180495_p(pos).func_177230_c();
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    private void placeLadders(AbstractAdvancedPathNavigate navigator) {
        World world = navigator.getOurEntity().field_70170_p;
        MobEntity entity = navigator.getOurEntity();
        BlockPos entityPos = entity.func_233580_cy_();
        while (world.func_180495_p(entityPos).func_177230_c() == Blocks.field_150468_ap) {
            entityPos = entityPos.func_177984_a();
        }
        this.tryPlaceLadderAt(world, entityPos);
        this.tryPlaceLadderAt(world, entityPos.func_177984_a());
        this.tryPlaceLadderAt(world, entityPos.func_177981_b(2));
    }

    private void placeLeaves(AbstractAdvancedPathNavigate navigator) {
        World world = navigator.getOurEntity().field_70170_p;
        MobEntity entity = navigator.getOurEntity();
        Direction badFacing = PathingStuckHandler.getFacing(entity.func_233580_cy_(), navigator.getDesiredPos()).func_176734_d();
        for (Direction dir : this.directions) {
            if (dir == badFacing || !world.func_175623_d(entity.func_233580_cy_().func_177977_b().func_177972_a(dir))) continue;
            world.func_175656_a(entity.func_233580_cy_().func_177977_b().func_177972_a(dir), Blocks.field_196572_aa.func_176223_P());
        }
    }

    public static Direction getFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.func_177973_b((Vector3i)pos);
        return Direction.func_176737_a((float)vector.func_177958_n(), (float)vector.func_177956_o(), (float)(-vector.func_177952_p()));
    }

    private void breakBlocks(AbstractAdvancedPathNavigate navigator) {
        World world = navigator.getOurEntity().field_70170_p;
        MobEntity entity = navigator.getOurEntity();
        Direction facing = PathingStuckHandler.getFacing(entity.func_233580_cy_(), navigator.getDesiredPos());
        this.breakBlocksAhead(world, entity.func_233580_cy_(), facing);
    }

    private void tryPlaceLadderAt(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != Blocks.field_150468_ap && !state.func_200132_m() && world.func_204610_c(pos).func_206888_e()) {
            for (Direction dir : this.directions) {
                BlockState toPlace = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)dir.func_176734_d());
                if (!world.func_180495_p(pos.func_177972_a(dir)).func_185904_a().func_76220_a() || !Blocks.field_150468_ap.func_196260_a(toPlace, (IWorldReader)world, pos)) continue;
                world.func_175656_a(pos, toPlace);
                break;
            }
        }
    }

    public PathingStuckHandler withBlockBreaks() {
        this.canBreakBlocks = true;
        return this;
    }

    public PathingStuckHandler withPlaceLadders() {
        this.canPlaceLadders = true;
        return this;
    }

    public PathingStuckHandler withBuildLeafBridges() {
        this.canBuildLeafBridges = true;
        return this;
    }

    public PathingStuckHandler withTeleportSteps(int steps) {
        this.teleportRange = steps;
        return this;
    }

    public PathingStuckHandler withTeleportOnFullStuck() {
        this.canTeleportGoal = true;
        return this;
    }

    public PathingStuckHandler withTakeDamageOnStuck(float damagePct) {
        this.damagePct = damagePct;
        this.takeDamageOnCompleteStuck = true;
        return this;
    }

    public PathingStuckHandler withTimePerBlockDistance(int time) {
        this.timePerBlockDistance = time;
        return this;
    }

    public PathingStuckHandler withDelayBeforeStuckActions(int delay) {
        this.delayBeforeActions = delay;
        return this;
    }

    public PathingStuckHandler withCompleteStuckBlockBreak(int range) {
        this.completeStuckBlockBreakRange = range;
        return this;
    }

    public static BlockPos findAround(World world, BlockPos start, int vRange, int hRange, BiPredicate<IBlockReader, BlockPos> predicate) {
        if (vRange < 1 && hRange < 1) {
            return null;
        }
        if (predicate.test((IBlockReader)world, start)) {
            return start;
        }
        int y = 0;
        int y_offset = 1;
        for (int i = 0; i < hRange + 2; ++i) {
            for (int steps = 1; steps <= vRange; ++steps) {
                int z;
                int x;
                BlockPos temp = start.func_177982_a(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((IBlockReader)world, temp = temp.func_177982_a(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((IBlockReader)world, temp = temp.func_177982_a(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((IBlockReader)world, temp = temp.func_177982_a(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((IBlockReader)world, temp = temp.func_177982_a(0, 0, -1))) continue;
                    return temp;
                }
            }
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            if (world.func_217301_I() > start.func_177956_o() + (y += (y_offset *= -1))) continue;
            return null;
        }
        return null;
    }
}

