/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.citadel.server.message.PacketBufferUtils;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPodium;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdatePodium {
    public long blockPos;
    public ItemStack heldStack;

    public MessageUpdatePodium(long blockPos, ItemStack heldStack) {
        this.blockPos = blockPos;
        this.heldStack = heldStack;
    }

    public MessageUpdatePodium() {
    }

    public static MessageUpdatePodium read(PacketBuffer buf) {
        return new MessageUpdatePodium(buf.readLong(), PacketBufferUtils.readItemStack((ByteBuf)buf));
    }

    public static void write(MessageUpdatePodium message, PacketBuffer buf) {
        buf.writeLong(message.blockPos);
        PacketBufferUtils.writeItemStack((ByteBuf)buf, (ItemStack)message.heldStack);
    }

    public static class Handler {
        public static void handle(MessageUpdatePodium message, Supplier<NetworkEvent.Context> context) {
            BlockPos pos;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null && player.field_70170_p.func_175625_s(pos = BlockPos.func_218283_e((long)message.blockPos)) != null && player.field_70170_p.func_175625_s(pos) instanceof TileEntityPodium) {
                TileEntityPodium podium = (TileEntityPodium)player.field_70170_p.func_175625_s(pos);
                podium.func_70299_a(0, message.heldStack);
            }
        }
    }
}

