/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.pathfinding.raycoms.Node;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncPathReached {
    public Set<BlockPos> reached = new HashSet<BlockPos>();

    public MessageSyncPathReached(Set<BlockPos> reached) {
        this.reached = reached;
    }

    public void write(PacketBuffer buf) {
        buf.writeInt(this.reached.size());
        for (BlockPos node : this.reached) {
            buf.func_179255_a(node);
        }
    }

    public static MessageSyncPathReached read(PacketBuffer buf) {
        int size = buf.readInt();
        HashSet<BlockPos> reached = new HashSet<BlockPos>();
        for (int i = 0; i < size; ++i) {
            reached.add(buf.func_179259_c());
        }
        return new MessageSyncPathReached(reached);
    }

    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                for (Node node : Pathfinding.lastDebugNodesPath) {
                    if (!this.reached.contains(node.pos)) continue;
                    node.setReachedByWorker(true);
                }
            }
        });
        return true;
    }
}

