/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemDragonHorn
extends Item {
    public ItemDragonHorn() {
        super(new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS).func_200917_a(1));
        this.setRegistryName("iceandfire", "dragon_horn");
    }

    public static int getDragonType(ItemStack stack) {
        String id;
        if (stack.func_77978_p() != null && EntityType.func_220327_a((String)(id = stack.func_77978_p().func_74779_i("DragonHornEntityID"))).isPresent()) {
            EntityType entityType = (EntityType)EntityType.func_220327_a((String)id).get();
            if (entityType == IafEntityRegistry.FIRE_DRAGON.get()) {
                return 1;
            }
            if (entityType == IafEntityRegistry.ICE_DRAGON.get()) {
                return 2;
            }
            if (entityType == IafEntityRegistry.LIGHTNING_DRAGON.get()) {
                return 3;
            }
        }
        return 0;
    }

    public void func_77622_d(ItemStack itemStack, World world, PlayerEntity player) {
        itemStack.func_77982_d(new CompoundNBT());
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        ItemStack trueStack = playerIn.func_184586_b(hand);
        if (!playerIn.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND && target instanceof EntityDragonBase && ((EntityDragonBase)target).func_152114_e((LivingEntity)playerIn) && (trueStack.func_77978_p() == null || trueStack.func_77978_p() != null && trueStack.func_77978_p().func_74775_l("EntityTag").isEmpty())) {
            CompoundNBT newTag = new CompoundNBT();
            CompoundNBT entityTag = new CompoundNBT();
            target.func_70039_c(entityTag);
            newTag.func_218657_a("EntityTag", (INBT)entityTag);
            newTag.func_74778_a("DragonHornEntityID", Registry.field_212629_r.func_177774_c((Object)((EntityDragonBase)target).func_200600_R()).toString());
            trueStack.func_77982_d(newTag);
            playerIn.func_184609_a(hand);
            playerIn.field_70170_p.func_184133_a(playerIn, playerIn.func_233580_cy_(), SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 3.0f, 0.75f);
            target.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_196000_l() != Direction.UP) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = context.func_195996_i();
        if (stack.func_77978_p() != null && !stack.func_77978_p().func_74779_i("DragonHornEntityID").isEmpty()) {
            World world = context.func_195991_k();
            String id = stack.func_77978_p().func_74779_i("DragonHornEntityID");
            EntityType type = EntityType.func_220327_a((String)id).orElse(null);
            if (type != null) {
                Entity entity = type.func_200721_a(world);
                if (entity instanceof EntityDragonBase) {
                    EntityDragonBase dragon = (EntityDragonBase)entity;
                    dragon.func_70020_e(stack.func_77978_p().func_74775_l("EntityTag"));
                }
                if (stack.func_77978_p().func_74764_b("EntityUUID")) {
                    entity.func_184221_a(stack.func_77978_p().func_186857_a("EntityUUID"));
                }
                entity.func_70080_a((double)context.func_195995_a().func_177958_n() + 0.5, (double)(context.func_195995_a().func_177956_o() + 1), (double)context.func_195995_a().func_177952_p() + 0.5, 180.0f + context.func_195992_f().func_185119_l(), 0.0f);
                if (world.func_217376_c(entity)) {
                    CompoundNBT tag = stack.func_77978_p();
                    tag.func_82580_o("DragonHornEntityID");
                    tag.func_82580_o("EntityTag");
                    tag.func_82580_o("EntityUUID");
                    stack.func_77982_d(tag);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String id;
        CompoundNBT entityTag;
        if (stack.func_77978_p() != null && !(entityTag = stack.func_77978_p().func_74775_l("EntityTag")).isEmpty() && EntityType.func_220327_a((String)(id = stack.func_77978_p().func_74779_i("DragonHornEntityID"))).isPresent()) {
            IFormattableTextComponent component;
            EntityType type = (EntityType)EntityType.func_220327_a((String)id).get();
            tooltip.add((ITextComponent)new TranslationTextComponent(type.func_210760_d()).func_240699_a_(this.getTextColorForEntityType(type)));
            String name = new TranslationTextComponent("dragon.unnamed").getString();
            if (!entityTag.func_74779_i("CustomName").isEmpty() && (component = ITextComponent.Serializer.func_240643_a_((String)entityTag.func_74779_i("CustomName"))) != null) {
                name = component.getString();
            }
            tooltip.add((ITextComponent)new StringTextComponent(name).func_240699_a_(TextFormatting.GRAY));
            String gender = new TranslationTextComponent("dragon.gender").getString() + " " + new TranslationTextComponent(entityTag.func_74767_n("Gender") ? "dragon.gender.male" : "dragon.gender.female").getString();
            tooltip.add((ITextComponent)new StringTextComponent(gender).func_240699_a_(TextFormatting.GRAY));
            int stagenumber = entityTag.func_74762_e("AgeTicks") / 24000;
            int stage1 = 0;
            stage1 = stagenumber >= 100 ? 5 : (stagenumber >= 75 ? 4 : (stagenumber >= 50 ? 3 : (stagenumber >= 25 ? 2 : 1)));
            String stage = new TranslationTextComponent("dragon.stage").getString() + " " + stage1 + " " + new TranslationTextComponent("dragon.days.front").getString() + stagenumber + " " + new TranslationTextComponent("dragon.days.back").getString();
            tooltip.add((ITextComponent)new StringTextComponent(stage).func_240699_a_(TextFormatting.GRAY));
        }
    }

    private TextFormatting getTextColorForEntityType(EntityType type) {
        if (type == IafEntityRegistry.FIRE_DRAGON.get()) {
            return TextFormatting.DARK_RED;
        }
        if (type == IafEntityRegistry.ICE_DRAGON.get()) {
            return TextFormatting.BLUE;
        }
        if (type == IafEntityRegistry.LIGHTNING_DRAGON.get()) {
            return TextFormatting.DARK_PURPLE;
        }
        return TextFormatting.GRAY;
    }
}

