/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.props.MiscProperties;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemCockatriceScepter
extends Item {
    private final Random rand = new Random();
    private int specialWeaponDmg;

    public ItemCockatriceScepter() {
        super(new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS).func_200918_c(700));
        this.setRegistryName("iceandfire", "cockatrice_scepter");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.legendary_weapon.desc").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.cockatrice_scepter.desc_0").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.cockatrice_scepter.desc_1").func_240699_a_(TextFormatting.GRAY));
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity livingEntity, int timeLeft) {
        if (this.specialWeaponDmg > 0) {
            stack.func_222118_a(this.specialWeaponDmg, livingEntity, player -> player.func_213334_d(livingEntity.func_184600_cs()));
            this.specialWeaponDmg = 0;
        }
        MiscProperties.getTargeting(livingEntity).forEach(target -> MiscProperties.removeTargetedBy(livingEntity, target));
        MiscProperties.removeTargets(livingEntity);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        playerIn.func_184598_c(hand);
        return new ActionResult(ActionResultType.PASS, (Object)itemStackIn);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof PlayerEntity) {
            double dist = 32.0;
            Vector3d playerEyePosition = player.func_174824_e(1.0f);
            Vector3d playerLook = player.func_70676_i(1.0f);
            Vector3d Vector3d2 = playerEyePosition.func_72441_c(playerLook.field_72450_a * dist, playerLook.field_72448_b * dist, playerLook.field_72449_c * dist);
            Entity pointedEntity = null;
            List nearbyEntities = player.field_70170_p.func_175674_a((Entity)player, player.func_174813_aQ().func_72321_a(playerLook.field_72450_a * dist, playerLook.field_72448_b * dist, playerLook.field_72449_c * dist).func_72314_b(1.0, 1.0, 1.0), (Predicate)new Predicate<Entity>(){

                @Override
                public boolean test(Entity entity) {
                    boolean blindness = entity instanceof LivingEntity && ((LivingEntity)entity).func_70644_a(Effects.field_76440_q) || entity instanceof IBlacklistedFromStatues && !((IBlacklistedFromStatues)entity).canBeTurnedToStone();
                    return entity != null && entity.func_70067_L() && !blindness && (entity instanceof PlayerEntity || entity instanceof LivingEntity && DragonUtils.isAlive((LivingEntity)entity));
                }
            });
            double d2 = dist;
            for (Entity nearbyEntity : nearbyEntities) {
                double d3;
                AxisAlignedBB axisalignedbb = nearbyEntity.func_174813_aQ().func_186662_g((double)nearbyEntity.func_70111_Y());
                Optional optional = axisalignedbb.func_216365_b(playerEyePosition, Vector3d2);
                if (axisalignedbb.func_72318_a(playerEyePosition)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = nearbyEntity;
                    d2 = 0.0;
                    continue;
                }
                if (!optional.isPresent() || !((d3 = playerEyePosition.func_72438_d((Vector3d)optional.get())) < d2) && d2 != 0.0) continue;
                if (nearbyEntity.func_184208_bv() == player.func_184208_bv() && !player.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = nearbyEntity;
                    continue;
                }
                pointedEntity = nearbyEntity;
                d2 = d3;
            }
            if (pointedEntity instanceof LivingEntity) {
                if (!pointedEntity.func_70089_S()) {
                    return;
                }
                MiscProperties.addScepterTargetData(player, (LivingEntity)pointedEntity);
            }
            this.attackTargets(player);
        }
    }

    private void attackTargets(LivingEntity caster) {
        List<LivingEntity> targets = MiscProperties.getTargeting(caster);
        for (LivingEntity target : targets) {
            if (!EntityGorgon.isEntityLookingAt(caster, target, 0.2f) || !caster.func_70089_S()) {
                MiscProperties.removeTargetedBy(caster, target);
                MiscProperties.removeTarget(caster, target);
            }
            target.func_195064_c(new EffectInstance(Effects.field_82731_v, 40, 2));
            if (caster.field_70173_aa % 20 == 0) {
                ++this.specialWeaponDmg;
                target.func_70097_a(DamageSource.field_82727_n, 2.0f);
            }
            this.drawParticleBeam(caster, target);
            if (target.func_70089_S()) continue;
            MiscProperties.removeTarget(caster, target);
        }
    }

    private void drawParticleBeam(LivingEntity origin, LivingEntity target) {
        double d5 = 80.0;
        double d0 = target.func_226277_ct_() - origin.func_226277_ct_();
        double d1 = target.func_226278_cu_() + (double)(target.func_213302_cg() * 0.5f) - (origin.func_226278_cu_() + (double)origin.func_70047_e() * 0.5);
        double d2 = target.func_226281_cx_() - origin.func_226281_cx_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = this.rand.nextDouble();
        while (d4 < d3) {
            origin.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, origin.func_226277_ct_() + d0 * (d4 += 1.0), origin.func_226278_cu_() + d1 * d4 + (double)origin.func_70047_e() * 0.5, origin.func_226281_cx_() + d2 * d4, 0.0, 0.0, 0.0);
        }
    }
}

