/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.tile.IafTileEntityRegistry;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public class TileEntityEggInIce
extends TileEntity
implements ITickableTileEntity {
    public EnumDragonEgg field_200663_e;
    public int age;
    public int ticksExisted;
    private boolean spawned;
    @Nullable
    public UUID ownerUUID;

    public TileEntityEggInIce() {
        super((TileEntityType)IafTileEntityRegistry.EGG_IN_ICE.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.field_200663_e != null) {
            tag.func_74774_a("Color", (byte)this.field_200663_e.ordinal());
        } else {
            tag.func_74774_a("Color", (byte)0);
        }
        tag.func_74768_a("Age", this.age);
        if (this.ownerUUID == null) {
            tag.func_74778_a("OwnerUUID", "");
        } else {
            tag.func_186854_a("OwnerUUID", this.ownerUUID);
        }
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.field_200663_e = EnumDragonEgg.values()[tag.func_74771_c("Color")];
        this.age = tag.func_74762_e("Age");
        UUID s = null;
        if (tag.func_186855_b("OwnerUUID")) {
            s = tag.func_186857_a("OwnerUUID");
        } else {
            try {
                String s1 = tag.func_74779_i("OwnerUUID");
                s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.field_145850_b.func_73046_m(), (String)s1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s != null) {
            this.ownerUUID = s;
        }
    }

    public void handleUpdateTag(BlockState blockState, CompoundNBT parentNBTTagCompound) {
        this.func_230337_a_(blockState, parentNBTTagCompound);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.func_230337_a_(blockState, pkt.func_148857_g());
    }

    public void spawnEgg() {
        if (this.field_200663_e != null) {
            EntityDragonEgg egg = new EntityDragonEgg((EntityType)IafEntityRegistry.DRAGON_EGG.get(), this.field_145850_b);
            egg.setEggType(this.field_200663_e);
            egg.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5);
            egg.setOwnerId(this.ownerUUID);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_217376_c((Entity)egg);
            }
        }
    }

    public void func_73660_a() {
        ++this.age;
        if (this.age >= IafConfig.dragonEggTime && this.field_200663_e != null && !this.spawned && !this.field_145850_b.field_72995_K) {
            EntityIceDragon dragon = new EntityIceDragon(this.field_145850_b);
            dragon.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5);
            dragon.setVariant(this.field_200663_e.ordinal() - 4);
            dragon.setGender(ThreadLocalRandom.current().nextBoolean());
            dragon.func_70903_f(true);
            dragon.setHunger(50);
            dragon.func_184754_b(this.ownerUUID);
            this.field_145850_b.func_217376_c((Entity)dragon);
            this.spawned = true;
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150355_j.func_176223_P());
        }
        ++this.ticksExisted;
    }
}

