/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.block.BlockDragonforgeInput;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.tile.IafTileEntityRegistry;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityDragonforgeInput
extends TileEntity
implements ITickableTileEntity {
    private static final int LURE_DISTANCE = 50;
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private int ticksSinceDragonFire;
    private TileEntityDragonforge core = null;

    public TileEntityDragonforgeInput() {
        super((TileEntityType)IafTileEntityRegistry.DRAGONFORGE_INPUT.get());
    }

    public void onHitWithFlame() {
        if (this.core != null) {
            this.core.transferPower(1);
        }
    }

    public void func_73660_a() {
        if (this.core == null) {
            this.core = this.getConnectedTileEntity();
        }
        if (this.ticksSinceDragonFire > 0) {
            --this.ticksSinceDragonFire;
        }
        if ((this.ticksSinceDragonFire == 0 || this.core == null) && this.isActive()) {
            TileEntity tileentity = this.field_145850_b.func_175625_s(this.field_174879_c);
            this.field_145850_b.func_175656_a(this.field_174879_c, this.getDeactivatedState());
            if (tileentity != null) {
                tileentity.func_145829_t();
                this.field_145850_b.func_175690_a(this.field_174879_c, tileentity);
            }
        }
        if (this.isAssembled()) {
            this.lureDragons();
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    protected void lureDragons() {
        Vector3d targetPosition = new Vector3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f));
        AxisAlignedBB searchArea = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 50.0, (double)this.field_174879_c.func_177956_o() - 50.0, (double)this.field_174879_c.func_177952_p() - 50.0, (double)this.field_174879_c.func_177958_n() + 50.0, (double)this.field_174879_c.func_177956_o() + 50.0, (double)this.field_174879_c.func_177952_p() + 50.0);
        boolean dragonSelected = false;
        for (EntityDragonBase dragon : this.field_145850_b.func_217357_a(EntityDragonBase.class, searchArea)) {
            if (!dragonSelected && this.getDragonType() == DragonType.getIntFromType(dragon.dragonType) && (dragon.isChained() || dragon.func_70909_n()) && this.canSeeInput(dragon, targetPosition)) {
                dragon.burningTarget = this.field_174879_c;
                dragonSelected = true;
                continue;
            }
            if (dragon.burningTarget != this.field_174879_c) continue;
            dragon.burningTarget = null;
            dragon.setBreathingFire(false);
        }
    }

    public boolean isAssembled() {
        return this.core != null && this.core.assembled() && this.core.canSmelt();
    }

    public void resetCore() {
        this.core = null;
    }

    private boolean canSeeInput(EntityDragonBase dragon, Vector3d target) {
        BlockRayTraceResult rayTrace;
        if (target != null && (rayTrace = this.field_145850_b.func_217299_a(new RayTraceContext(dragon.getHeadPosition(), target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)dragon))) != null && rayTrace.func_216347_e() != null) {
            double distance = dragon.getHeadPosition().func_72438_d(rayTrace.func_216347_e());
            return distance < (double)(10.0f + dragon.func_213311_cf());
        }
        return false;
    }

    private BlockState getDeactivatedState() {
        switch (this.getDragonType()) {
            case 0: {
                return (BlockState)IafBlockRegistry.DRAGONFORGE_FIRE_INPUT.func_176223_P().func_206870_a((Property)BlockDragonforgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            }
            case 1: {
                return (BlockState)IafBlockRegistry.DRAGONFORGE_ICE_INPUT.func_176223_P().func_206870_a((Property)BlockDragonforgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            }
            case 2: {
                return (BlockState)IafBlockRegistry.DRAGONFORGE_LIGHTNING_INPUT.func_176223_P().func_206870_a((Property)BlockDragonforgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            }
        }
        return (BlockState)IafBlockRegistry.DRAGONFORGE_FIRE_INPUT.func_176223_P().func_206870_a((Property)BlockDragonforgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    private int getDragonType() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == IafBlockRegistry.DRAGONFORGE_FIRE_INPUT) {
            return 0;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == IafBlockRegistry.DRAGONFORGE_ICE_INPUT) {
            return 1;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == IafBlockRegistry.DRAGONFORGE_LIGHTNING_INPUT) {
            return 2;
        }
        return 0;
    }

    private boolean isActive() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockDragonforgeInput && (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)BlockDragonforgeInput.ACTIVE) != false;
    }

    private TileEntityDragonforge getConnectedTileEntity() {
        for (Direction facing : HORIZONTALS) {
            if (!(this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)) instanceof TileEntityDragonforge)) continue;
            return (TileEntityDragonforge)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        }
        return null;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.core != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.core.getCapability(capability, facing);
        }
        return super.getCapability(capability, facing);
    }
}

