/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.MathHelper;

public class SirenProperties {
    private static final String SIREN_DATA = "SirenDataIaf";
    private static final String SIREN_CHARMED = "IsCharmed";
    private static final String SIREN_ID = "CharmedBy";
    private static final String SIREN_TIME = "CharmeTime";
    private static final Random rand = new Random();

    private static CompoundNBT getOrCreateCharmData(LivingEntity entity) {
        return SirenProperties.getOrCreateCharmData(CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static CompoundNBT getOrCreateCharmData(CompoundNBT entityData) {
        if (entityData.func_150297_b(SIREN_DATA, 10)) {
            return (CompoundNBT)entityData.func_74781_a(SIREN_DATA);
        }
        return SirenProperties.createDefaultData();
    }

    private static void clearCharmedStatus(LivingEntity entity) {
        CompoundNBT charmData = SirenProperties.getOrCreateCharmData(entity);
        SirenProperties.clearCharmedStatus(charmData);
        SirenProperties.updateCharmData(entity, charmData);
    }

    private static CompoundNBT clearCharmedStatus(CompoundNBT nbt) {
        nbt.func_74768_a(SIREN_TIME, 0);
        nbt.func_74757_a(SIREN_CHARMED, false);
        nbt.func_74768_a(SIREN_ID, -1);
        return nbt;
    }

    private static CompoundNBT createDefaultData() {
        CompoundNBT nbt = new CompoundNBT();
        return SirenProperties.clearCharmedStatus(nbt);
    }

    public static void updateData(LivingEntity entity) {
        SirenProperties.updateData(entity, CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static void updateData(LivingEntity entity, CompoundNBT nbt) {
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundNBT)nbt);
        if (!entity.field_70170_p.func_201670_d()) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelPatreonConfig", nbt, entity.func_145782_y()));
        }
    }

    private static void updateCharmData(LivingEntity entity, CompoundNBT nbt) {
        CompoundNBT entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        entityData.func_218657_a(SIREN_DATA, (INBT)nbt);
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundNBT)entityData);
        if (!entity.field_70170_p.func_201670_d()) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelPatreonConfig", entityData, entity.func_145782_y()));
        }
    }

    private static int getSingTime(LivingEntity entity) {
        CompoundNBT nbt = SirenProperties.getOrCreateCharmData(entity);
        if (nbt.func_74764_b(SIREN_TIME)) {
            return nbt.func_74762_e(SIREN_TIME);
        }
        return 0;
    }

    public static void setCharmedBy(LivingEntity entity, LivingEntity charmedBy) {
        CompoundNBT nbt = SirenProperties.getOrCreateCharmData(entity);
        nbt.func_74768_a(SIREN_ID, charmedBy.func_145782_y());
        nbt.func_74757_a(SIREN_CHARMED, true);
        SirenProperties.updateCharmData(entity, nbt);
    }

    private static int getCharmedBy(LivingEntity entity) {
        CompoundNBT nbt = SirenProperties.getOrCreateCharmData(entity);
        if (nbt.func_74764_b(SIREN_ID)) {
            return nbt.func_74762_e(SIREN_ID);
        }
        return -1;
    }

    @Nullable
    public static EntitySiren getSiren(LivingEntity entity) {
        Entity siren = entity.field_70170_p.func_73045_a(SirenProperties.getCharmedBy(entity));
        if (siren instanceof EntitySiren) {
            return (EntitySiren)siren;
        }
        return null;
    }

    public static boolean isCharmed(LivingEntity entity) {
        CompoundNBT nbt = SirenProperties.getOrCreateCharmData(entity);
        if (!nbt.func_74764_b(SIREN_CHARMED)) {
            nbt = SirenProperties.createDefaultData();
            SirenProperties.updateCharmData(entity, nbt);
        }
        return nbt.func_74767_n(SIREN_CHARMED);
    }

    public static void tickCharmedEntity(LivingEntity entity) {
        EntitySiren siren = SirenProperties.getSiren(entity);
        if (siren != null && siren.isActuallySinging()) {
            if (EntitySiren.isWearingEarplugs(entity) || SirenProperties.getSingTime(entity) > IafConfig.sirenMaxSingTime) {
                SirenProperties.clearCharmedStatus(entity);
                siren.singCooldown = IafConfig.sirenTimeBetweenSongs;
            } else {
                if (!siren.func_70089_S() || entity.func_70032_d((Entity)siren) > 64.0f || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_()) {
                    SirenProperties.clearCharmedStatus(entity);
                    return;
                }
                if ((double)entity.func_70032_d((Entity)siren) < 5.0) {
                    SirenProperties.clearCharmedStatus(entity);
                    siren.singCooldown = IafConfig.sirenTimeBetweenSongs;
                    siren.setSinging(false);
                    siren.func_70624_b(entity);
                    siren.setAggressive(true);
                    siren.triggerOtherSirens(entity);
                    return;
                }
                CompoundNBT sirenData = SirenProperties.getOrCreateCharmData(entity);
                sirenData.func_74757_a(SIREN_CHARMED, true);
                sirenData.func_74768_a(SIREN_TIME, SirenProperties.getSingTime(entity));
                SirenProperties.updateCharmData(entity, sirenData);
                if (rand.nextInt(7) == 0) {
                    for (int i = 0; i < 5; ++i) {
                        entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, entity.func_226277_ct_() + (rand.nextDouble() - 0.5) * 3.0, entity.func_226278_cu_() + (rand.nextDouble() - 0.5) * 3.0, entity.func_226281_cx_() + (rand.nextDouble() - 0.5) * 3.0, 0.0, 0.0, 0.0);
                    }
                }
                if (entity.field_70123_F) {
                    entity.func_70637_d(true);
                }
                double motionXAdd = (Math.signum(siren.func_226277_ct_() - entity.func_226277_ct_()) * 0.5 - entity.func_213322_ci().field_72450_a) * 0.100000000372529;
                double motionYAdd = (Math.signum(siren.func_226278_cu_() - entity.func_226278_cu_() + 1.0) * 0.5 - entity.func_213322_ci().field_72448_b) * 0.100000000372529;
                double motionZAdd = (Math.signum(siren.func_226281_cx_() - entity.func_226281_cx_()) * 0.5 - entity.func_213322_ci().field_72449_c) * 0.100000000372529;
                entity.func_213317_d(entity.func_213322_ci().func_72441_c(motionXAdd, motionYAdd, motionZAdd));
                if (entity.func_184218_aH()) {
                    entity.func_184210_p();
                }
                if (!(entity instanceof PlayerEntity)) {
                    double d0 = siren.func_226277_ct_() - entity.func_226277_ct_();
                    double d2 = siren.func_226281_cx_() - entity.func_226281_cx_();
                    double d1 = siren.func_226278_cu_() - 1.0 - entity.func_226278_cu_();
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                    entity.field_70125_A = SirenProperties.updateRotation(entity.field_70125_A, f1, 30.0f);
                    entity.field_70177_z = SirenProperties.updateRotation(entity.field_70177_z, f, 30.0f);
                }
            }
        }
    }

    public static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }
}

