/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;

public class ChickenProperties {
    private static final String CHICKEN_DATA = "TimeUntilNextEggIaf";
    private static final Random rand = new Random();

    private static int createDefaultTime() {
        return rand.nextInt(6000) + 6000;
    }

    private static CompoundNBT createDefaultData(CompoundNBT nbt) {
        nbt.func_74768_a(CHICKEN_DATA, ChickenProperties.createDefaultTime());
        return nbt;
    }

    public static int getTimeRemaining(LivingEntity entity) {
        CompoundNBT nbt = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (!nbt.func_74764_b(CHICKEN_DATA)) {
            ChickenProperties.createDefaultData(nbt);
            CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundNBT)nbt);
        }
        return nbt.func_74762_e(CHICKEN_DATA);
    }

    public static void setTimeRemaining(LivingEntity entity, int time) {
        CompoundNBT nbt = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        nbt.func_74768_a(CHICKEN_DATA, time);
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundNBT)nbt);
    }

    public static void tickChicken(LivingEntity entity) {
        int timeUntilNextEgg = ChickenProperties.getTimeRemaining(entity);
        if (timeUntilNextEgg <= 0) {
            if (entity.func_70681_au().nextInt(IafConfig.cockatriceEggChance + 1) == 0 && entity.field_70173_aa > 30) {
                entity.func_184185_a(SoundEvents.field_187666_Z, 2.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
                entity.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
                entity.func_199702_a((IItemProvider)IafItemRegistry.ROTTEN_EGG, 1);
            }
            ChickenProperties.setTimeRemaining(entity, ChickenProperties.createDefaultTime());
        } else {
            ChickenProperties.setTimeRemaining(entity, timeUntilNextEgg - 1);
        }
    }
}

